/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;
import com.sap.mw.jco.util.SAPConverters;

public class Converter {
    private static char[] ZERO_ARRAY = "\u0000\u0000\u0000\u0000".toCharArray();
    SAPCharToByteConverter c2bConverter;
    SAPByteToCharConverter b2cConverter;
    boolean littleEndian;

    public Converter() {
        this("4102", "4102", false);
    }

    public Converter(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.c2bConverter = SAPConverters.getSAPCharToByteConverter(sendCodepage);
        this.b2cConverter = SAPConverters.getSAPByteToCharConverter(receiveCodepage);
        this.littleEndian = littleEndian;
    }

    public final String getSendCodepage() {
        if (this.c2bConverter != null) {
            return this.c2bConverter.getCharacterEncoding();
        }
        return null;
    }

    public final String getReceiveCodepage() {
        if (this.b2cConverter != null) {
            return this.b2cConverter.getCharacterEncoding();
        }
        return null;
    }

    public final boolean isLittleEndian() {
        return this.littleEndian;
    }

    protected final void encodeNumber(JCO.Record rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        int end = offset + ilength - 1;
        System.arraycopy(ZERO_ARRAY, 0, temp_data, iboffset, rec.blength[index]);
        if (ilength > 2 * rec.blength[index]) {
            ilength = 2 * rec.blength[index];
        }
        if (this.littleEndian) {
            int k = 0;
            while (k < ilength) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
                ++k;
            }
        } else {
            int k = 0;
            while (k < ilength) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
                ++k;
            }
        }
    }

    protected final void encodeBinary(JCO.Record rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        int iend = iboffset + rec.blength[index];
        int i = iboffset;
        while (i < iend) {
            temp_data[i] = '\u0000';
            ++i;
        }
        if (ilength > 2 * rec.blength[index]) {
            ilength = 2 * rec.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            int n = iboffset + (k >> 1);
            temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
            ++k;
        }
    }

    protected final void encodeChar(JCO.Record rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        int iend = iboffset + rec.blength[index];
        int filledChars = this.b2cConverter.convert(value, offset, offset + ilength - 1, temp_data, iboffset, iend - 1);
        int i = iboffset + filledChars;
        while (i < iend) {
            temp_data[i] = 32;
            ++i;
        }
    }

    protected final void decodeNumber(JCO.Record rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        if (ilength > 2 * rec.blength[index]) {
            ilength = 2 * rec.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            ++k;
        }
    }

    protected final void decodeBinary(JCO.Record rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        if (ilength > 2 * rec.blength[index]) {
            ilength = 2 * rec.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            ++k;
        }
    }

    protected final void decodeChar(JCO.Record rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = (rec.rec_type & 4) != 0 ? rec.table_data_rows[rec.row] : rec.data;
        int iboffset = rec.boffset[index];
        int iend = iboffset + rec.blength[index];
        this.c2bConverter.convert(temp_data, iboffset, iend - 1, buffer, offset, offset + ilength - 1);
    }

    protected final void encodeNestedType1Number(JCO.Record rec, byte[] value, int index) {
        int iboffset = rec.type1_data.boffset[index];
        int ilength = rec.type1_data.length[index];
        int end = rec.type1_data.offset[index] + rec.type1_data.length[index] - 1;
        System.arraycopy(ZERO_ARRAY, 0, rec.type1_record.data, iboffset, rec.type1_data.blength[index]);
        if (ilength > 2 * rec.type1_data.blength[index]) {
            ilength = 2 * rec.type1_data.blength[index];
        }
        if (this.littleEndian) {
            int k = 0;
            while (k < ilength) {
                int n = iboffset + (k >> 1);
                rec.type1_record.data[n] = (char)(rec.type1_record.data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
                ++k;
            }
        } else {
            int k = 0;
            while (k < ilength) {
                int n = iboffset + (k >> 1);
                rec.type1_record.data[n] = (char)(rec.type1_record.data[n] | (char)((value[rec.type1_data.offset[index] + k] & 0xFF) << (1 - (k & 1) << 3)));
                ++k;
            }
        }
    }

    protected final void encodeNestedType1Binary(JCO.Record rec, byte[] value, int index) {
        int iboffset = rec.type1_data.boffset[index];
        int ilength = rec.type1_data.length[index];
        int iend = iboffset + rec.type1_data.blength[index];
        int i = iboffset;
        while (i < iend) {
            rec.type1_record.data[i] = '\u0000';
            ++i;
        }
        if (ilength > 2 * rec.type1_data.blength[index]) {
            ilength = 2 * rec.type1_data.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            int n = iboffset + (k >> 1);
            rec.type1_record.data[n] = (char)(rec.type1_record.data[n] | (char)((value[rec.type1_data.offset[index] + k] & 0xFF) << (1 - (k & 1) << 3)));
            ++k;
        }
    }

    protected final void encodeNestedType1Char(JCO.Record rec, byte[] value, int index) {
        int iboffset = rec.type1_data.boffset[index];
        int iend = iboffset + rec.type1_data.blength[index];
        int filledChars = this.b2cConverter.convert(value, rec.type1_data.offset[index], rec.type1_data.offset[index] + rec.type1_data.length[index] - 1, rec.type1_record.data, iboffset, iend - 1);
        int i = iboffset + filledChars;
        while (i < iend) {
            rec.type1_record.data[i] = 32;
            ++i;
        }
    }

    protected final void decodeNestedType1Number(JCO.Record rec, byte[] buffer, int index) {
        int iboffset = rec.type1_data.boffset[index];
        int ilength = rec.type1_data.length[index];
        if (ilength > 2 * rec.type1_data.blength[index]) {
            ilength = 2 * rec.type1_data.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            buffer[rec.type1_data.offset[index] + k] = (byte)(rec.type1_record.data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            ++k;
        }
    }

    protected final void decodeNestedType1Binary(JCO.Record rec, byte[] buffer, int index) {
        int ilength = rec.type1_data.length[index];
        if (ilength > 2 * rec.type1_data.blength[index]) {
            ilength = 2 * rec.type1_data.blength[index];
        }
        int k = 0;
        while (k < ilength) {
            buffer[rec.type1_data.offset[index] + k] = (byte)(rec.type1_record.data[rec.type1_data.boffset[index] + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            ++k;
        }
    }

    protected final void decodeNestedType1Char(JCO.Record rec, byte[] buffer, int index) {
        int iboffset = rec.type1_data.boffset[index];
        int iend = iboffset + rec.type1_data.blength[index];
        this.c2bConverter.convert(rec.type1_record.data, iboffset, iend - 1, buffer, rec.type1_data.offset[index], rec.type1_data.offset[index] + rec.type1_data.length[index] - 1);
    }
}

