/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.exampleprojects;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectMessages;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectsPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExampleProjectCreationWizardPage
extends WizardPage {
    private IStatus fCurrStatus = ExampleProjectCreationWizardPage.createStatus(0, "");
    private boolean fPageVisible;
    private IConfigurationElement fConfigurationElement;
    private String fNameLabel;
    private String fProjectName;
    private Text fTextControl;

    public ExampleProjectCreationWizardPage(int pageNumber, IConfigurationElement elem) {
        super("page" + pageNumber);
        this.fConfigurationElement = elem;
        this.setTitle(this.getAttribute(elem, "pagetitle"));
        this.setDescription(this.getAttribute(elem, "pagedescription"));
        this.fNameLabel = this.getAttribute(elem, "label");
        this.fProjectName = this.getAttribute(elem, "name");
    }

    private String getAttribute(IConfigurationElement elem, String tag) {
        String res = elem.getAttribute(tag);
        if (res == null) {
            return String.valueOf('!') + tag + '!';
        }
        return res;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 2;
        composite.setLayout((Layout)gd);
        Label label = new Label(composite, 16384);
        label.setText(this.fNameLabel);
        label.setLayoutData((Object)new GridData());
        this.fTextControl = new Text(composite, 2052);
        this.fTextControl.setText(this.fProjectName);
        this.fTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ExampleProjectCreationWizardPage.this.fTextControl.isDisposed()) {
                    ExampleProjectCreationWizardPage.this.validateText(ExampleProjectCreationWizardPage.this.fTextControl.getText());
                }
            }
        });
        this.fTextControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    private void validateText(String text) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(text, 4);
        if (status.isOK() && workspace.getRoot().getProject(text).exists()) {
            status = ExampleProjectCreationWizardPage.createStatus(4, ExampleProjectMessages.getString("ExampleProjectCreationWizardPage.error.alreadyexists"));
        }
        this.updateStatus(status);
        this.fProjectName = text;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
        if (visible && this.fCurrStatus.matches(4)) {
            this.fCurrStatus = ExampleProjectCreationWizardPage.createStatus(4, "");
        }
        this.updateStatus(this.fCurrStatus);
    }

    private void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            ExampleProjectCreationWizardPage.applyToStatusLine((DialogPage)this, status);
        }
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        page.setErrorMessage(errorMessage);
        page.setMessage(warningMessage);
    }

    private static IStatus createStatus(int severity, String message) {
        return new Status(severity, ExampleProjectsPlugin.getPluginId(), severity, message, null);
    }

    public String getName() {
        return this.fProjectName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }
}

