/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.exampleprojects;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectCreationOperation;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectCreationWizardPage;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectMessages;
import org.eclipse.jdt.internal.ui.exampleprojects.ExampleProjectsPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ExampleProjectCreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    private ExampleProjectCreationWizardPage[] fPages;
    private IConfigurationElement fConfigElement;

    public ExampleProjectCreationWizard() {
        this.setDialogSettings(ExampleProjectsPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(ExampleProjectMessages.getString("ExampleProjectCreationWizard.title"));
        this.setNeedsProgressMonitor(true);
    }

    protected void initializeDefaultPageImageDescriptor() {
        String banner;
        if (this.fConfigElement != null && (banner = this.fConfigElement.getAttribute("banner")) != null) {
            ImageDescriptor desc = ExampleProjectsPlugin.getDefault().getImageDescriptor(banner);
            this.setDefaultPageImageDescriptor(desc);
        }
    }

    public void addPages() {
        super.addPages();
        IConfigurationElement[] children = this.fConfigElement.getChildren("projectsetup");
        if (children == null || children.length == 0) {
            ExampleProjectsPlugin.log("descriptor must contain one ore more projectsetup tags");
            return;
        }
        this.fPages = new ExampleProjectCreationWizardPage[children.length];
        int i = 0;
        while (i < children.length) {
            IConfigurationElement cfr_ignored_0 = children[i];
            this.fPages[i] = new ExampleProjectCreationWizardPage(i, children[i]);
            this.addPage((IWizardPage)this.fPages[i]);
            ++i;
        }
    }

    public boolean performFinish() {
        ExampleProjectCreationOperation runnable = new ExampleProjectCreationOperation(this.fPages, new ImportOverwriteQuery());
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        IResource res = runnable.getElementToOpen();
        if (res != null) {
            this.openResource(res);
        }
        return true;
    }

    private void handleException(Throwable target) {
        String title = ExampleProjectMessages.getString("ExampleProjectCreationWizard.op_error.title");
        String message = ExampleProjectMessages.getString("ExampleProjectCreationWizard.op_error.message");
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            ExampleProjectsPlugin.log(status);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)target.getMessage());
            ExampleProjectsPlugin.log(target);
        }
    }

    private void openResource(final IResource resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = ExampleProjectsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        activePage.openEditor((IFile)resource);
                    }
                    catch (PartInitException e) {
                        ExampleProjectsPlugin.log(e);
                    }
                }
            });
            this.selectAndReveal(resource);
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(String file) {
            int[] result = new int[]{1};
            ExampleProjectCreationWizard.this.getShell().getDisplay().syncExec(new Runnable(this, file, result){
                private final /* synthetic */ String val$file;
                private final /* synthetic */ ImportOverwriteQuery this$1;
                private final /* synthetic */ int[] val$result;
                {
                    this.this$1 = importOverwriteQuery;
                    this.val$file = string;
                    this.val$result = nArray;
                }

                public void run() {
                    String title = ExampleProjectMessages.getString("ExampleProjectCreationWizard.overwritequery.title");
                    String msg = ExampleProjectMessages.getFormattedString("ExampleProjectCreationWizard.overwritequery.message", this.val$file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ImportOverwriteQuery.access$0(this.this$1).getShell(), title, null, msg, 3, options, 0);
                    this.val$result[0] = dialog.open();
                }
            });
            return result[0];
        }

        static /* synthetic */ ExampleProjectCreationWizard access$0(ImportOverwriteQuery importOverwriteQuery) {
            return importOverwriteQuery.ExampleProjectCreationWizard.this;
        }
    }
}

