/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.types;

import com.sap.sql.types.CommonTypes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;

public class CommonJdbcType
extends CommonTypes
implements Serializable {
    private int typeCode;
    private transient Class defaultJavaClass;
    private transient HashSet allowedClasses;
    public transient boolean isApproxNumeric;
    public transient boolean isBinary;
    public transient boolean isCharacterLike;
    public transient boolean isDatetimeLike;
    public transient boolean isExactNumeric;
    public transient boolean isFullySupported;
    public transient boolean isSupported;
    public transient boolean isNumeric;
    public transient boolean isLargeObject;

    protected CommonJdbcType() {
        this(0);
    }

    public CommonJdbcType(int jdbcType) {
        if (!CommonTypes.isValid(this.typeCode)) {
            throw new IllegalArgumentException("illegal jdbc type");
        }
        this.typeCode = jdbcType;
        this.initTransients();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.isApproxNumeric = CommonTypes.isApproxNumeric(this.typeCode);
        this.isBinary = CommonTypes.isBinary(this.typeCode);
        this.isCharacterLike = CommonTypes.isCharacterLike(this.typeCode);
        this.isDatetimeLike = CommonTypes.isDatetimeLike(this.typeCode);
        this.isExactNumeric = CommonTypes.isExactNumeric(this.typeCode);
        this.isFullySupported = CommonTypes.isFullySupported(this.typeCode);
        this.isSupported = CommonTypes.isSupported(this.typeCode);
        this.isNumeric = this.isApproxNumeric || this.isExactNumeric;
        this.isLargeObject = CommonTypes.isLargeObject(this.typeCode);
        if (this.isSupported) {
            Class[] allowed = this.allowedMapping();
            if (null != allowed) {
                this.defaultJavaClass = allowed[0];
                this.allowedClasses = new HashSet(allowed.length);
                int i = 0;
                while (i < allowed.length) {
                    this.allowedClasses.add(allowed[i]);
                    ++i;
                }
            } else {
                this.defaultJavaClass = null;
                this.allowedClasses = null;
            }
        }
    }

    public int getJdbcType() {
        return this.typeCode;
    }

    public String getJdbcTypeName() {
        return CommonTypes.getJdbcTypeName(this.typeCode);
    }

    public String getTypeName() {
        return this.getJdbcTypeName();
    }

    public boolean isComparable() {
        return CommonTypes.isComparable(this.typeCode);
    }

    public boolean isComparableWith(CommonJdbcType other) {
        return CommonTypes.isComparableWith(this.typeCode, other.getJdbcType());
    }

    public boolean isAssignableFrom(CommonJdbcType source) {
        if (this.isNumeric) {
            return source.isNumeric;
        }
        if (this.isCharacterLike) {
            return source.isCharacterLike;
        }
        return this.getJdbcType() == source.getJdbcType();
    }

    public Class[] allowedMapping() {
        return CommonTypes.getableInto(this.typeCode);
    }

    public boolean isSetableFrom(Class javaClass, boolean pedanticTypeChecking) {
        if (pedanticTypeChecking) {
            int[] jdbcTypes = CommonTypes.setableFrom(javaClass);
            if (jdbcTypes == null) {
                return false;
            }
            int i = 0;
            while (i < jdbcTypes.length) {
                if (jdbcTypes[i] == this.typeCode) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.isNumeric) {
            return CommonTypes.isNumeric(javaClass);
        }
        if (this.isCharacterLike) {
            return CommonTypes.isCharacterLike(javaClass);
        }
        if (this.isDatetimeLike) {
            return CommonTypes.isDatetimeLike(javaClass);
        }
        return this.isSetableFrom(javaClass, true);
    }

    public boolean isGetableInto(Class javaClass, boolean pedanticTypeChecking) {
        if (pedanticTypeChecking) {
            return this.allowedClasses != null && this.allowedClasses.contains(javaClass);
        }
        if (this.isNumeric) {
            return CommonTypes.isNumeric(javaClass);
        }
        if (this.isCharacterLike) {
            return CommonTypes.isCharacterLike(javaClass);
        }
        if (this.isDatetimeLike) {
            return CommonTypes.isDatetimeLike(javaClass);
        }
        return this.isGetableInto(javaClass, true);
    }

    public Class defaultMapping() {
        return this.defaultJavaClass;
    }
}

