/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.catalog.Table;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;

public class TableReference
extends Query {
    private String schemaName = null;
    private String tableName;
    private String aliasName = null;
    private transient Table tableDescriptor = null;

    public TableReference(String aTableName) {
        this.tableName = aTableName;
    }

    public TableReference(Table aTable) {
        this.tableName = aTable.getName();
        this.tableDescriptor = aTable;
    }

    public TableReference(String aSchemaName, String aTableName) {
        this.schemaName = aSchemaName;
        this.tableName = aTableName;
    }

    public TableReference(String aSchemaName, String aTableName, String anAliasName) {
        this.schemaName = aSchemaName;
        this.tableName = aTableName;
        this.aliasName = anAliasName;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitTableReferenceBefore(this);
        visitor.visitTableReference(this);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public Table getTableDescriptor() {
        return this.tableDescriptor;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setTableDescriptor(Table aTableDescriptor) {
        this.tableDescriptor = aTableDescriptor;
    }

    public void setAliasName(String anAliasName) {
        this.aliasName = anAliasName;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        expert.toQualifiedName(this.schemaName, this.tableName, strBuf);
        if (this.aliasName != null && !this.tableName.equals(this.aliasName)) {
            strBuf.append(" ");
            expert.toDelimitedIdentifier(this.aliasName, strBuf);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toSqlTxt(new SqlTextExpert(), buffer);
        return buffer.toString();
    }
}

