/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.types.CommonJdbcType;
import java.io.Serializable;

public class ResultDescriptor
extends CommonJdbcType
implements Serializable {
    private String tableName;
    private String name;
    private String schemaName;
    private int columnIndex;
    private long size;
    private int decimals;
    private boolean nullable;
    private boolean unknownType;
    private boolean constant;
    public static final int SMALLINT_PRECISION = 5;
    public static final int INTEGER_PRECISION = 10;
    public static final int BIGINT_PRECISION = 19;
    public static final int DOUBLE_PRECISION = 10;
    public static final int BOOLEAN = 9999;
    public static final int TABLE = 9998;

    public ResultDescriptor() {
        super(0);
        this.tableName = null;
        this.schemaName = null;
        this.name = null;
        this.size = 0L;
        this.decimals = 0;
        this.nullable = false;
        this.unknownType = true;
        this.constant = false;
    }

    public ResultDescriptor(ResultDescriptor rd) {
        super(rd.getJdbcType());
        this.tableName = rd.tableName;
        this.schemaName = rd.schemaName;
        this.name = rd.name;
        this.size = rd.size;
        this.decimals = rd.decimals;
        this.nullable = rd.nullable;
        this.unknownType = rd.unknownType;
        this.constant = rd.constant;
    }

    public ResultDescriptor(Column aColumn) {
        super(aColumn.getJdbcType());
        Table table = aColumn.getTable();
        if (table != null) {
            this.tableName = table.getName();
            this.schemaName = table.getSchemaName();
        } else {
            this.schemaName = null;
            this.tableName = null;
        }
        this.name = aColumn.getName();
        this.size = aColumn.getSize();
        this.decimals = aColumn.getDecimals();
        this.nullable = aColumn.isNullable();
        this.unknownType = false;
        this.constant = false;
        this.columnIndex = aColumn.getPosition();
    }

    public ResultDescriptor(int aJdbcType, long aSize, int aDecimals, boolean isConstant) {
        super(aJdbcType);
        this.tableName = null;
        this.schemaName = null;
        this.name = null;
        this.size = aSize;
        this.decimals = aDecimals;
        this.nullable = false;
        this.unknownType = false;
        this.constant = isConstant;
    }

    public ResultDescriptor(int aJdbcType, long aSize, int aDecimals, String aName) {
        this(aJdbcType, aSize, aDecimals, false);
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isApproxNumeric() {
        return this.isUnknown() || this.isApproxNumeric;
    }

    public boolean isCharacterLike() {
        return this.isUnknown() || this.isCharacterLike;
    }

    public boolean isBinary() {
        return this.isUnknown() || this.isBinary;
    }

    public boolean isAssignableToClob() {
        return this.getJdbcType() == 2005;
    }

    public boolean isUnknown() {
        return this.unknownType;
    }

    public boolean isComparable() {
        return this.isUnknown() || super.isComparable();
    }

    public boolean isComparableWith(ResultDescriptor other) {
        if (this.isUnknown() || other.isUnknown()) {
            return true;
        }
        return super.isComparableWith(other);
    }

    public boolean isAssignableFrom(ResultDescriptor source) {
        if (this.isUnknown() || source.isUnknown()) {
            return true;
        }
        if (super.isAssignableFrom(source)) {
            return true;
        }
        if (this.getJdbcType() == 2005) {
            return source.isAssignableToClob();
        }
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.name;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public long getSize() {
        return this.size;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isConstant() {
        return this.constant;
    }
}

