/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class InSubqueryPredicate
extends SearchCondition {
    private RowValue value;
    private Query subquery;
    private boolean notIn = false;

    public InSubqueryPredicate(RowValue aValue, Query aSubquery) {
        this.value = aValue;
        this.subquery = aSubquery;
    }

    public InSubqueryPredicate(RowValue aValue, Query aSubquery, boolean isNotIn) {
        this.value = aValue;
        this.subquery = aSubquery;
        this.notIn = isNotIn;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitInSubqueryPredicateBefore(this);
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.subquery != null) {
            this.subquery.accept(visitor);
        }
        visitor.visitInSubqueryPredicate(this);
    }

    public RowValue getValue() {
        return this.value;
    }

    public Query getSubquery() {
        return this.subquery;
    }

    public boolean isNotIn() {
        return this.notIn;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.value.toSqlTxt(expert, strBuf);
        if (this.notIn) {
            strBuf.append(" NOT");
        }
        strBuf.append(" IN ");
        expert.toSubquery(this.subquery, strBuf);
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

