/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanOr
extends SearchCondition {
    private SearchCondition[] operands;

    public BooleanOr(SearchCondition[] aConditionList) {
        this.operands = aConditionList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitBooleanOrBefore(this);
        if (this.operands != null) {
            int i = 0;
            while (i < this.operands.length) {
                if (this.operands[i] != null) {
                    this.operands[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitBooleanOr(this);
    }

    public SearchCondition[] getOperands() {
        return this.operands;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.operands[0].toSqlTxt(expert, strBuf);
        int op_i = 1;
        while (op_i < this.operands.length) {
            strBuf.append(" OR ");
            this.operands[op_i].toSqlTxt(expert, strBuf);
            ++op_i;
        }
    }

    public boolean evaluate(HostVariableValues hv, ResultSet rs) throws SQLException {
        int op_i = 0;
        while (op_i < this.operands.length) {
            if (this.operands[op_i].evaluate(hv, rs)) {
                return true;
            }
            ++op_i;
        }
        return false;
    }
}

