/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog.data;

import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.catalog.data.TableData;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ColumnData
implements Column,
Comparable,
Cloneable {
    private transient TableData m_table;
    private String m_name;
    private int m_describedPos;
    private int m_primaryKeyPos;
    private int m_jdbcType;
    private String m_typeName;
    private long m_size;
    private int m_decimals;
    private boolean m_nullable;
    private Object m_defaultValue;

    public ColumnData(TableData table, String name, int describedPos, int primaryKeyPos, int jdbcType, String typeName, long size, int decimals, boolean nullable, Object defaultValue) {
        if (null == name || 0 == name.length()) {
            throw new IllegalArgumentException("table " + table.getName() + ": missing column name");
        }
        if (1 > describedPos) {
            throw new IllegalArgumentException("table " + table.getName() + "." + name + ": invalid column position");
        }
        if (0 > primaryKeyPos) {
            throw new IllegalArgumentException("table " + table.getName() + "." + name + ": invalid key position");
        }
        if (null == typeName || 0 == typeName.length()) {
            throw new IllegalArgumentException("table " + table.getName() + "." + name + ": missing type name");
        }
        if (0L > size) {
            throw new IllegalArgumentException("table " + table.getName() + "." + name + ": invalid size value");
        }
        if (0 > decimals || (long)decimals > size) {
            throw new IllegalArgumentException("table " + table.getName() + "." + name + ": invalid decimals value");
        }
        this.m_table = table;
        this.m_name = name;
        this.m_describedPos = describedPos;
        this.m_primaryKeyPos = primaryKeyPos;
        this.m_jdbcType = jdbcType;
        this.m_typeName = typeName.intern();
        this.m_size = size;
        this.m_decimals = decimals;
        this.m_nullable = nullable;
        this.m_defaultValue = defaultValue;
        this.m_table.setColumn(this, describedPos);
    }

    ColumnData(ColumnData src, TableData table, boolean associate) {
        this.m_table = table;
        this.m_name = src.m_name;
        this.m_describedPos = src.m_describedPos;
        this.m_primaryKeyPos = src.m_primaryKeyPos;
        this.m_jdbcType = src.m_jdbcType;
        this.m_typeName = src.m_typeName;
        this.m_size = src.m_size;
        this.m_decimals = src.m_decimals;
        this.m_nullable = src.m_nullable;
        this.m_defaultValue = src.m_defaultValue;
        if (associate) {
            table.setColumn(this, this.m_describedPos);
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPosition() {
        return this.m_describedPos;
    }

    public boolean isPrimaryKey() {
        return 0 < this.m_primaryKeyPos;
    }

    public int getPrimaryKeyPosition() {
        return this.m_primaryKeyPos;
    }

    public int getJdbcType() {
        return this.m_jdbcType;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public long getSize() {
        return this.m_size;
    }

    public int getDecimals() {
        return this.m_decimals;
    }

    public boolean isNullable() {
        return this.m_nullable;
    }

    public Object getDefault() {
        return this.m_defaultValue;
    }

    public int compareTo(Object o) {
        return this.m_name.compareTo(((ColumnData)o).m_name);
    }

    public boolean equals(Object o) {
        return this.m_name.equals(((ColumnData)o).m_name);
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    void writeExternal(ObjectOutput out, int fmtVersion) throws IOException {
        out.writeUTF(this.m_name);
        out.writeInt(this.m_describedPos);
        out.writeInt(this.m_primaryKeyPos);
        out.writeInt(this.m_jdbcType);
        out.writeUTF(this.m_typeName);
        out.writeLong(this.m_size);
        out.writeInt(this.m_decimals);
        out.writeBoolean(this.m_nullable);
        if (null == this.m_defaultValue) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.m_defaultValue);
        }
    }

    ColumnData(ObjectInput in, TableData table, int fmtVersion) throws IOException {
        try {
            this.m_table = table;
            this.m_name = in.readUTF();
            this.m_describedPos = in.readInt();
            this.m_primaryKeyPos = in.readInt();
            this.m_jdbcType = in.readInt();
            this.m_typeName = in.readUTF().intern();
            this.m_size = in.readLong();
            this.m_decimals = in.readInt();
            this.m_nullable = in.readBoolean();
            this.m_defaultValue = in.readBoolean() ? in.readObject() : null;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidObjectException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new InvalidObjectException(ex.getMessage());
        }
    }
}

