/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.datasvc.instreader;

import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.rt.bol.util.JDBCConnection;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class InstanceReader {
    public Collection getInstancePrefixes(String guidBO, int digits, String prefix) throws Exception {
        String dbTable = null;
        MetaModel mmr = new MetaModel();
        DataObject so = mmr.getDataObjectByGUID(guidBO);
        Iterator it = so.getKeys().iterator();
        while (it.hasNext()) {
            Property attr = (Property)it.next();
            if (!attr.getObjectName().equals("key")) continue;
            Iterator it2 = attr.getField().iterator();
            Field field = (Field)it2.next();
            dbTable = field.getTable().getTableName();
            break;
        }
        if (dbTable == null) {
            throw new DataAccessException("Cannot determine persistence data for object {0}", new Object[]{guidBO});
        }
        String sql = "SELECT DISTINCT objectKey FROM " + dbTable + " WHERE objectKey LIKE '" + prefix + "%'";
        JDBCConnection conn = new JDBCConnection();
        Collection rs = null;
        rs = digits == -1 ? conn.selectColumn(sql, "objectKey") : conn.selectColumn(sql, "objectKey", prefix, digits);
        conn.close();
        return rs;
    }

    public Collection getInstances(String guidBO, String prefixGuidInstance) throws Exception {
        return this.getInstancePrefixes(guidBO, -1, prefixGuidInstance);
    }

    public Collection getRelatedInstancePrefixes(String guidBO, String guidInstance, String relationGuid, int digits, String prefix) throws Exception {
        String dbRelTable = null;
        MetaModel mmr = new MetaModel();
        DataObject sourceSO = mmr.getDataObjectByGUID(guidBO);
        Iterator it = sourceSO.getAttributes().iterator();
        BusinessEntityInterface targetSO = mmr.getRelatedBOByRelation(relationGuid);
        Property refObj = (Property)mmr.getAttribute(relationGuid);
        Iterator relit = refObj.getField().iterator();
        if (relit.hasNext()) {
            Field field = (Field)relit.next();
            dbRelTable = field.getTable().getTableName();
        }
        if (dbRelTable == null) {
            throw new DataAccessException("Cannot determine persistence data for object {0}", new Object[]{guidBO});
        }
        JDBCConnection conn = new JDBCConnection();
        Collection rs = new Vector();
        String sql2 = "SELECT OBJECTKEY FROM " + dbRelTable + " WHERE parentKey = '" + guidInstance + "'";
        rs = conn.selectColumn(sql2, "OBJECTKEY", prefix, digits);
        conn.close();
        return rs;
    }

    public Collection getRelatedInstances(String guidBO, String guidInstance, String relationGuid, String prefixGuidInstance) throws Exception {
        return this.getRelatedInstancePrefixes(guidBO, guidInstance, relationGuid, 100000, prefixGuidInstance);
    }

    public Collection getRelatedInstances(String fullBOName, int backEndType) throws Exception {
        MetaModel mmr = new MetaModel();
        List attrList = new ArrayList();
        HashSet<Property> attrCol = new HashSet<Property>();
        HashSet resCol = new HashSet();
        DataObject dataObj = null;
        Property attr = null;
        String dbTable = null;
        String dbField = null;
        BusinessEntityInterface sourceSO = mmr.getBusinessEntityInterface(fullBOName);
        attrList = sourceSO.getBusinessEntity().getAttributes();
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            BusinessEntityInterface shareObject;
            attr = (Property)it.next();
            if (attr.getObjectName().equals("key")) {
                Field field = (Field)attr.getField().iterator().next();
                dbTable = field.getTable().getTableName();
                continue;
            }
            dataObj = (DataObject)attr.getReferencedObject();
            if (dataObj == null || !(dataObj instanceof BusinessEntityInterface) || (shareObject = (BusinessEntityInterface)dataObj).getBackend() != backEndType) continue;
            attrCol.add(attr);
        }
        Iterator itAttr = attrCol.iterator();
        JDBCConnection conn = new JDBCConnection();
        while (itAttr.hasNext()) {
            attr = (Property)itAttr.next();
            Field field = (Field)attr.getField().iterator().next();
            dbField = field.getFieldName();
            String sql = "SELECT " + dbField + " FROM " + dbTable;
            Collection rs = new Vector();
            if (attr.getMaxOccurs() == 1 || attr.getMaxOccurs() == 0) {
                rs = conn.selectColumn(sql, dbField);
                resCol.add(rs);
                continue;
            }
            String sql2 = "SELECT objectKey FROM " + dbField;
            rs = conn.selectColumn(sql2, "objectKey");
            resCol.add(rs);
        }
        conn.close();
        return resCol;
    }
}

