/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.datasvc;

import com.sap.caf.km.da.DocumentDataAccessService;
import com.sap.caf.km.datasvc.ICAFDataService;
import com.sap.caf.km.datasvc.data.Attribute;
import com.sap.caf.km.datasvc.data.BO;
import com.sap.caf.km.datasvc.data.BODescription;
import com.sap.caf.km.datasvc.data.BOInstance;
import com.sap.caf.km.datasvc.data.Relation;
import com.sap.caf.km.datasvc.instreader.InstanceReader;
import com.sap.caf.km.datasvc.util.TypeConstants;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.repository.DataTypeBroker;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class CAFDataServiceImpl
implements ICAFDataService {
    private static final String jARMRequest = "CAF:rt:cafdataservice";
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$km$datasvc$CAFDataServiceImpl == null ? (class$com$sap$caf$km$datasvc$CAFDataServiceImpl = CAFDataServiceImpl.class$("com.sap.caf.km.datasvc.CAFDataServiceImpl")) : class$com$sap$caf$km$datasvc$CAFDataServiceImpl));
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private Context ctx = null;
    private MetaModel mmrProxy = null;
    private InstanceReader instProxy = null;
    private static final int kmBackEnd = 2;
    private static final String JNDI_PREFIX = "localejbs/";
    private static final String BE_DOCUMENT_NAME = "sap.com/caf.core/Document";
    private static final String VO_DOCUMENT = "com.sap.caf.core.besrv.document.Document";
    private static String m_beDocumentServiceName = null;
    static /* synthetic */ Class class$com$sap$caf$km$datasvc$CAFDataServiceImpl;
    static /* synthetic */ Class class$java$lang$String;

    public CAFDataServiceImpl() throws DataAccessException {
        String method = "CAFDataServiceImpl()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        try {
            this.ctx = new InitialContext();
            location.debugT("Initialization of jndi context successfull", new Object[0]);
        }
        catch (NamingException ex) {
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in initializing jndi context", new Object[0], (Throwable)ex);
            throw new DataAccessException("JNDI_CONTEXT_ERROR", new Object[0], (Throwable)ex);
        }
        this.mmrProxy = new MetaModel();
        location.debugT("Initialization of connection to metadata repository successfull", new Object[0]);
        this.instProxy = new InstanceReader();
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public BODescription[] getAllBOs() throws DataAccessException {
        String method = "getAllBOs()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        Vector<BODescription> col = new Vector<BODescription>();
        Collection tmp = null;
        Object iterator = null;
        tmp = this.mmrProxy.getAllBusinessEntityInterfaces(0);
        location.debugT("Reading data from mmr successfull", new Object[0]);
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof BusinessEntityInterface)) continue;
            BusinessEntityInterface so = (BusinessEntityInterface)obj;
            DataObject bo = so.getBusinessEntity();
            if (so.getBackend() == 2) {
                col.add(new BODescription(bo.getObjectId(), true));
                continue;
            }
            col.add(new BODescription(bo.getObjectId(), false));
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return col.toArray(new BODescription[col.size()]);
    }

    public Relation[] getAssociatedBOs(String guidBO) throws DataAccessException {
        String method = "getAssociatedBOs(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO});
        Vector<Relation> tmp = new Vector<Relation>();
        Map map = null;
        DataObject so = this.mmrProxy.getDataObjectByGUID(guidBO);
        map = this.mmrProxy.getRelatedBEsByGUID(so.getBusinessEntityInterface().refMofId());
        location.debugT("Reading data from mmr successfull", new Object[0]);
        location.debugT("Filtering of km objects successfull", new Object[0]);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            BusinessEntityInterface relatedSo = (BusinessEntityInterface)map.get(key);
            if (relatedSo == null) continue;
            BODescription bo = null;
            bo = relatedSo.getBackend() == 2 ? new BODescription(relatedSo.getBusinessEntity().refMofId(), true) : new BODescription(relatedSo.getBusinessEntity().refMofId(), false);
            Relation rel = new Relation(bo, key);
            tmp.add(rel);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp.toArray(new Relation[0]);
    }

    public Relation[] getAggregatedBOs(String guidBO) throws DataAccessException {
        String method = "getAggregatedBOs(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO});
        Vector<Relation> tmp = new Vector<Relation>();
        Map map = null;
        map = this.mmrProxy.getRelatedBEsByGUID(guidBO);
        location.debugT("Reading data from mmr successfull", new Object[0]);
        location.debugT("Filtering of km objects successfull", new Object[0]);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            DataObject relatedSo = (DataObject)map.get(key);
            BODescription bo = null;
            bo = relatedSo.getBusinessEntityInterface().getBackend() == 2 ? new BODescription(relatedSo.refMofId(), true) : new BODescription(relatedSo.refMofId(), false);
            Relation rel = new Relation(bo, key);
            tmp.add(rel);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp.toArray(new Relation[0]);
    }

    public BO getBOByGUID(String guid) throws DataAccessException {
        String method = "getBOByGUID(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guid});
        DataObject so = null;
        so = this.mmrProxy.getDataObjectByGUID(guid);
        location.debugT("Reading data from mmr successfull", new Object[0]);
        BO tmp = this.convertBO(so);
        location.debugT("Converting metadata successfull", new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public BOInstance getBOInstance(String guidBO, String guidInstance) throws DataAccessException, CAFPermissionException {
        String method = "getBOIstance(String, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidInstance});
        BOInstance tmp = null;
        Object fullObjectName = null;
        IBusinessObject obj = null;
        TransactionManager tr = null;
        tr = this.getResourceTransaction();
        tr.begin();
        BO tmpBO = this.getBOByGUID(guidBO);
        location.debugT("Reading data from mmr successfull", new Object[0]);
        obj = this.getLocalInterface(tmpBO, guidInstance);
        tmp = this.convertBOInstance(tmpBO.getGuidBO(), tmpBO.getProviderBO(), tmpBO.getAppBO(), tmpBO.getIdBO(), (IDependentObject)obj);
        tr.rollback();
        tr = null;
        location.debugT("Converting of business entity instance successfull", new Object[0]);
        BOInstance bOInstance = tmp;
        Object var11_14 = null;
        try {
            if (tr != null) {
                tr.rollback();
            }
        }
        catch (Exception ex) {
            CAFPublicLogger.categoryCAF.logThrowableT(0, location, method, "Cannot rollback resource transaction", new Object[0], (Throwable)ex);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        {
            return bOInstance;
            catch (CAFPermissionException ex) {
                String[] args = new String[]{guidBO, guidInstance};
                CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Cannot get BO Instance. BO: {0} Instance: {1}", new Object[0], (Throwable)ex);
                throw ex;
            }
            catch (Throwable ex) {
                Object[] args = new String[]{fullObjectName, guidInstance};
                throw new DataAccessException("CANNOT_READ_BO", args, ex);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {
                if (tr != null) {
                    tr.rollback();
                }
            }
            catch (Exception ex) {
                CAFPublicLogger.categoryCAF.logThrowableT(0, location, method, "Cannot rollback resource transaction", new Object[0], (Throwable)ex);
            }
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
    }

    public String[] getInstancesByGUIDPart(String guidBO, String guidPart) throws DataAccessException {
        String method = "getInstancesByGUIDPart(String, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidPart});
        Collection guids = null;
        try {
            guids = this.instProxy.getInstances(guidBO, guidPart);
            location.debugT("Reading data from database successfull", new Object[0]);
        }
        catch (Exception ex) {
            Object[] args = new String[]{guidBO};
            throw new DataAccessException("CANNOT_GET_BO", args, (Throwable)ex);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return guids.toArray(new String[0]);
    }

    public String[] getRelatedInstancesByGUIDPart(String guidBO, String guidRelation, String guidInstance, String guidPart) throws DataAccessException {
        String method = "getRelatedInstancesByGUIDPart(String, String, String, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation, guidInstance, guidPart});
        Collection guids = null;
        TransactionManager tr = null;
        try {
            BusinessEntityInterface so = this.mmrProxy.getRelatedBOByRelation(guidRelation);
            location.debugT("Reading data from mmr successfull", new Object[0]);
            tr = this.getResourceTransaction();
            tr.begin();
            if (so.getBackend() == 2) {
                BO tmpBO = this.getBOByGUID(guidBO);
                location.debugT("Reading data from mmr successfull", new Object[0]);
                IBusinessObject obj = this.getLocalInterface(tmpBO, guidInstance);
                com.sap.caf.metamodel.Attribute attr = this.mmrProxy.getAttribute(guidRelation);
                location.debugT("Reading data from mmr successfull", new Object[0]);
                String attrName = attr.getObjectName();
                char ch = Character.toUpperCase(attrName.charAt(0));
                attrName = ch + attrName.substring(1, attrName.length());
                Method m = obj.getClass().getMethod("get" + attrName, null);
                String[] tmp = null;
                Object oRes = m.invoke((Object)obj, null);
                if (oRes instanceof Collection) {
                    Collection col = (Collection)oRes;
                    tmp = col.toArray(new String[0]);
                } else {
                    tmp = new String[]{m.invoke((Object)obj, null).toString()};
                }
                tr.rollback();
                return tmp;
            }
            guids = this.instProxy.getRelatedInstances(guidBO, guidInstance, guidRelation, guidPart);
            tr.rollback();
            location.debugT("Reading data from database successfull", new Object[0]);
        }
        catch (Exception ex) {
            Object[] args = new String[]{guidBO};
            throw new DataAccessException("CANNOT_GET_RELATED_BO", args, (Throwable)ex);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return guids.toArray(new String[0]);
    }

    public BO getRelatedBOByRelationGUID(String relationGuid) throws DataAccessException {
        String method = "getRelatedBOByRelationGUID(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{relationGuid});
        BusinessEntityInterface so = null;
        int relationType = 0;
        so = this.mmrProxy.getRelatedBOByRelation(relationGuid);
        location.debugT("Reading metadata from mmr successfull", new Object[0]);
        com.sap.caf.metamodel.Attribute attr = this.mmrProxy.getAttribute(relationGuid);
        location.debugT("Reading data from database successfull", new Object[0]);
        relationType = 0;
        BO tmp = this.convertBOWithRelation(so.getBusinessEntity(), relationGuid, relationType);
        location.debugT("Converting metadata successfull", new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    private BO convertBO(DataObject so) {
        String method = "convertBO(DataObject)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{so});
        BO tmp = this.convertBOWithRelation(so, null, 0);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    private BO convertBOWithRelation(DataObject so, String relationRole, int relationType) {
        String method = "convertBOWithRelation(DataObject, String, int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{so, relationRole, new Integer(relationType)});
        Application app = so.getApplication();
        if (app == null) {
            app = so.getBusinessEntityInterface().getApplication();
        }
        BO tmp = new BO(so.refMofId(), app.getProviderName(), app.getObjectName(), so.getObjectName(), so.getBusinessEntityInterface().getObjectName());
        tmp.setRoleBO(relationRole);
        tmp.setRelationType(relationType);
        tmp.setCreatedBy(so.getCreatedBy());
        tmp.setLastChangedBy(so.getLastChangedBy());
        tmp.setLongText(so.getLongText());
        tmp.setShortText(so.getShortText());
        try {
            if (so.getCreatedAt() != null) {
                tmp.setCreatedAt(dateFormat.parse(so.getCreatedAt()).getTime());
            }
            if (so.getLastChangedAt() != null) {
                tmp.setLastChangedAt(dateFormat.parse(so.getLastChangedAt()).getTime());
            }
        }
        catch (ParseException ex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)location, (String)method, (String)"Created/changed Date cannot be parsed", (Object[])new Object[0], (Throwable)ex);
        }
        if (so instanceof BusinessEntityInterface) {
            tmp.setType(0);
            tmp.setBackend(((BusinessEntityInterface)so).getBackend());
        } else {
            tmp.setType(99);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    private BOInstance convertBOInstance(String guid, String provider, String application, String id, IDependentObject bo) throws CAFPermissionException, CAFBaseException {
        String method = "convertBOInstance(String, String, String, String, IDependentObject)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guid, provider, application, id, bo});
        BOInstance instance = new BOInstance(guid, provider, application, id, bo.getKey());
        DataObject so = this.mmrProxy.getDataObjectByGUID(guid);
        if (bo instanceof IBusinessObject) {
            com.sap.caf.metamodel.Attribute desc;
            instance.setCreatedBy(((IBusinessObject)bo).getCreatedBy());
            instance.setLastChangedBy(((IBusinessObject)bo).getLastChangedBy());
            Date tmp = ((IBusinessObject)bo).getCreatedAt();
            if (tmp != null) {
                instance.setCreatedAt(tmp.getTime());
            }
            if ((tmp = ((IBusinessObject)bo).getLastChangedAt()) != null) {
                instance.setLastChangedAt(tmp.getTime());
            }
            if ((desc = so.getDefaultLongText()) != null) {
                instance.setDescription((String)((IBusinessObject)bo).getProperty(desc.getObjectName()));
            } else {
                instance.setDescription("");
            }
            com.sap.caf.metamodel.Attribute dispName = so.getDefaultShortText();
            if (dispName != null) {
                instance.setDisplayName((String)((IBusinessObject)bo).getProperty(dispName.getObjectName()));
            } else {
                instance.setDisplayName(bo.getObjectType());
            }
        }
        instance.setBackend(so.getBusinessEntityInterface().getBackend());
        instance.setAttributes(this.fillAttributes(so.getBusinessEntityInterface(), bo));
        location.debugT("Converting attributes for business entity successfull", new Object[0]);
        instance.setCategories(this.fillCategories(so.getBusinessEntityInterface(), bo));
        location.debugT("Converting categories for business entity successfull", new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attribute[] fillCategories(BusinessEntityInterface so, IDependentObject obj) throws CAFBaseException {
        String method = "fillCategories(BusinessEntityInterface, IDependentObject)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{so, obj});
        ArrayList<Attribute> col = new ArrayList<Attribute>();
        try {
            Object home = this.ctx.lookup("localejbs/sap.com/caf.tc/CategoryService");
            location.debugT("Jndi lookup for business entity {0} succesfull", new Object[]{"sap.com/caf.tc/CategoryService"});
            HashMap mapValues = new HashMap();
            Application app = so.getApplication();
            String provider = app.getProviderName();
            String appName = app.getObjectName();
            Method cr_meth = home.getClass().getMethod("create", new Class[0]);
            Object createdService = cr_meth.invoke(home, new Object[0]);
            Method findCatByName_meth = createdService.getClass().getMethod("findCategoryByBOName", class$java$lang$String == null ? (class$java$lang$String = CAFDataServiceImpl.class$("java.lang.String")) : class$java$lang$String);
            Collection categories = new ArrayList(1);
            if (findCatByName_meth != null) {
                categories = (Collection)findCatByName_meth.invoke(createdService, provider + "/" + appName + "/" + so.getBusinessEntity().getObjectName());
            }
            location.debugT("Found {0} assigned categories", new Object[]{new Integer(categories.size())});
            Object classif = this.ctx.lookup(JNDI_PREFIX + provider + "/" + appName + "/" + so.getObjectName());
            Method cr_meth_classif = classif.getClass().getMethod("create", new Class[0]);
            Object createdServiceClassif = cr_meth_classif.invoke(classif, new Object[0]);
            Method getclassif_meth = createdServiceClassif.getClass().getMethod("getClassification", class$java$lang$String == null ? (class$java$lang$String = CAFDataServiceImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CAFDataServiceImpl.class$("java.lang.String")) : class$java$lang$String);
            Object categoryValueHome = this.ctx.lookup("localejbs/sap.com/caf.tc/CategoryValueService");
            Method createCategoryValueHome_meth = categoryValueHome.getClass().getMethod("create", new Class[0]);
            Object categoryValueService = createCategoryValueHome_meth.invoke(categoryValueHome, new Object[0]);
            Method categoryValueService_read_meth = categoryValueService.getClass().getMethod("read", class$java$lang$String == null ? (class$java$lang$String = CAFDataServiceImpl.class$("java.lang.String")) : class$java$lang$String);
            Iterator itCat = categories.iterator();
            while (itCat.hasNext()) {
                ArrayList<String> values = new ArrayList<String>();
                Object category = itCat.next();
                Method getKey = category.getClass().getMethod("getKey", new Class[0]);
                String categoryKey = (String)getKey.invoke(category, new Object[0]);
                Collection allClass = (Collection)getclassif_meth.invoke(createdServiceClassif, obj.getKey(), categoryKey);
                Iterator itClass = allClass.iterator();
                while (itClass.hasNext()) {
                    String categoryValueKey = (String)itClass.next();
                    Object categoryValue = categoryValueService_read_meth.invoke(categoryValueService, categoryValueKey);
                    ArrayList<String> shortTexts = new ArrayList<String>();
                    ArrayList<String> longTexts = new ArrayList<String>();
                    Method shortText = categoryValue.getClass().getMethod("getShortText", new Class[0]);
                    HashMap map1 = (HashMap)shortText.invoke(categoryValue, new Object[0]);
                    if (map1 != null) {
                        Iterator it1 = map1.keySet().iterator();
                        while (it1.hasNext()) {
                            String language = (String)it1.next();
                            String value = (String)map1.get(language);
                            shortTexts.add(language + "###" + value);
                        }
                    }
                    Method longText = categoryValue.getClass().getMethod("getLongText", new Class[0]);
                    Object v2 = longText.invoke(categoryValue, new Object[0]);
                    HashMap map2 = (HashMap)shortText.invoke(categoryValue, new Object[0]);
                    if (map2 != null) {
                        Iterator it2 = map2.keySet().iterator();
                        while (it2.hasNext()) {
                            String language = (String)it2.next();
                            String value = (String)map2.get(language);
                            longTexts.add(language + "###" + value);
                        }
                    }
                    Method name = categoryValue.getClass().getMethod("getName", new Class[0]);
                    String value = (String)name.invoke(categoryValue, new Object[0]);
                    Iterator shortTextIterator = shortTexts.iterator();
                    while (shortTextIterator.hasNext()) {
                        value = value + ";;" + (String)shortTextIterator.next();
                    }
                    Iterator longTextIterator = longTexts.iterator();
                    while (longTextIterator.hasNext()) {
                        value = value + ";;" + (String)longTextIterator.next();
                    }
                    values.add(value);
                }
                Method name = category.getClass().getMethod("getId", new Class[0]);
                String value = (String)name.invoke(category, new Object[0]);
                value = URLEncoder.encode(value);
                if (values.size() == 0) {
                    values.add("");
                }
                Attribute attr = new Attribute(value, values.toArray(new String[0]));
                attr.setCollection(true);
                attr.setType("String");
                location.debugT("Converting of assigned category {0} successfull", new Object[]{value});
                col.add(attr);
            }
        }
        catch (Exception ex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)location, (String)method, (String)"Categories could not be resolved for business entity", (Object[])new Object[0], (Throwable)ex);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        }
        return col.toArray(new Attribute[0]);
    }

    private Attribute[] fillAttributes(BusinessEntityInterface so, IDependentObject obj) throws CAFBaseException {
        String method = "fillAttributes(BusinessEntityInterface, IDependentObject)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{so, obj});
        Vector<Attribute> attributes = new Vector<Attribute>();
        List list = so.getBusinessEntity().getAttributes();
        for (int l = 0; l < list.size(); ++l) {
            com.sap.caf.metamodel.Attribute metaAttr = (com.sap.caf.metamodel.Attribute)list.get(l);
            if (metaAttr.getReferencedObject() == null) {
                attributes.add(this.createAttribute(obj, metaAttr));
            } else {
                DataStructure dataObj = metaAttr.getReferencedObject();
                if (dataObj instanceof BusinessEntityInterface && !(dataObj instanceof DataObject)) continue;
                IDependentObject obj2 = null;
                try {
                    Method getMethod = obj.getClass().getMethod("get" + metaAttr.getName(), new Class[0]);
                    obj2 = (IDependentObject)getMethod.invoke((Object)obj, new Object[0]);
                }
                catch (Exception e) {
                    continue;
                }
                List list2 = dataObj.getAttributes();
                for (int i = 0; i < list2.size(); ++i) {
                    com.sap.caf.metamodel.Attribute complexAttr = (com.sap.caf.metamodel.Attribute)list2.get(i);
                    if (metaAttr.getReferencedObject() == null) continue;
                    Attribute attr = this.createAttribute(obj2, complexAttr);
                    attr.setName(metaAttr.getName() + "." + attr.getName());
                    attributes.add(attr);
                }
            }
            location.debugT("Converting of attribute {0} successfull", new Object[]{metaAttr.getObjectName()});
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return attributes.toArray(new Attribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attribute createAttribute(IDependentObject obj, com.sap.caf.metamodel.Attribute metaAttr) throws CAFBaseException {
        String method = "createAttribute(IDependentObject, Attribute)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{obj, metaAttr});
        try {
            String type;
            Locale locale = Locale.getDefault();
            ClassLoader objClassLoader = obj.getClass().getClassLoader();
            Class attrClass = DataTypeBroker.getDataType((String)("ddic:" + metaAttr.getTypeJavaDdic()), (Locale)locale, (ClassLoader)objClassLoader).getAssociatedClass();
            String attrName = metaAttr.getObjectName();
            Object property = obj.getProperty(attrName);
            Attribute kmAttr = null;
            if (metaAttr.getMaxOccurs() == 0 || metaAttr.getMaxOccurs() == 1) {
                type = TypeConstants.getType(attrClass);
                String value = TypeConstants.convertToString(type, property);
                kmAttr = new Attribute(attrName, new String[]{value});
                kmAttr.setType(type);
                kmAttr.setCollection(false);
            } else {
                type = TypeConstants.getType(attrClass);
                ArrayList<String> values = new ArrayList<String>();
                if (property == null) {
                    values.add(TypeConstants.convertToString(type, null));
                } else {
                    Iterator itr = ((Collection)property).iterator();
                    while (itr.hasNext()) {
                        values.add(TypeConstants.convertToString(type, itr.next()));
                    }
                }
                kmAttr = new Attribute(attrName, values.toArray(new String[values.size()]));
                kmAttr.setType(type);
                kmAttr.setCollection(true);
            }
            Attribute attribute = kmAttr;
            return attribute;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        }
    }

    private Collection filterObjects(Collection col, boolean bKM) {
        String method = "filterObjects(Collection, boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{col, new Boolean(bKM)});
        ArrayList<BusinessEntityInterface> newObjects = new ArrayList<BusinessEntityInterface>();
        Iterator objects = col.iterator();
        while (objects.hasNext()) {
            BusinessEntityInterface so = (BusinessEntityInterface)objects.next();
            if (this.checkRemoveObject(so, bKM)) continue;
            newObjects.add(so);
        }
        return newObjects;
    }

    private Map filterObjects(Map map, boolean bKM) {
        String method = "filterObjects(Map, boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{map, new Boolean(bKM)});
        HashMap<String, BusinessEntityInterface> newObjects = new HashMap<String, BusinessEntityInterface>();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            BusinessEntityInterface so = (BusinessEntityInterface)map.get(key);
            if (this.checkRemoveObject(so, bKM)) continue;
            newObjects.put(key, so);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return newObjects;
    }

    private boolean checkRemoveObject(BusinessEntityInterface so, boolean bKM) {
        String method = "checkRemoveObject(BusinessEntityInterface, boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{so, new Boolean(bKM)});
        boolean result = false;
        result = so.getBackend() == 2 ? bKM : so.getBackend() != 0;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return result;
    }

    public String[] getPopulatedFolders(String guid, int noDigits, String startGuid) throws DataAccessException {
        String method = "getPopulatedFolders(String, int, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guid, new Integer(noDigits), startGuid});
        Collection guids = null;
        try {
            guids = this.instProxy.getInstancePrefixes(guid, noDigits, startGuid);
        }
        catch (Exception ex) {
            Object[] args = new String[]{guid, startGuid};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Cannot get populated folders for business object {0} with prefix {1}", new Object[0], (Throwable)ex);
            throw new DataAccessException("CANNOT_GET_POPULATED_FOLDERS", args, (Throwable)ex);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return guids.toArray(new String[0]);
    }

    public String[] getRelatedPopulatedFolders(String guidBO, String guidRelation, String guidInstance, int noDigits, String startGuid) throws DataAccessException {
        String method = "getRelatedPopulatedFolders(String, String, String, int, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation, guidInstance, new Integer(noDigits)});
        Collection guids = null;
        try {
            com.sap.caf.metamodel.Attribute attr = this.mmrProxy.getAttribute(guidRelation);
            location.debugT("Reading metadata from mmr successfull", new Object[0]);
            guids = this.instProxy.getRelatedInstancePrefixes(guidBO, guidInstance, attr.refMofId(), noDigits, startGuid);
            location.debugT("Reading data from database successfull", new Object[0]);
        }
        catch (Exception ex) {
            Object[] args = new String[]{guidBO, startGuid};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Cannot get populated folders for business object {0} with prefix {1}", new Object[0], (Throwable)ex);
            throw new DataAccessException("CANNOT_GET_RELATED_POPULATED_FOLDERS", args, (Throwable)ex);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return guids.toArray(new String[0]);
    }

    public Relation[] getComplexAttributes(String guidBO, String[] guidRelation) throws DataAccessException {
        String method = "getComplexAttributes(String, String[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation});
        Vector tmp = new Vector();
        Object attr = null;
        Object obj = null;
        Object it = null;
        Object so = null;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp.toArray(new Relation[0]);
    }

    public String[] getComplexAttributeInstances(String guidBO, String guidInstance, String[] guidRelation, String[] guidDOInstance) throws DataAccessException {
        String method = "getComplexAttributeInstances(String, String, String[], String[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidInstance, guidRelation, guidDOInstance});
        String[] guids = null;
        Object attrName = null;
        Object attr = null;
        Object fullObjectName = null;
        Object obj = null;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return guids;
    }

    public BO getComplexAttribute(String guidDO) throws DataAccessException {
        String method = "getComplexAttribute(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidDO});
        Object so = null;
        Object attr = null;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return null;
    }

    public BOInstance getComplexAttributeInstance(String guidBO, String guidBOInstance, String[] guidRelation, String[] guidDOInstance) throws DataAccessException, CAFPermissionException {
        String method = "getComplexAttributeInstance(String, String, String, String[], String[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidBOInstance, guidRelation, guidDOInstance});
        BOInstance tmp = null;
        Object attrName = null;
        Object attr = null;
        Object bo = null;
        Object fullObjectName = null;
        Object obj = null;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public void closeConnection() throws DataAccessException {
        String method = "closeConnection()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        RepositoryConnection.closeConnection();
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public String[] getRelatedKMObjects(String fullBOName) throws DataAccessException {
        String method = "getRelatedKMObjects(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{fullBOName});
        Object map = null;
        Collection rids = new HashSet();
        try {
            rids = this.instProxy.getRelatedInstances(fullBOName, 2);
        }
        catch (Exception e) {
            throw new DataAccessException("CANNOT_READ_RELATED_BE", new Object[]{fullBOName});
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return rids.toArray(new String[0]);
    }

    private IBusinessObject getLocalInterface(BO tmpBO, String guidInstance) throws DataAccessException {
        String method = "getLocalInterface(BO, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{tmpBO, guidInstance});
        Object fullObjectName = null;
        try {
            Object home = this.ctx.lookup(JNDI_PREFIX + tmpBO.getFullServiceName());
            location.debugT("Jndi lookup for business entity {0} successfull", new Object[]{fullObjectName});
            Method m = home.getClass().getMethod("create", null);
            Object local = m.invoke(home, null);
            m = local.getClass().getMethod("read", class$java$lang$String == null ? (class$java$lang$String = CAFDataServiceImpl.class$("java.lang.String")) : class$java$lang$String);
            location.debugT("Calling read method of business entity service successfull", new Object[0]);
            IBusinessObject obj = (IBusinessObject)m.invoke(local, guidInstance);
            location.debugT("Instantiating of business entity successfull", new Object[0]);
            return obj;
        }
        catch (Exception ex) {
            Object[] args = new String[]{fullObjectName, guidInstance};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Cannot read business entity: bo={0} instance={1}", args, (Throwable)ex);
            throw new DataAccessException("CANNOT_READ_BE", args, (Throwable)ex);
        }
    }

    /*
     * Loose catch block
     */
    public boolean[] checkRights(String boName, String userName, String guidInstance, String[] rightsToCheck) throws DataAccessException {
        boolean[] results;
        String method;
        block18: {
            method = "checkRights(String, String, String, String[])";
            CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{boName, userName, guidInstance, rightsToCheck});
            Object obj = null;
            results = new boolean[4];
            TransactionManager tr = null;
            if (BE_DOCUMENT_NAME.equals(boName)) {
                Object objEJB = this.ctx.lookup(this.getDocumentBEServiceName());
                Class<?> cl = objEJB.getClass().getClassLoader().loadClass(VO_DOCUMENT);
                String parentFolder = guidInstance.substring(0, guidInstance.lastIndexOf(47));
                String documentId = guidInstance.substring(guidInstance.lastIndexOf(47) + 1);
                DocumentDataAccessService dataAccessService = DocumentDataAccessService.getInstance();
                tr = this.getResourceTransaction();
                tr.begin();
                Object obj2 = dataAccessService.loadFromJDO(cl, documentId, parentFolder);
                tr.rollback();
                tr = null;
                try {
                    results[0] = CAFPermissionUtil.remoteCheckAclPermission((Object)obj2, (String)userName, (String)"read", (String)boName);
                }
                catch (CAFPermissionException ex) {
                    results[0] = false;
                }
                try {
                    results[1] = CAFPermissionUtil.remoteCheckAclPermission((Object)obj2, (String)userName, (String)"update", (String)boName);
                }
                catch (CAFPermissionException ex) {
                    results[1] = false;
                }
                try {
                    results[2] = CAFPermissionUtil.remoteCheckAclPermission((Object)obj2, (String)userName, (String)"write", (String)boName);
                }
                catch (CAFPermissionException ex) {
                    results[2] = false;
                }
                try {
                    results[3] = CAFPermissionUtil.remoteCheckAclPermission((Object)obj2, (String)userName, (String)"remove", (String)boName);
                }
                catch (CAFPermissionException ex) {
                    results[3] = false;
                }
            }
            Object var17_21 = null;
            try {
                if (tr != null) {
                    tr.rollback();
                }
                break block18;
            }
            catch (Exception ex) {
                CAFPublicLogger.categoryCAF.logThrowableT(0, location, null, "Cannot rollback Resource trqansaction", null, (Throwable)ex);
            }
            {
                break block18;
                catch (Exception ex) {
                    Object[] args = new String[]{boName, guidInstance};
                    CAFPublicLogger.categoryCAF.logThrowableT(500, location, null, "Cannot read business entity for permission check: bo={0} instance={1}", args, (Throwable)ex);
                    throw new DataAccessException("CANNOT_READ_BO", args, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var17_22 = null;
                try {
                    if (tr != null) {
                        tr.rollback();
                    }
                }
                catch (Exception ex) {
                    CAFPublicLogger.categoryCAF.logThrowableT(0, location, null, "Cannot rollback Resource trqansaction", null, (Throwable)ex);
                }
                CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
                throw throwable;
            }
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return results;
    }

    public BO getBO(String prov, String app, String bo) throws DataAccessException {
        String method = "checkRights(String, String, String, String[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{prov, app, bo});
        DataObject so = this.mmrProxy.getDataObject(prov, app, bo);
        location.debugT("Reading metadata from mmr successfull", new Object[0]);
        BO tmp = this.convertBO(so);
        location.debugT("Converting metadata successfull", new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    private String getDocumentBEServiceName() throws DataAccessException {
        if (m_beDocumentServiceName == null) {
            BusinessEntityInterface bei = this.mmrProxy.getDataObject(BE_DOCUMENT_NAME).getBusinessEntityInterface();
            Application app = bei.getApplication();
            m_beDocumentServiceName = JNDI_PREFIX + app.getProviderName() + "/" + app.getObjectName() + "/" + bei.getObjectName();
        }
        return m_beDocumentServiceName;
    }

    private TransactionManager getResourceTransaction() throws NamingException {
        return (TransactionManager)this.ctx.lookup("TransactionManager");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

