/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;

public final class XFDump
implements XFunction {
    private StringBuffer buffer = new StringBuffer(100);
    private int[] temp = null;
    private int nTemp;
    private DTM dtm;

    public static String toString(DTM dtm, XObject xo) throws XPathException {
        return new XFDump().execute(new XObject[]{xo}, dtm.getInitialContext()).toString();
    }

    public synchronized XObject execute(XObject[] a, XPathContext context) throws XPathException {
        int t = a[0].getType();
        if (t != 4) {
            XString r = a[0].toXString();
            System.out.flush();
            return r;
        }
        this.dtm = context.dtm;
        XNodeSet xns = (XNodeSet)a[0];
        DTM dtm = xns.dtm;
        if (this.temp == null) {
            this.temp = new int[100];
        }
        this.buffer.setLength(0);
        this.buffer.append("{\n");
        IntArrayIterator i = xns.sensitiveIterator();
        while (i.hasNext()) {
            int x = i.next();
            this.buffer.append("  ");
            if (x != 0) {
                this.pathTo(x);
            } else {
                this.buffer.append("/");
            }
            this.buffer.append('\n');
        }
        this.buffer.append("}");
        System.out.flush();
        return context.getXFactCurrent().getXString(this.buffer.toString());
    }

    private void pathTo(int x) {
        String name;
        if (x == -1) {
            return;
        }
        if (x == 0) {
            return;
        }
        byte t = this.dtm.nodeType[x];
        int p = this.dtm.parent[x];
        try {
            name = this.dtm.name[x].rawname.getString();
        }
        catch (NullPointerException _) {
            name = "";
        }
        if (t == 2) {
            this.pathTo(p);
            this.buffer.append("/@").append(name);
        } else if (t == 1) {
            this.pathTo(p);
            this.buffer.append("/").append(name);
        } else if (t == 8) {
            this.pathTo(p);
            this.buffer.append("/comment()");
        } else if (t == 7) {
            this.pathTo(p);
            this.buffer.append("/processing-instruction('").append(name).append("')");
        } else if (t == 3) {
            this.pathTo(p);
            this.buffer.append("/text()");
        } else {
            this.pathTo(p);
            this.buffer.append("/?");
        }
        int countSiblings = 0;
        int countPrecedingSiblings = 0;
        int y = this.dtm.previousSibling[x];
        while (y != -1) {
            try {
                if (name.equals(this.dtm.name[y].rawname.getString())) {
                    ++countSiblings;
                    ++countPrecedingSiblings;
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            y = this.dtm.previousSibling[y];
        }
        int y2 = this.dtm.nextSibling[x];
        while (y2 != -1) {
            try {
                if (name.equals(this.dtm.name[y2].rawname.getString())) {
                    ++countSiblings;
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            y2 = this.dtm.nextSibling[y2];
        }
        if (countSiblings != 0) {
            this.buffer.append('[').append(countPrecedingSiblings + 1).append(']');
        }
    }

    public boolean confirmArgumentTypes(XObject[] a) {
        return a.length == 1;
    }

    public String getFunctionName() {
        return "dump";
    }
}

