/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.util.FileClassLoader;
import com.sap.engine.lib.xsl.xpath.FunctionLibrary;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.functions.JLBFunction;
import java.io.File;
import java.util.StringTokenizer;

public class JLBLibrary
implements FunctionLibrary {
    private CharArray classNameOrg;
    private CharArray classNameStrip;
    private String classPath;
    private FileClassLoader fileClassLoader;
    private Class userClass;

    public JLBLibrary(String className) throws ClassNotFoundException {
        this(className, null);
    }

    public JLBLibrary(String className, ClassLoader extClassLoader) throws ClassNotFoundException {
        block4: {
            this.classNameOrg = new CharArray();
            this.classNameStrip = new CharArray();
            this.classPath = null;
            this.fileClassLoader = null;
            this.userClass = null;
            this.classNameOrg.set(className);
            this.classNameStrip.set(this.checkClass(className));
            try {
                this.getClass();
                this.userClass = Class.forName(this.checkClass(className));
            }
            catch (ClassNotFoundException e) {
                try {
                    this.userClass = Thread.currentThread().getContextClassLoader().loadClass(this.checkClass(className));
                }
                catch (ClassNotFoundException e1) {
                    if (extClassLoader == null) break block4;
                    this.userClass = extClassLoader.loadClass(this.checkClass(className));
                }
            }
        }
    }

    public JLBLibrary(String name, String className, String classPath) throws ClassNotFoundException {
        this(name, className, classPath, null);
    }

    public JLBLibrary(String name, String className, String classPath, ClassLoader extClassLoader) throws ClassNotFoundException {
        block12: {
            this.classNameOrg = new CharArray();
            this.classNameStrip = new CharArray();
            this.classPath = null;
            this.fileClassLoader = null;
            this.userClass = null;
            if (name == null) {
                this.classNameOrg.set(className);
                this.classNameStrip.set(this.checkClass(className));
            } else {
                this.classNameOrg.set(name);
                this.classNameStrip.set(this.checkClass(name));
            }
            this.classPath = classPath;
            this.fileClassLoader = new FileClassLoader(this.getClass().getClassLoader(), "");
            if (classPath.length() > 0) {
                this.fileClassLoader.addMixed(this.prepareFiles(classPath));
                try {
                    this.userClass = this.fileClassLoader.loadClass(this.checkClass(className));
                }
                catch (ClassNotFoundException e) {
                    try {
                        this.userClass = Thread.currentThread().getContextClassLoader().loadClass(this.checkClass(className));
                        break block12;
                    }
                    catch (ClassNotFoundException e1) {
                        if (extClassLoader != null) {
                            this.userClass = extClassLoader.loadClass(this.checkClass(className));
                        }
                        break block12;
                    }
                }
            }
            try {
                this.getClass();
                this.userClass = Class.forName(this.checkClass(className));
            }
            catch (ClassNotFoundException e) {
                try {
                    this.userClass = Thread.currentThread().getContextClassLoader().loadClass(this.checkClass(className));
                }
                catch (ClassNotFoundException e1) {
                    if (extClassLoader == null) break block12;
                    this.userClass = extClassLoader.loadClass(this.checkClass(className));
                }
            }
        }
    }

    public String checkClass(String cl) {
        if (cl.startsWith("java:")) {
            cl = cl.substring(5);
        } else if (cl.startsWith("xalan:")) {
            cl = cl.substring(6);
        }
        while (cl.length() > 0 && cl.charAt(0) == '/') {
            cl = cl.substring(1);
        }
        return cl;
    }

    public XFunction getFunction(CharArray method) throws XPathException {
        if (this.userClass == null) {
            throw new XPathException("Could not load class: " + this.classNameOrg + " required for execution of '" + method + "'");
        }
        return new JLBFunction(this.userClass, method.toString());
    }

    public void init(String className) {
        this.classNameOrg.set(className);
    }

    public CharArray getName() {
        return this.classNameOrg;
    }

    public CharArray getClassName() {
        return this.classNameStrip;
    }

    public void setUserClass(Class cl) {
        this.userClass = cl;
    }

    private File[] prepareFiles(String path) {
        StringTokenizer st = new StringTokenizer(path, "\n\t \r,;");
        File[] result = new File[st.countTokens()];
        File f = null;
        int i = 0;
        while (i < st.countTokens()) {
            result[i] = f = new File((String)st.nextElement());
            ++i;
        }
        return result;
    }
}

