/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.security.Key;
import java.security.MessageDigest;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;

public class RSA_OAEP_Transporter
extends KeyTransporter {
    GenericElement parent = null;
    String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
    byte[] octets2 = new byte[0];

    public RSA_OAEP_Transporter(GenericElement parent) throws SignatureException {
        GenericElement param2;
        this.parent = parent;
        GenericElement par = parent.getDirectChild("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        GenericElement el = par.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (el != null) {
            this.digestMethod = el.getAttribute("Algorithm", null, null);
        }
        if ((param2 = par.getDirectChild(null, "OAEPparams")) != null) {
            String s = XMLCryptor.gatherText(param2.getDomRepresentation());
            this.octets2 = BASE64Decoder.decode(s.getBytes());
        }
    }

    public RSA_OAEP_Transporter() throws SignatureException {
    }

    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        Cipher cipher = null;
        try {
            try {
                RSAKey temp = (RSAKey)((Object)wrapping);
                int k = (temp.getModulus().bitLength() + 7) / 8;
                byte[] encoded = this.eme_oaep_encode(wrapped.getEncoded(), k - 1);
                cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "ECB", "NoPadding");
                cipher.init(1, wrapping);
                byte[] encrypted = cipher.doFinal(encoded, 0, encoded.length);
                if (encrypted.length < k) {
                    byte[] t = new byte[k];
                    System.arraycopy(encrypted, 0, t, k - encrypted.length, encrypted.length);
                    encrypted = t;
                }
                byte[] byArray = encrypted;
                Object var10_11 = null;
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                return byArray;
            }
            catch (SignatureException ex) {
                throw ex;
            }
            catch (Exception other) {
                throw new SignatureException("Error in unwrapping key with RSA_OAEP_MGF1", other);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            throw throwable;
        }
    }

    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        Cipher cipher = null;
        try {
            try {
                RSAPrivateKey temp = (RSAPrivateKey)wrapping;
                int k = (temp.getModulus().bitLength() + 7) / 8;
                cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "ECB", "NoPadding");
                cipher.init(2, wrapping);
                byte[] decrypted = cipher.doFinal(wrapped, 0, wrapped.length);
                if (decrypted.length < k - 1) {
                    byte[] t = new byte[k - 1];
                    System.arraycopy(decrypted, 0, t, k - 1 - decrypted.length, decrypted.length);
                    decrypted = t;
                }
                byte[] byArray = this.eme_oaep_decode(decrypted);
                Object var9_10 = null;
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                return byArray;
            }
            catch (SignatureException ex) {
                throw ex;
            }
            catch (Exception other) {
                throw new SignatureException("Error in unwrapping key with RSA_OAEP_MGF1", other);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            throw throwable;
        }
    }

    protected static byte[] mgf1(byte[] seed, int offset, int seedLength, int outputLength) throws SignatureException {
        byte[] b = new byte[seedLength];
        System.arraycopy(seed, offset, b, 0, seedLength);
        if (outputLength < 0) {
            throw new SignatureException("Illegal mask length");
        }
        MessageDigest digest = null;
        try {
            try {
                digest = SignatureContext.getCryptographicPool().getMessageDigestFromPool("http://www.w3.org/2000/09/xmldsig#sha1");
                byte[] t = new byte[outputLength];
                int index = 0;
                byte[] buffer = new byte[seedLength + 4];
                System.arraycopy(seed, offset, buffer, 0, seedLength);
                while (index < outputLength) {
                    byte[] temp = digest.digest(buffer);
                    int copy = temp.length < outputLength - index ? temp.length : outputLength - index;
                    System.arraycopy(temp, 0, t, index, copy);
                    index += copy;
                    RSA_OAEP_Transporter.inc(buffer);
                }
                byte[] byArray = t;
                Object var12_13 = null;
                SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                return byArray;
            }
            catch (SignatureException ex) {
                throw ex;
            }
            catch (Exception ex1) {
                throw new SignatureException("Error in mask generation function", ex1);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
            throw throwable;
        }
    }

    protected static void inc(byte[] array) {
        int len;
        int n = len = array.length - 1;
        array[n] = (byte)(array[n] + 1);
        while (array[len] == 0) {
            int n2 = --len;
            array[n2] = (byte)(array[n2] + 1);
        }
    }

    protected byte[] eme_oaep_decode(byte[] encodedMessage) throws SignatureException {
        MessageDigest digest = null;
        try {
            try {
                digest = SignatureContext.getCryptographicPool().getMessageDigestFromPool(this.digestMethod);
                int k = digest.getDigestLength();
                if (encodedMessage.length < 2 * k + 1) {
                    throw new SignatureException("EME-OAEP_DECODE error: insufficient length of encoded message: " + encodedMessage.length + " must be at least" + (2 * k + 1));
                }
                byte[] maskedSeed = RSA_OAEP_Transporter.mgf1(encodedMessage, k, encodedMessage.length - k, k);
                int i = 0;
                while (i < maskedSeed.length) {
                    int n = i;
                    maskedSeed[n] = (byte)(maskedSeed[n] ^ encodedMessage[i]);
                    ++i;
                }
                byte[] dbMask = RSA_OAEP_Transporter.mgf1(maskedSeed, 0, maskedSeed.length, encodedMessage.length - k);
                int i2 = 0;
                while (i2 < dbMask.length) {
                    int n = i2;
                    dbMask[n] = (byte)(dbMask[n] ^ encodedMessage[i2 + k]);
                    ++i2;
                }
                byte[] pHash = digest.digest(this.octets2);
                int index = 0;
                while (index < k) {
                    if (pHash[index] != dbMask[index]) {
                        throw new SignatureException("EME-OAEP_DECODE error - pHash does not equal pHash'");
                    }
                    ++index;
                }
                while (dbMask[index++] == 0) {
                }
                if (dbMask[index - 1] != 1) {
                    throw new SignatureException("EME-OAEP_DECODE error - no 01 separator befor message'");
                }
                byte[] decoded = new byte[dbMask.length - index];
                System.arraycopy(dbMask, index, decoded, 0, decoded.length);
                byte[] byArray = decoded;
                Object var13_14 = null;
                SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                return byArray;
            }
            catch (SignatureException sig) {
                throw sig;
            }
            catch (Exception ex) {
                throw new SignatureException("Error in EME-OAEP-DECODE", new Object[]{encodedMessage, this.octets2, this.digestMethod}, ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
            throw throwable;
        }
    }

    protected byte[] eme_oaep_encode(byte[] message, int emLen) throws SignatureException {
        MessageDigest digest = null;
        try {
            try {
                digest = SignatureContext.getCryptographicPool().getMessageDigestFromPool(this.digestMethod);
                int k = digest.getDigestLength();
                if (message.length > emLen - 2 * k - 1) {
                    throw new SignatureException("EME-OAEP_ENCODE error: message too long: " + message.length + " must be at most" + (emLen - 2 * k - 1));
                }
                int PS = emLen - message.length - 2 * k - 1;
                byte[] pHash = digest.digest(this.octets2);
                byte[] db = new byte[k + PS + 1 + message.length];
                System.arraycopy(pHash, 0, db, 0, k);
                db[k + PS] = 1;
                System.arraycopy(message, 0, db, k + PS + 1, message.length);
                byte[] seed = new byte[k];
                this.randomize(seed);
                byte[] dbSeed = RSA_OAEP_Transporter.mgf1(seed, 0, k, emLen - k);
                int i = 0;
                while (i < dbSeed.length) {
                    int n = i;
                    dbSeed[n] = (byte)(dbSeed[n] ^ db[i]);
                    ++i;
                }
                byte[] maskedSeed = RSA_OAEP_Transporter.mgf1(dbSeed, 0, dbSeed.length, k);
                int i2 = 0;
                while (i2 < k) {
                    int n = i2;
                    maskedSeed[n] = (byte)(maskedSeed[n] ^ seed[i2]);
                    ++i2;
                }
                byte[] ret = new byte[emLen];
                System.arraycopy(maskedSeed, 0, ret, 0, k);
                System.arraycopy(dbSeed, 0, ret, k, dbSeed.length);
                byte[] byArray = ret;
                Object var16_17 = null;
                SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
                return byArray;
            }
            catch (SignatureException sig) {
                throw sig;
            }
            catch (Exception ex) {
                throw new SignatureException("Error in EME-OAEP-DECODE", new Object[]{message, this.octets2, this.digestMethod}, ex);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            SignatureContext.getCryptographicPool().releaseMessageDigest(digest);
            throw throwable;
        }
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public byte[] getOctets2() {
        return this.octets2;
    }

    public void setOctets2(byte[] octets2) {
        this.octets2 = octets2;
    }
}

