/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyValue;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;

public class RSAKeyValue
extends KeyValue {
    private BigInteger modulus = null;
    private BigInteger exponent = null;
    private Certificate certificate = null;
    private RSAPublicKey publicKey = null;

    public RSAKeyValue(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public Certificate getCerificate() {
        return this.certificate;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = (RSAPublicKey)publicKey;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void construct() throws SignatureException {
        if (this.publicKey == null && this.certificate != null) {
            try {
                this.publicKey = (RSAPublicKey)this.certificate.getPublicKey();
            }
            catch (ClassCastException e) {
                throw new SignatureException("DSA key expected but " + this.certificate.getPublicKey().getAlgorithm() + " key received", new Object[]{this.certificate}, e);
            }
        }
        this.modulus = this.publicKey.getModulus();
        this.exponent = this.publicKey.getPublicExponent();
        GenericElement keyValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:RSAKeyValue", this);
        GenericElement valueModulus = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Modulus", keyValue);
        valueModulus.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.modulus))));
        GenericElement valueExponent = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Exponent", keyValue);
        valueExponent.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.exponent))));
    }
}

