/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.DSAKeyValue;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyValue;
import com.sap.engine.lib.xml.signature.elements.RSAKeyValue;
import com.sap.engine.lib.xml.signature.elements.RetrievalMethod;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptedType;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends GenericElement {
    private String keyName = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private Certificate[] certificates = null;
    private String[] certTypes = null;
    protected Key key = null;
    protected byte[] encodedKey = null;

    public KeyInfo(Node parent) throws SignatureException {
        super(parent != null ? parent.getOwnerDocument() : null, "http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", null);
        if (parent != null) {
            Node kiNode = this.getDomRepresentation();
            Node enKey = parent;
            NodeList method = ((Element)enKey).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
            if (method.getLength() > 0) {
                enKey.insertBefore(kiNode, method.item(method.getLength() - 1).getNextSibling());
            } else {
                enKey.insertBefore(kiNode, enKey.getFirstChild());
            }
        } else {
            this.getOwner().appendChild(this.domRepresentation);
        }
    }

    public KeyInfo() {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
    }

    public KeyInfo(GenericElement parent) throws SignatureException {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", parent);
    }

    public KeyInfo(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public KeyInfo(Element domRepresentation, GenericElement parent) throws SignatureException {
        super(domRepresentation, parent);
    }

    public String getKeyName() {
        try {
            GenericElement el = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyName");
            if (el != null) {
                this.keyName = XMLCryptor.gatherText(el.getDomRepresentation());
                return this.keyName;
            }
        }
        catch (Exception ex) {
            new SignatureException(ex);
        }
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Certificate[] getCerificates() {
        return this.certificates;
    }

    public void setCertificates(Certificate[] certificates) {
        this.certificates = certificates;
        this.certTypes = SignatureContext.getTypes(certificates);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void addKeyName() throws SignatureException {
        GenericElement name = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:KeyName", this);
        name.appendTextChild(this.keyName);
    }

    public void addCertificateInfo() throws CertificateEncodingException, SignatureException {
        String[] uniques = SignatureContext.removeDuplicates(this.certTypes);
        int i = 0;
        while (i < uniques.length) {
            String whatData = uniques[i] + "Data";
            String whatCertificate = uniques[i] + "Certificate";
            GenericElement data = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:" + whatData, this);
            int j = 0;
            while (j < this.certTypes.length) {
                if (this.certTypes[j].equals(uniques[i])) {
                    String encCert = new String(BASE64Encoder.encode(this.certificates[j].getEncoded()));
                    GenericElement certData = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:" + whatCertificate, data);
                    certData.appendTextChild(encCert);
                    this.appendChild(data);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addKeyValue(String keyType) throws SignatureException {
        KeyValue dKey;
        if (keyType.equalsIgnoreCase("dsa")) {
            dKey = new DSAKeyValue("http://www.w3.org/2000/09/xmldsig#", "ds:KeyValue", this);
        } else if (keyType.equalsIgnoreCase("rsa")) {
            dKey = new RSAKeyValue("http://www.w3.org/2000/09/xmldsig#", "ds:KeyValue", this);
        } else {
            throw new SignatureException("Unrecognized signature type: " + keyType, new Object[]{keyType});
        }
        if (this.certificates != null && this.certificates[0] != null) {
            dKey.setCertificate(this.certificates[0]);
        }
        dKey.setPublicKey(this.publicKey);
        dKey.construct();
        this.appendChild(dKey);
    }

    public byte[] getEncodedKey() throws SignatureException {
        if (this.encodedKey != null) {
            return this.encodedKey;
        }
        if (this.getKey() != null) {
            this.encodedKey = this.key.getEncoded();
            return this.encodedKey;
        }
        return this.encodedKey;
    }

    public Key getKey() throws SignatureException {
        if (this.key != null) {
            return this.key;
        }
        if (this.getKeyName() != null) {
            this.key = SignatureContext.getKeyAliasResolver().getKey(this.keyName);
            return this.key;
        }
        GenericElement el = this.getDirectChild("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (el != null) {
            EncryptedKey ek = (EncryptedKey)el;
            this.key = ek.getWrappedKey();
            if (this.key == null) {
                this.encodedKey = ek.getWrappedKeyEncoded();
            }
            return this.key;
        }
        el = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
        if (el != null) {
            RetrievalMethod met = (RetrievalMethod)el;
            met.init();
            Element key1 = met.getElementByID(met.uri.substring(1));
            EncryptedKey enc = new EncryptedKey(key1, true);
            enc.initializeDescendants();
            enc.setType(((EncryptedType)this.parent).getEncryptionMethod().getAlgorithmURI());
            this.key = enc.getWrappedKey();
            return this.key;
        }
        el = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "X509Data");
        if (el != null && (el = el.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "X509Certificate")) != null) {
            try {
                String base64encodedCertificate = XMLCryptor.gatherText(el.getDomRepresentation());
                CertificateFactory certFact = CertificateFactory.getInstance("X509", Configurator.getProviderName());
                Certificate cert = certFact.generateCertificate(new ByteArrayInputStream(BASE64Decoder.decode(base64encodedCertificate.getBytes())));
                this.key = SignatureContext.getKeyAliasResolver().getKey(cert);
                return this.key;
            }
            catch (Exception ex) {
                throw new SignatureException("Unable to read certificate", new Object[]{this.domRepresentation}, ex);
            }
        }
        return null;
    }
}

