/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.dtd;

import com.sap.engine.lib.xml.parser.dtd.DTDElement;
import com.sap.engine.lib.xml.parser.dtd.Model;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Enumeration;
import java.util.Vector;

final class DTDAttribute {
    XMLValidator validator;
    CharArray name = new CharArray();
    DTDElement owner = null;
    CharArray defValue = new CharArray();
    CharArray type = new CharArray();
    CharArray defDecl = new CharArray();
    Vector choices = null;

    DTDAttribute(XMLValidator validator, CharArray name, CharArray type, CharArray defDecl, CharArray defValue, DTDElement owner) {
        this.validator = validator;
        this.name.set(name);
        this.type.set(type);
        this.defDecl.set(defDecl);
        this.defValue.set(defValue);
        this.owner = owner;
    }

    void confirmValue(CharArray v0) throws ValidationException {
        CharArray v = new CharArray(v0);
        v.trim();
        if (this.defDecl.equals("#FIXED")) {
            if (!v.equals(this.defValue)) {
                throw new ValidationException(this.validator, "Attribute '" + this.name + "' to element '" + this.owner.name + "' was #FIXED with '" + this.defValue + "' but supplied with '" + v + "'.");
            }
            return;
        }
        Model model = new Model(this.validator, v);
        if (this.type.equals("ID")) {
            if (!v.isName()) {
                throw new ValidationException(this.validator, "Attribute values of type ID must match the name production. " + this);
            }
            if (this.validator.usedIds.contains(v)) {
                throw new ValidationException(this.validator, "ID '" + v + "' has already been used. " + this);
            }
            this.validator.usedIds.addElement(v);
        } else if (this.type.equals("IDREF")) {
            if (!v.isName()) {
                throw new ValidationException(this.validator, "IDREF attribute values must match the name production. " + this);
            }
            this.validator.referencedIds.addElement(v);
        } else {
            if (this.type.equals("IDREFS")) {
                try {
                    Enumeration e = model.getNmTokens().elements();
                    while (e.hasMoreElements()) {
                        CharArray ca = (CharArray)e.nextElement();
                        if (!ca.isName() && !v.isName()) {
                            throw new ValidationException(this.validator, "IDREFS attribute values must match the names production. ");
                        }
                        this.validator.referencedIds.addElement(ca);
                    }
                }
                catch (ValidationException e) {
                    throw new ValidationException(this.validator, e.getMessage() + this);
                }
            }
            if (this.type.equals("ENTITY")) {
                if (!v.isName()) {
                    throw new ValidationException(this.validator, "ENTITY attribute values must match the name production. " + this);
                }
                if (!this.validator.entities.contains(v)) {
                    throw new ValidationException(this.validator, "ENTITY '" + v + "' used as an attribute value, but not declared in DTD");
                }
            } else if (this.type.equals("ENTITIES")) {
                Vector vNames;
                try {
                    vNames = model.getNames();
                }
                catch (ValidationException e) {
                    throw new ValidationException(this.validator, "ENTITIES attribute values must match the names production. ");
                }
                Enumeration e = vNames.elements();
                while (e.hasMoreElements()) {
                    CharArray ca = (CharArray)e.nextElement();
                    if (this.validator.entities.contains(ca)) continue;
                    throw new ValidationException(this.validator, "ENTITY '" + ca + "' used as an attribute value, but not declared in DTD");
                }
            } else if (this.type.equals("NMTOKEN")) {
                try {
                    model.getNmToken();
                    model.confirmEndOfModel();
                }
                catch (ValidationException e) {
                    throw new ValidationException(this.validator, e.getMessage() + this);
                }
            } else if (this.type.equals("NMTOKENS")) {
                try {
                    model.getNmToken();
                    while (!model.finished()) {
                        model.skipOptionalWhitespace();
                        model.getNmToken();
                    }
                }
                catch (ValidationException e) {
                    throw new ValidationException(this.validator, e.getMessage() + this);
                }
            } else if (this.type.equals("NOTATION")) {
                if (!this.choices.contains(v)) {
                    throw new ValidationException(this.validator, "Value '" + v + "' not found in NOTATION list. " + this);
                }
            } else if (!this.type.equals("CDATA") && this.type.equals("ENUMERATION") && !this.choices.contains(v)) {
                throw new ValidationException(this.validator, "Value not found in ENUMERATION list. " + this);
            }
        }
    }

    public String toString() {
        return "(Attribute '" + this.name + "' to element '" + this.owner.name + "', type='" + this.type + "', defDecl='" + this.defDecl + "', defValue='" + this.defValue + "')";
    }
}

