/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.validator.automat.DescendentMappingStructure;
import com.sap.engine.lib.schema.validator.automat.State;
import java.util.Vector;

public class ContentAutomat
implements Constants {
    private State firstState;
    private State currentState;
    private State lastState;

    public ContentAutomat(ComplexTypeDefinition compleTypeDef) {
        this.init(compleTypeDef);
    }

    private void init(ComplexTypeDefinition compleTypeDef) {
        this.firstState = new State();
        this.lastState = new State();
        this.currentState = this.firstState;
        this.init_Particle(compleTypeDef.getContentTypeContentModel(), new State[]{this.firstState, this.lastState}, null);
    }

    private void init_Particle(Particle particle, State[] firstAndLast, ModelGroup scopeModelGroupAll) {
        if (particle == null) {
            firstAndLast[0].addDescendent("redirect.automat.rib", firstAndLast[1]);
            return;
        }
        State firstState = null;
        State lastState = null;
        int minOccurs = particle.getMinOccurs();
        int maxOccurs = particle.getMaxOccurs();
        boolean isUnbounded = particle.isMaxOccursUnbounded();
        Base term = particle.getTerm();
        if (minOccurs == 0 && !isUnbounded) {
            firstState = firstAndLast[0];
            lastState = new State();
            this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
            firstState.addDescendent("redirect.automat.rib", lastState);
            lastState.addDescendent("redirect.automat.rib", firstAndLast[1]);
            int i = 0;
            while (i < maxOccurs - 1) {
                firstState = lastState;
                lastState = new State();
                this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
                lastState.addDescendent("redirect.automat.rib", firstAndLast[1]);
                ++i;
            }
        } else if (minOccurs == 0 && isUnbounded) {
            firstState = new State();
            lastState = firstAndLast[1];
            this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
            firstState.addDescendent("redirect.automat.rib", lastState);
            lastState.addAllDescendents(firstState);
            firstAndLast[0].addAllDescendents(firstState);
        } else if (minOccurs > 0 && !isUnbounded) {
            firstState = firstAndLast[0];
            int i = 0;
            while (i < minOccurs) {
                if (i != 0) {
                    firstState = lastState;
                }
                lastState = i == minOccurs - 1 && minOccurs == maxOccurs ? firstAndLast[1] : new State();
                this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
                ++i;
            }
            if (maxOccurs > minOccurs) {
                lastState.addDescendent("redirect.automat.rib", firstAndLast[1]);
                int i2 = 0;
                while (i2 < maxOccurs - minOccurs) {
                    firstState = lastState;
                    lastState = new State();
                    this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
                    lastState.addDescendent("redirect.automat.rib", firstAndLast[1]);
                    ++i2;
                }
            }
        } else if (minOccurs > 0 && isUnbounded) {
            firstState = minOccurs == 1 ? new State() : firstAndLast[0];
            int i = 0;
            while (i < minOccurs) {
                if (i != 0) {
                    firstState = lastState;
                }
                lastState = i == minOccurs - 1 ? firstAndLast[1] : new State();
                this.init_Term(term, new State[]{firstState, lastState}, scopeModelGroupAll);
                ++i;
            }
            firstAndLast[1].addAllDescendents(firstState);
            if (minOccurs == 1) {
                firstAndLast[0].addAllDescendents(firstState);
            }
        }
    }

    private void init_Term(Base term, State[] firstAndLast, ModelGroup scopeModelGroupAll) {
        if (term instanceof ElementDeclaration) {
            this.init_ElemeneDeclaration((ElementDeclaration)term, firstAndLast, false, scopeModelGroupAll);
        } else if (term instanceof Wildcard) {
            this.init_Wildcard((Wildcard)term, firstAndLast);
        } else if (term instanceof ModelGroup) {
            this.init_ModelGroup((ModelGroup)term, firstAndLast);
        } else if (term instanceof ModelGroupDefinition) {
            this.init_ModelGroupDefinition((ModelGroupDefinition)term, firstAndLast);
        }
    }

    private void init_ElemeneDeclaration(ElementDeclaration elemDeclaration, State[] firstAndLast, boolean isSubstitution, ModelGroup scopeModelGroupAll) {
        firstAndLast[0].addDescendent(elemDeclaration, firstAndLast[1], isSubstitution, scopeModelGroupAll);
        Vector substitutableElemDeclarsCollector = new Vector();
        elemDeclaration.getSubstitutableElementDeclarations(substitutableElemDeclarsCollector);
        int i = 0;
        while (i < substitutableElemDeclarsCollector.size()) {
            ElementDeclaration substElemDeclaration = (ElementDeclaration)substitutableElemDeclarsCollector.get(i);
            this.init_ElemeneDeclaration(substElemDeclaration, firstAndLast, true, scopeModelGroupAll);
            ++i;
        }
    }

    private void init_Wildcard(Wildcard wildcard, State[] firstAndLast) {
        firstAndLast[0].addDescendent(wildcard, firstAndLast[1], false, null);
    }

    private void init_ModelGroup(ModelGroup modelGroup, State[] firstAndLast) {
        Vector particlesCollector = new Vector();
        modelGroup.getParticles(particlesCollector);
        if (particlesCollector.size() == 0) {
            firstAndLast[0].addDescendent("redirect.automat.rib", firstAndLast[1]);
            return;
        }
        if (modelGroup.isCompositorChoice()) {
            this.init_ChoiceModelGroup(particlesCollector, firstAndLast);
        } else if (modelGroup.isCompositorSequence()) {
            this.init_SequenceModelGroup(particlesCollector, firstAndLast);
        } else if (modelGroup.isCompositorAll()) {
            this.init_AllModelGroup(particlesCollector, firstAndLast, modelGroup);
        }
    }

    private void init_ModelGroupDefinition(ModelGroupDefinition modelGroupDefinition, State[] firstAndLast) {
        this.init_ModelGroup(modelGroupDefinition.getModelGroup(), firstAndLast);
    }

    private void init_ChoiceModelGroup(Vector particlesCollector, State[] firstAndLast) {
        int i = 0;
        while (i < particlesCollector.size()) {
            Particle particle = (Particle)particlesCollector.get(i);
            State intermediateState = new State();
            this.init_Particle(particle, new State[]{firstAndLast[0], intermediateState}, null);
            intermediateState.addDescendent("redirect.automat.rib", firstAndLast[1]);
            ++i;
        }
    }

    private void init_SequenceModelGroup(Vector particlesCollector, State[] firstAndLast) {
        State first = null;
        State last = null;
        State hlp = null;
        int i = 0;
        while (i < particlesCollector.size()) {
            Particle particle = (Particle)particlesCollector.get(i);
            hlp = last;
            last = i == particlesCollector.size() - 1 ? firstAndLast[1] : new State();
            first = i == 0 ? firstAndLast[0] : hlp;
            this.init_Particle(particle, new State[]{first, last}, null);
            ++i;
        }
    }

    private void init_AllModelGroup(Vector particlesCollector, State[] firstAndLast, ModelGroup modelGroup_All) {
        this.init_AllModelGroup(particlesCollector, firstAndLast[0], firstAndLast[1], modelGroup_All);
    }

    private void init_AllModelGroup(Vector particlesCollector, State firstState, State lastState, ModelGroup modelGroup_All) {
        int i = 0;
        while (i < particlesCollector.size()) {
            Particle particle = (Particle)particlesCollector.get(i);
            if (particlesCollector.size() == 1) {
                this.init_Particle(particle, new State[]{firstState, lastState}, modelGroup_All);
            } else {
                Vector newCollector = new Vector(particlesCollector);
                newCollector.remove(i);
                State lastInitState = new State();
                this.init_Particle(particle, new State[]{firstState, lastInitState}, modelGroup_All);
                this.init_AllModelGroup(newCollector, lastInitState, lastState, modelGroup_All);
            }
            ++i;
        }
    }

    public DescendentMappingStructure switchState(String uri, String name) {
        DescendentMappingStructure structure = this.currentState.getDescendent(uri, name);
        if (structure != null) {
            this.currentState = structure.getState();
        }
        return structure;
    }

    public boolean isInFinalState() {
        if (this.currentState == this.lastState) {
            return true;
        }
        return this.currentState.redirectToState(this.lastState);
    }

    public boolean isInStartingState() {
        return this.currentState == this.firstState;
    }

    public void reset() {
        this.currentState = this.firstState;
    }

    public void display() {
        System.out.println("first state : " + this.firstState.getId());
        System.out.println("last state : " + this.lastState.getId());
        System.out.println();
        this.firstState.display();
    }
}

