/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ModelGroupDefinitionImpl
extends QualifiedBaseImpl
implements ModelGroupDefinition {
    protected ModelGroupImpl modelGroup;

    public ModelGroupDefinitionImpl() {
        this(null, null);
    }

    public ModelGroupDefinitionImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public ModelGroupDefinitionImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public ModelGroup getModelGroup() {
        return this.modelGroup;
    }

    public int getTypeOfComponent() {
        return 8;
    }

    public boolean match(Base modelGroupDef) {
        if (!super.match(modelGroupDef)) {
            return false;
        }
        ModelGroupDefinitionImpl targetModelGroupDef = (ModelGroupDefinitionImpl)modelGroupDef;
        return Tools.compareBases(this.modelGroup, targetModelGroupDef.modelGroup);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("all") || nodeLocalName.equals("choice") || nodeLocalName.equals("sequence")) {
                        this.modelGroup = SchemaStructuresFactory.createModelGroup(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.modelGroup);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            if (!this.isAnonymous() && this.searchForThisModelGroupDefinition(this.modelGroup)) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of model group " + DOM.toXPath(this.associatedNode) + " is not correct. Circular definitions are prohibited.");
            }
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    private boolean searchForThisModelGroupDefinition(ModelGroupImpl modelGroup) {
        int i = 0;
        while (i < modelGroup.particlesCollector.size()) {
            ParticleImpl particle = (ParticleImpl)modelGroup.particlesCollector.get(i);
            BaseImpl term = particle.term;
            if (term instanceof ModelGroupDefinitionImpl) {
                ModelGroupDefinitionImpl modelGroupDef = (ModelGroupDefinitionImpl)term;
                if (modelGroupDef == this) {
                    return true;
                }
                return this.searchForThisModelGroupDefinition(modelGroupDef.modelGroup);
            }
            ++i;
        }
        return false;
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ModelGroupDefinitionImpl result = (ModelGroupDefinitionImpl)super.initializeBase(base, clonedCollector);
        result.modelGroup = (ModelGroupImpl)this.modelGroup.clone(clonedCollector);
        return result;
    }
}

