/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeGroupDefinition;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttributeGroupDefinitionImpl
extends QualifiedBaseImpl
implements AttributeGroupDefinition {
    protected WildcardImpl attributeWildcard;
    protected Vector attribUsesCollector = new Vector();

    public AttributeGroupDefinitionImpl() {
        this(null, null);
    }

    public AttributeGroupDefinitionImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public AttributeGroupDefinitionImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    public int getTypeOfComponent() {
        return 5;
    }

    public void getAttributeUses(Vector attribUsesCollector) {
        Tools.removeFromVectorToVector(this.attribUsesCollector, attribUsesCollector);
    }

    public AttributeUse[] getAttributeUsesArray() {
        Object[] result = new AttributeUse[this.attribUsesCollector.size()];
        this.attribUsesCollector.copyInto(result);
        return result;
    }

    public boolean match(Base attribGroupDef) {
        if (!super.match(attribGroupDef)) {
            return false;
        }
        AttributeGroupDefinitionImpl targetAttribGroupDef = (AttributeGroupDefinitionImpl)attribGroupDef;
        if (!Tools.compareUnorderdSetsOfBases(this.attribUsesCollector, targetAttribGroupDef.attribUsesCollector)) {
            return false;
        }
        return Tools.compareBases(this.attributeWildcard, targetAttribGroupDef.attributeWildcard);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            boolean[] hlpArray = new boolean[]{false};
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("anyAttribute")) {
                        WildcardImpl wildcard = SchemaStructuresFactory.createWildcard(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(wildcard);
                        if (this.attributeWildcard != null) {
                            this.attributeWildcard.intersect(wildcard);
                        } else {
                            this.attributeWildcard = wildcard;
                        }
                    } else if (nodeLocalName.equals("attribute")) {
                        AttributeUseImpl attribUse = SchemaStructuresFactory.createAttributeUse(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(attribUse);
                        this.addAttribute(attribUse, hlpArray);
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresFactory.createAttributeGroupDefinition(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(attribGroup);
                        int j = 0;
                        while (j < attribGroup.attribUsesCollector.size()) {
                            AttributeUseImpl attribUse = (AttributeUseImpl)attribGroup.attribUsesCollector.get(j);
                            this.addAttribute(attribUse, hlpArray);
                            ++j;
                        }
                        this.initWildcard(attribGroup.attributeWildcard);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    private void addAttribute(AttributeUseImpl attribUse, boolean[] hlpArray) throws SchemaComponentException {
        AttributeDeclarationImpl attribDeclr = attribUse.attribDeclr;
        if (attribDeclr.typeDefinition.isDerivedFrom(this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false)) {
            if (hlpArray[0]) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute group " + DOM.toXPath(this.associatedNode) + " is not correct. Two distinct members of the {attribute uses} must not have {attribute declaration}s both of whose {type definition}s are or are derived from ID.");
            }
            hlpArray[0] = true;
        }
        int i = 0;
        while (i < this.attribUsesCollector.size()) {
            AttributeUseImpl addedAttribUse = (AttributeUseImpl)this.attribUsesCollector.get(i);
            if (attribDeclr.qualifiedKey.equals(addedAttribUse.attribDeclr.qualifiedKey)) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute group " + DOM.toXPath(this.associatedNode) + " is not correct. Two distinct members of the {attribute uses} must not have {attribute declaration}s both of whose {name}s match and whose {target namespace}s are identical.");
            }
            ++i;
        }
        this.attribUsesCollector.add(attribUse);
    }

    private void initWildcard(WildcardImpl wildcard) throws SchemaComponentException {
        if (wildcard != null) {
            if (this.attributeWildcard == null) {
                this.attributeWildcard = (WildcardImpl)wildcard.clone(new Hashtable());
            } else {
                this.attributeWildcard.intersect(wildcard);
            }
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        AttributeGroupDefinitionImpl result = (AttributeGroupDefinitionImpl)super.initializeBase(base, clonedCollector);
        if (this.attributeWildcard != null) {
            result.attributeWildcard = (WildcardImpl)this.attributeWildcard.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.attribUsesCollector, result.attribUsesCollector, clonedCollector);
        return result;
    }
}

