/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xslt;

import com.inqmy.lib.xml.parser.helpers.CharArray;
import com.inqmy.lib.xsl.xpath.XPathContext;
import com.inqmy.lib.xsl.xpath.XPathException;
import com.inqmy.lib.xsl.xslt.VariableContext;
import com.inqmy.lib.xsl.xslt.XSLAttribute;
import com.inqmy.lib.xsl.xslt.XSLException;
import com.inqmy.lib.xsl.xslt.XSLHeadNode;
import com.inqmy.lib.xsl.xslt.XSLStylesheet;
import com.inqmy.lib.xsl.xslt.XSLVariable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class XSLNode {
    public static final CharArray EMPTY_CARR = new CharArray().setStatic();
    private int current;
    protected XSLNode parent = null;
    protected XSLNode first = null;
    protected XSLNode last = null;
    protected XSLNode next = null;
    protected XSLNode prev = null;
    private XSLNode head = null;
    protected XSLStylesheet owner = null;
    protected VariableContext varContext = new VariableContext(this);
    private Hashtable templateParamsStack = null;
    public Stack setVarStack = new Stack();
    public static final int XSL_NODE_GENERIC = 0;
    public static final int XSL_NODE_TEMPLATE = 1;
    public int TYPE = 0;
    public String realBaseURI;

    public XSLNode() {
    }

    public XSLNode(XSLStylesheet owner, XSLNode parent) throws XSLException {
        this(owner, parent, null);
    }

    public XSLNode(XSLStylesheet owner, XSLNode parent, Node node) throws XSLException {
        this.head = null;
        this.current = 0;
        this.current = 0;
        this.owner = owner;
        this.parent = parent;
        this.first = this.head;
        this.last = this.head;
        if (node != null && node.getNodeType() == 1 && node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform")) {
            Element el = (Element)node;
            String[] parReq = this.getRequiredParams();
            String[] parOpt = this.getOptionalParams();
            NamedNodeMap nn = el.getAttributes();
            int j = 0;
            while (j < parReq.length) {
                if (nn.getNamedItem(parReq[j]) == null) {
                    throw new XSLException("Attribute '" + parReq[j] + "' is required for element '" + el.getNodeName() + '\'');
                }
                ++j;
            }
            int i = 0;
            while (i < nn.getLength()) {
                Node n = nn.item(i);
                if (nn.item(i).getNamespaceURI() == null) {
                    boolean found = false;
                    int j2 = 0;
                    while (j2 < parReq.length) {
                        if (parReq[j2].equals(nn.item(i).getNodeName())) {
                            found = true;
                            break;
                        }
                        if (!found) {
                            int k = 0;
                            while (k < parOpt.length) {
                                if (parOpt[k].equals(nn.item(i).getNodeName())) {
                                    found = true;
                                    break;
                                }
                                ++k;
                            }
                        }
                        if (!found) {
                            throw new XSLException("Attribute '" + nn.item(i).getNodeName() + "' not allowed for element '" + el.getNodeName() + '\'');
                        }
                        ++j2;
                    }
                }
                ++i;
            }
        }
    }

    public abstract void process(XPathContext var1, int var2) throws XSLException, XPathException;

    public abstract void print(String var1);

    protected Hashtable getTemplateParamsStack() {
        if (this.templateParamsStack == null) {
            this.templateParamsStack = new Hashtable();
        }
        return this.templateParamsStack;
    }

    public void append(XSLNode child) {
        this.getLast().setNext(child);
        child.setPrev(this.last);
        this.last = child;
        while (this.last.getNext() != null) {
            this.last = this.last.getNext();
        }
    }

    public void remove() {
        this.prev.setNext(this.next);
        if (this.next != null) {
            this.next.setPrev(this.prev);
        }
        this.prev = null;
        this.next = null;
    }

    public XSLNode getNext() {
        return this.next;
    }

    public XSLNode getPrev() {
        return this.prev;
    }

    public void setPrev(XSLNode value) {
        this.prev = value;
    }

    public XSLNode getParent() {
        return this.parent;
    }

    public XSLStylesheet getOwner() {
        return this.owner;
    }

    public XSLNode getFirst() {
        if (this.head == null) {
            this.first = this.head = new XSLHeadNode();
            this.last = this.head;
        }
        return this.head;
    }

    public XSLNode getLast() {
        if (this.last == null) {
            this.getFirst();
        }
        return this.last;
    }

    public void setFirst(XSLNode n) {
        this.first = n;
    }

    public void setLast(XSLNode n) {
        this.last = n;
    }

    public void setNext(XSLNode n) {
        this.next = n;
    }

    public void setOwner(XSLStylesheet owner) {
        this.owner = owner;
    }

    public int findXSLAttribute(Vector v, XSLAttribute x) {
        int i = 0;
        while (i < v.size()) {
            if (((XSLAttribute)v.get(i)).getName().equals(x.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final XSLVariable getVariable(String name) throws XSLException {
        XSLNode n = this;
        XSLVariable xv = null;
        if (n.parent != null) {
            while (n != null && n.TYPE != 1) {
                n = n.parent;
            }
            if (n == null) {
                return this.owner.getVariable(name);
            }
            if (n.templateParamsStack == null) {
                return n.owner.getVariable(name);
            }
            if (n.templateParamsStack.containsKey(name)) {
                xv = (XSLVariable)((Stack)n.templateParamsStack.get(name)).peek();
            }
            if (xv == null) {
                return n.owner.getVariable(name);
            }
            return xv;
        }
        return n.owner.getVariable(name);
    }

    public XSLVariable popVar(String name) {
        XSLVariable xv = null;
        if (this.templateParamsStack == null) {
            this.templateParamsStack = new Hashtable();
        }
        if (this.templateParamsStack.get(name) != null) {
            xv = (XSLVariable)((Stack)this.templateParamsStack.get(name)).pop();
        }
        return xv;
    }

    public void setVariable(String name, XSLVariable var) {
        XSLNode n = this;
        while (n != null && n.TYPE != 1) {
            n = n.parent;
        }
        if (n == null) {
            this.owner.setVariable(name, var);
        } else {
            n.setVariable(name, var);
        }
    }

    public void setVariableFromTemplate(String name, XSLVariable var) {
        if (this.templateParamsStack == null) {
            this.templateParamsStack = new Hashtable();
        }
        if (this.templateParamsStack.get(name) == null) {
            this.templateParamsStack.put(name, new Stack());
        }
        ((Stack)this.templateParamsStack.get(name)).push(var);
    }

    public VariableContext getVarContext() {
        return this.varContext;
    }

    public abstract String[] getRequiredParams();

    public abstract String[] getOptionalParams();

    public XSLNode changeOwner(XSLStylesheet newOwner) {
        if (this.realBaseURI == null && this.owner != null) {
            this.realBaseURI = this.owner.getBaseURI();
        }
        this.owner = newOwner;
        if (this.getFirst() != null) {
            this.getFirst().changeOwner(newOwner);
        }
        if (this.getNext() != null) {
            this.getNext().changeOwner(newOwner);
        }
        return this;
    }
}

