/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser;

import com.inqmy.lib.jaxp.TransformerImpl;
import com.inqmy.lib.xml.parser.ParserException;
import java.io.IOException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class SAXFilter
implements ErrorListener,
XMLFilter {
    XMLReader parent;
    TransformerImpl transformer;

    public SAXFilter(Templates templates) throws ParserException, TransformerConfigurationException {
        this.transformer = (TransformerImpl)templates.newTransformer();
    }

    public XMLReader getParent() {
        return this.parent;
    }

    public void setParent(XMLReader parent) {
        this.parent = parent;
    }

    public void setContentHandler(ContentHandler contenthandler) {
        this.parent.setContentHandler(contenthandler);
    }

    public ContentHandler getContentHandler() {
        return this.parent.getContentHandler();
    }

    public ErrorHandler getErrorHandler() {
        return this.parent.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parent.setErrorHandler(errorHandler);
    }

    public DTDHandler getDTDHandler() {
        return this.parent.getDTDHandler();
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.parent.setDTDHandler(dtdHandler);
    }

    public EntityResolver getEntityResolver() {
        return this.parent.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parent.setEntityResolver(entityResolver);
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public boolean getFeature(String feature) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parent.getFeature(feature);
    }

    public void setFeature(String feature, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parent.setFeature(feature, value);
    }

    public Object getProperty(String property) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parent.getProperty(property);
    }

    public void setProperty(String propertyName, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parent.setProperty(propertyName, value);
    }

    public void parse(InputSource input) throws IOException, SAXException {
        ContentHandler contentHandler = this.getContentHandler();
        SAXResult result = new SAXResult();
        result.setHandler(contentHandler);
        if (this.parent.getErrorHandler() != null) {
            this.transformer.setErrorListener(this);
        }
        try {
            StreamSource source = new StreamSource();
            if (input.getCharacterStream() != null) {
                source.setReader(input.getCharacterStream());
            } else if (input.getByteStream() != null) {
                source.setInputStream(input.getByteStream());
            } else {
                source.setSystemId(input.getSystemId());
            }
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new SAXException(e);
        }
    }

    public void error(TransformerException tre) throws TransformerException {
        SourceLocator loc = tre.getLocator();
        try {
            this.parent.getErrorHandler().error(new SAXParseException(tre.getMessage(), loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber(), tre));
        }
        catch (SAXException saxe) {
            throw new TransformerException(saxe);
        }
    }

    public void warning(TransformerException tre) throws TransformerException {
        SourceLocator loc = tre.getLocator();
        try {
            this.parent.getErrorHandler().warning(new SAXParseException(tre.getMessage(), loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber(), tre));
        }
        catch (SAXException saxe) {
            throw new TransformerException(saxe);
        }
    }

    public void fatalError(TransformerException tre) throws TransformerException {
        SourceLocator loc = tre.getLocator();
        SAXParseException ex = new SAXParseException(tre.getMessage(), loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber(), tre);
        try {
            this.parent.getErrorHandler().fatalError(ex);
        }
        catch (SAXException saxe) {
            throw new TransformerException(saxe);
        }
        throw tre;
    }
}

