/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.dom;

import com.inqmy.lib.xml.Symbols;
import com.inqmy.lib.xml.dom.Base;
import com.inqmy.lib.xml.dom.DOM;
import com.inqmy.lib.xml.dom.DocumentImpl;
import com.inqmy.lib.xml.dom.DocumentTypeImpl;
import com.inqmy.lib.xml.dom.ElementImpl;
import com.inqmy.lib.xml.dom.QNameResolver;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public final class DOMImplementationImpl
implements DOMImplementation {
    public static boolean hasFeatureStatic(String feature, String version) {
        if (feature == null) {
            return false;
        }
        if (!(version == null || version.trim().equals("") || version.startsWith("1.") || version.equals("2.0"))) {
            return false;
        }
        return feature.equalsIgnoreCase("core") || feature.equalsIgnoreCase("xml");
    }

    public boolean hasFeature(String feature, String version) {
        return DOMImplementationImpl.hasFeatureStatic(feature, version);
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return new DocumentTypeImpl().init(qualifiedName, publicId, systemId, null);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        Document ownerOfTheDoctype;
        ElementImpl root = null;
        if (qualifiedName != null) {
            if (!Symbols.isName(qualifiedName)) {
                throw new DOMException(5, "Unable to create document, the name of the root element is not a valid xml name, '" + qualifiedName + "'");
            }
            root = new ElementImpl().init(namespaceURI, qualifiedName, null);
        }
        if (doctype != null && (ownerOfTheDoctype = doctype.getOwnerDocument()) != null) {
            throw new DOMException(4, "DOCTYPE already in use.");
        }
        DocumentImpl document = new DocumentImpl();
        if (root != null) {
            root.setOwnerDocument(document);
        }
        document.init(root, doctype);
        if (doctype != null) {
            ((Base)((Object)doctype)).setOwnerDocument(document);
        }
        return document;
    }

    public static String toXPath(Node node) {
        return DOM.toXPath(node);
    }

    public static String toXPathWithLocation(Node node) {
        return DOM.toXPathWithLocation(node);
    }

    public static StringBuffer toXPathWithLocation(StringBuffer buffer, Node node) {
        return DOM.toXPathWithLocation(buffer, node);
    }

    public static StringBuffer toXPath(StringBuffer buffer, Node node) {
        return DOM.toXPath(buffer, node);
    }

    public static Node toNode(Node scope, String xpath) {
        return DOM.toNode(xpath, scope);
    }

    public static String prefixToURI(String prefix, Node scope) {
        return QNameResolver.prefixToURI(prefix, scope);
    }

    public static String qnameToPrefix(String qname) {
        return QNameResolver.qnameToPrefix(qname);
    }

    public static String qnameToLocalName(String qname) {
        return QNameResolver.qnameToLocalName(qname);
    }

    public static String qnameToURI(String prefix, Node scope) {
        return QNameResolver.qnameToURI(prefix, scope);
    }
}

