/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.validator;

import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.TypeDefinitionBase;
import com.inqmy.lib.schema.components.impl0.LoaderImpl;
import com.inqmy.lib.schema.gui.validator.SchemaValidatorPanel;
import com.inqmy.lib.schema.validator.PSVIItem;
import com.inqmy.lib.schema.validator.SchemaValidator;
import com.inqmy.lib.xml.dom.DOM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Node;

public final class CommandLine {
    public static boolean lan = false;

    private static void printUsage() {
        System.out.println("InQMy Schema validator, nick_nickolov@yahoo.com");
        System.out.println("  Performs validation and renders the evaluation output as an HTML document.");
        System.out.println("  Launches the default browser, uses temporary files.");
        System.out.println();
        System.out.println("Usage: sch [options] filename.xml [filename.xsd]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("        -astext       Does not produce an HTML summary of the validation outcome");
        System.out.println("                        but prints it as text to the standard output");
        System.out.println("        -quiet        Does not produce any output, only gives the return code");
        System.out.println("        -noopen       Prints the HTML document to the standard output");
        System.out.println("                        instead of to a temporary file");
        System.out.println("        -noassoc      Does not prints the element-to-type associations that have been ");
        System.out.println("                        made during validation");
        System.out.println("        -nocomponents Does not produce and insert a link to the components graph of the ");
        System.out.println("                        schema (in HTML format)");
        System.out.println("        -builtin      Generates also the built-in components, which are normally suppressed");
        System.out.println("        -gui          Launches the swing user interface, this option cannot be");
        System.out.println("                        combined with other options");
        System.out.println();
        System.out.println("Return code:");
        System.out.println("        -1            Batch arguments are not ok");
        System.out.println("         0            Validation successful");
        System.out.println("         1            Validation failed");
    }

    public static void main(String[] args) throws Exception {
        String xml = null;
        String xsd = null;
        boolean astext = false;
        boolean quiet = false;
        boolean noopen = false;
        boolean noassoc = false;
        boolean nocomponents = false;
        boolean builtin = false;
        boolean argsOk = true;
        boolean gui = false;
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            if (s.equals("-astext")) {
                astext = true;
            } else if (s.equals("-noopen")) {
                noopen = true;
            } else if (s.equals("-quiet")) {
                quiet = true;
            } else if (s.equals("-lan")) {
                lan = true;
            } else if (s.equals("-noassoc")) {
                noassoc = true;
            } else if (s.equals("-nocomponents")) {
                nocomponents = true;
            } else if (s.equals("-gui")) {
                gui = true;
            } else if (s.equals("-builtin")) {
                builtin = true;
            } else if (xml == null) {
                xml = s;
            } else if (xsd == null) {
                xsd = s;
            } else {
                argsOk = false;
                break;
            }
            ++i;
        }
        if (gui) {
            SchemaValidatorPanel.main(args);
            return;
        }
        boolean bl = argsOk = argsOk && xml != null;
        if (!argsOk && !quiet) {
            CommandLine.printUsage();
            System.exit(-1);
        }
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.inqmy.lib.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParser", "com.inqmy.lib.jaxp.SAXParserImpl");
        System.setProperty("javax.xml.parsers.TransformerFactory", "com.inqmy.lib.jaxp.TransformerFactoryImpl");
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        bf.setValidating(false);
        bf.setNamespaceAware(true);
        DocumentBuilder builder = bf.newDocumentBuilder();
        SchemaValidator validator = new SchemaValidator();
        boolean result = validator.validate(xml, xsd);
        Schema schema = validator.getSchema();
        if (!quiet) {
            Vector psviItems = new Vector();
            validator.getPSVIItems(psviItems);
            int nContributions = psviItems.size();
            if (!astext) {
                String an;
                PSVIItem item;
                PrintStream out;
                File tempFile = null;
                if (noopen) {
                    out = System.out;
                } else {
                    tempFile = File.createTempFile("inqmy", ".html");
                    tempFile.deleteOnExit();
                    out = new PrintStream(new FileOutputStream(tempFile));
                }
                String xmlURL = new File(xml).toURL().toString();
                String xsdURL = xsd == null ? "" : new File(xsd).toURL().toString();
                out.println("<html>");
                out.println("  <head>");
                out.println("    <title>Validator Output</title>");
                out.println("  </head>");
                out.println("  <body bgColor='black' text='white' alink='#BCC074' link='#BCC074' vlink='#BCC074'>");
                out.println("    <h1 align='center'>InQMy XML Schema validator</h1><br></br>");
                out.println("    <table border='1' bordercolor='#446644' width='100%' align='center' cellspacing='0' cellpadding='10'>");
                out.println("      <tr><th width='50%'>XML instance:</th><th width='50%'>Schema Document:</th></tr>");
                out.println("      <tr><th><a href='" + xmlURL + "'>" + xml + "</a></th>" + "<th><a href='" + xsdURL + "'>" + xsd + "</a></th></tr>");
                out.println("      <tr><th><center><iframe width='100%' height='300' src='" + xmlURL + "'></iframe></center></th>" + "<th><center><iframe width='100%' height='300' src='" + xsdURL + "'></iframe></center></th></tr>");
                out.println("    </table>");
                out.println("    <p align='center'>");
                if (result) {
                    out.println("<font color='green'><h1 align='center'>Validation successful</h1></font>");
                } else {
                    out.println("<font color='red'><h1 align='center'>Validation failed</h1></font>");
                }
                out.println("    </p>");
                if (!nocomponents) {
                    File tempFile2 = File.createTempFile("inqmy", ".html");
                    tempFile2.deleteOnExit();
                    PrintStream out2 = new PrintStream(new FileOutputStream(tempFile2));
                    new LoaderImpl().printAsHTML(schema, out2, builtin);
                    out2.close();
                    out.println("<center><b><a accesskey='c' alt='ALT+C' href='" + tempFile2.getAbsolutePath() + "'>Click here to view the components</a></b></center><br><br>");
                }
                if (!result) {
                    out.println("    <table border='1' bordercolor='#446644' width='100%' align='center' cellspacing='0'>");
                    out.println("      <font color=white>");
                    out.println("      <tr><th colspan='4'>Errors</td></tr>");
                    out.println("      <tr><th width='3%'>Nr</th><th width='25%'>Schema Error Code</th><th width='40%'>Description</th><th width='30%'>XPath Location in the XML</th></tr>");
                    out.println("      </font>");
                    int counter = 0;
                    int i2 = 0;
                    while (i2 < nContributions) {
                        item = (PSVIItem)psviItems.get(i2);
                        an = item.getAugmentationName();
                        if (item.isError()) {
                            Node location;
                            PSVIItem itemNext;
                            String se = (String)item.getValue();
                            String seURL = CommandLine.errorIdToURL(se, lan);
                            String sd = "";
                            if (i2 < nContributions - 1 && (itemNext = (PSVIItem)psviItems.get(i2 + 1)).isErrorDescription()) {
                                sd = (String)itemNext.getValue();
                            }
                            String sl = (location = item.getLocation()) == null ? "unknown" : DOM.toXPath(location);
                            out.println("          <tr><td>" + ++counter + ".</td><td><a href='" + seURL + "'>" + se + "</a></td><td>" + sd + "</td><td>" + sl + "</td></tr>");
                        }
                        ++i2;
                    }
                    out.println("    </table><br></br>");
                }
                if (!noassoc) {
                    out.println("    <table border='1' bordercolor='#446644' width='100%' align='center' cellspacing='0'>");
                    out.println("      <font color=white>");
                    out.println("      <tr><th colspan='3'>Element -> Type  Associations</td></tr>");
                    out.println("      <tr><th width='3%'>Nr</th><th width='51%'>XML Infoset Item</th><th>Schema Type Definition</th></tr>");
                    out.println("      </font>");
                    int counter = 0;
                    int i3 = 0;
                    while (i3 < nContributions) {
                        item = (PSVIItem)psviItems.get(i3);
                        an = item.getAugmentationName();
                        if ("[type definition]".equals(an)) {
                            Node location = item.getLocation();
                            TypeDefinitionBase td = (TypeDefinitionBase)item.getValue();
                            String std = td.toString();
                            String sl = location == null ? "unknown" : DOM.toXPath(location);
                            out.println("          <tr><td>" + ++counter + ".</td>" + "<td>" + sl + "</td>" + "<td>" + std + "</td></tr>");
                        }
                        ++i3;
                    }
                    out.println("    </table><br></br>");
                }
                out.println("   <br></br><p align='right'><i><a href='mailto:nick_nickolov@yahoo.com'>Nick Nickolov</a>, InQMy</i><p>");
                out.println("  </body>");
                out.println("</html>");
                if (!noopen) {
                    out.close();
                    Runtime.getRuntime().exec("explorer " + tempFile.getAbsolutePath());
                }
            } else {
                System.out.println();
                System.out.println(result ? "Validation successful" : "Validation failed");
                if (!result) {
                    System.out.println("Errors:");
                    int i4 = 0;
                    while (i4 < nContributions) {
                        PSVIItem item = (PSVIItem)psviItems.get(i4);
                        String an = item.getAugmentationName();
                        if (item.isError()) {
                            String se = (String)item.getValue();
                            String seURL = CommandLine.errorIdToURL(se, lan);
                            String sd = "";
                            Node location = item.getLocation();
                            String sl = location == null ? "unknown" : DOM.toXPath(location);
                            System.out.println(i4 + 1 + ". " + se + " (" + sd + "), " + sl);
                        }
                        ++i4;
                    }
                }
            }
        }
        if (!astext) {
            System.out.print("Press 'ENTER' (temporary files will be cleared) ...");
            System.in.read();
        }
        System.exit(result ? 0 : 1);
    }

    private static final String errorIdToURL(String errorId, boolean lan) {
        int p = errorId.indexOf(46);
        if (p != -1) {
            errorId = errorId.substring(0, p);
        }
        return (lan ? "\\\\niki\\XML\\Schema\\spec\\1.htm#" : "http://www.w3.org/TR/2001/PR-xmlschema-1-20010330#") + errorId;
    }

    public static String getSpecBase() {
        return lan ? "\\\\niki\\XML\\Schema\\spec\\1.htm#" : "http://www.w3.org/TR/2001/PR-xmlschema-1-20010330#";
    }

    public static String getSpecBaseForJavaScript() {
        return lan ? "\\\\\\\\niki\\\\XML\\\\Schema\\\\spec\\\\1.htm#" : "http://www.w3.org/TR/2001/PR-xmlschema-1-20010330#";
    }
}

