/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.SchemaComponentException;
import com.inqmy.lib.schema.components.Wildcard;
import com.inqmy.lib.schema.components.impl0.BaseImpl;
import com.inqmy.lib.schema.components.impl0.LoaderImpl;
import java.util.Vector;

public final class WildcardImpl
extends BaseImpl
implements Wildcard {
    public static final int SKIP = 1;
    public static final int LAX = 2;
    public static final int STRICT = 3;
    protected int processContents;
    protected boolean nscAny;
    protected String negated;
    protected String[] members;

    protected WildcardImpl() {
    }

    public int getTypeOfComponent() {
        return 10;
    }

    public boolean isProcessContentsSkip() {
        return this.processContents == 1;
    }

    public boolean isProcessContentsLax() {
        return this.processContents == 2;
    }

    public boolean isProcessContentsStrict() {
        return this.processContents == 3;
    }

    public boolean isNamespaceConstraintAny() {
        return this.nscAny;
    }

    public String getNamespaceConstraintNegated() {
        return this.negated;
    }

    public boolean namespaceConstraintMembersContain(String uri) {
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i].equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setPC(String s) {
        this.processContents = s == null || s.equals("strict") ? 3 : (s.equals("lax") ? 2 : 1);
    }

    public String[] getNamespaceConstraintMembersAsArray() {
        if (this.members == null) {
            return null;
        }
        String[] r = new String[this.members.length];
        System.arraycopy(this.members, 0, r, 0, this.members.length);
        return r;
    }

    public void getNamespaceConstraintMembers(Vector v) {
        if (this.members != null) {
            int nMembers = this.members.length;
            int i = 0;
            while (i < nMembers) {
                v.add(this.members[i]);
                ++i;
            }
        }
    }

    public static Wildcard unite(Wildcard a, Wildcard b) throws SchemaComponentException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isNamespaceConstraintAny() || b.isNamespaceConstraintAny()) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        String[] aMembers = a.getNamespaceConstraintMembersAsArray();
        String[] bMembers = b.getNamespaceConstraintMembersAsArray();
        if (aMembers != null && bMembers != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.members = WildcardImpl.uniteArrays(aMembers, bMembers);
            return c;
        }
        String aNegated = a.getNamespaceConstraintNegated();
        String bNegated = b.getNamespaceConstraintNegated();
        if (aNegated != null && bNegated != null) {
            if (aNegated.equals(bNegated)) {
                return a;
            }
            throw new SchemaComponentException("Wildcard union not expressible");
        }
        if (aMembers != null && bNegated != null) {
            if (WildcardImpl.contains(aMembers, aMembers.length, bNegated)) {
                return a;
            }
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        if (bMembers != null && aNegated != null) {
            if (WildcardImpl.contains(bMembers, bMembers.length, aNegated)) {
                return b;
            }
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.nscAny = true;
            c.setProcessContentsLike(a);
            return c;
        }
        WildcardImpl c = new WildcardImpl();
        c.setOwnerSchema(a.getOwnerSchema());
        c.nscAny = true;
        c.setProcessContentsLike(a);
        return c;
    }

    public static Wildcard intersect(Wildcard a, Wildcard b) throws SchemaComponentException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.isNamespaceConstraintAny()) {
            return b;
        }
        if (b.isNamespaceConstraintAny()) {
            return a;
        }
        String[] aMembers = a.getNamespaceConstraintMembersAsArray();
        String[] bMembers = b.getNamespaceConstraintMembersAsArray();
        String aNegated = a.getNamespaceConstraintNegated();
        String bNegated = b.getNamespaceConstraintNegated();
        if (aMembers != null && bNegated != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.removeFromArray(aMembers, bNegated);
            return c;
        }
        if (bMembers != null && aNegated != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.removeFromArray(bMembers, aNegated);
            return c;
        }
        if (aMembers != null && bMembers != null) {
            WildcardImpl c = new WildcardImpl();
            c.setOwnerSchema(a.getOwnerSchema());
            c.setProcessContentsLike(a);
            c.members = WildcardImpl.uniteArrays(aMembers, bMembers);
            return c;
        }
        if (aNegated != null && bNegated != null) {
            if (aNegated.equals(bNegated)) {
                return a;
            }
            throw new SchemaComponentException("Wildcard intersection not expressible");
        }
        WildcardImpl c = new WildcardImpl();
        c.setOwnerSchema(a.getOwnerSchema());
        c.nscAny = true;
        c.setProcessContentsLike(a);
        return c;
    }

    private static String[] uniteArrays(String[] a, String[] b) throws SchemaComponentException {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        int nc = a.length;
        int i = 0;
        while (i < b.length) {
            if (!WildcardImpl.contains(c, nc, b[i])) {
                c[nc] = b[i];
                ++nc;
            }
            ++i;
        }
        if (nc == c.length) {
            return c;
        }
        String[] d = new String[nc];
        System.arraycopy(c, 0, d, 0, nc);
        return d;
    }

    private static String[] intersectArrays(String[] a, String[] b) throws SchemaComponentException {
        String[] c = new String[a.length];
        int nc = 0;
        int i = 0;
        while (i < a.length) {
            if (WildcardImpl.contains(b, b.length, a[i])) {
                c[nc] = a[i];
                ++nc;
            }
            ++i;
        }
        if (nc == c.length) {
            return c;
        }
        String[] d = new String[nc];
        System.arraycopy(c, 0, d, 0, nc);
        return d;
    }

    private static boolean contains(String[] a, int n, String x) throws SchemaComponentException {
        int i = 0;
        while (i < n) {
            if (a[i].equals(x)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] removeFromArray(String[] a, String x) throws SchemaComponentException {
        int i = 0;
        while (i < a.length) {
            if (a[i].equals(x)) {
                String[] r = new String[a.length - 1];
                System.arraycopy(a, 0, r, 0, i);
                System.arraycopy(a, i + 1, r, i, a.length - i - 1);
                return r;
            }
            ++i;
        }
        return a;
    }

    private void setProcessContentsLike(Wildcard w) {
        this.processContents = w.isProcessContentsLax() ? 2 : (w.isProcessContentsSkip() ? 1 : (w.isProcessContentsStrict() ? 3 : 0));
    }

    protected void accept(Base x, int toWhat, String prop, LoaderImpl loader) throws SchemaComponentException {
        throw new SchemaComponentException();
    }
}

