/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.ReqMonitor;
import com.sap.util.monitor.jarm.TopList;
import com.sap.util.monitor.jarm.TopStruct;
import com.sap.util.monitor.jarm.UserOverview;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

class UserMonitor {
    private static TreeMap userByName;
    private String userName;
    private long userAccNr;
    private long userAccTime;
    private long userFirstTS;
    private long userLastTS;

    protected UserMonitor() {
    }

    protected UserMonitor(String parUserName, ReqMonitor reqMon) {
        this();
        this.userName = parUserName;
        this.updateInstance(true, reqMon);
    }

    /*
     * Unable to fully structure code
     */
    protected static synchronized UserOverview[] getTopUsers(int criterion, String namePattern, int maxResults) {
        block23: {
            hlpColl = null;
            hlpIter = null;
            userMon = null;
            userOverview = new UserOverview();
            topStruct = null;
            retTopStruct = null;
            topUserGrossTime = null;
            topUserAccGrossTime = null;
            topUserCallNum = null;
            objs = null;
            if (UserMonitor.userByName == null || maxResults < 1) {
                return null;
            }
            noRestrict = namePattern == null || namePattern.compareTo("*") == 0;
            v0 = wildcard = namePattern != null && namePattern.endsWith("*") != false;
            if (noRestrict || wildcard) {
                hlpColl = UserMonitor.getUserCollection(namePattern, noRestrict, wildcard);
                if (hlpColl != null) {
                    hlpIter = hlpColl.iterator();
                }
            } else {
                userMon = (UserMonitor)UserMonitor.userByName.get(namePattern);
                if (userMon != null && userMon.userAccNr > 0L) {
                    retUser = new UserOverview[1];
                    userMon.getUserOverview(userOverview);
                    retUser[0] = userOverview;
                    return retUser;
                }
            }
            if (!noRestrict && !wildcard || hlpIter == null) break block23;
            topStruct = new TopStruct();
            nrOfResults = hlpColl.size();
            if (nrOfResults > maxResults) {
                nrOfResults = maxResults;
            }
            if (nrOfResults > ConfMonitor.initMaxUserRet) {
                nrOfResults = ConfMonitor.initMaxUserRet;
            }
            switch (criterion) {
                case 0: {
                    topUserGrossTime = new TopList(nrOfResults, 0L);
                    ** GOTO lbl65
                }
                case 3: {
                    topUserCallNum = new TopList(nrOfResults, 1L);
                    ** GOTO lbl65
                }
                case 4: {
                    topUserAccGrossTime = new TopList(nrOfResults, 0L);
                    if (true) ** GOTO lbl65
                }
                default: {
                    return null;
                }
            }
            do {
                userMon = (UserMonitor)hlpIter.next();
                if (userMon.userAccNr == 0L) continue;
                userMon.getUserOverview(userOverview);
                topStruct.obj = userOverview;
                topStruct.objName = userOverview.userName;
                switch (criterion) {
                    case 0: {
                        topStruct.value = userOverview.userAvgTime;
                        retTopStruct = topUserGrossTime.insertElem(topStruct);
                        break;
                    }
                    case 3: {
                        topStruct.value = userOverview.userAccNr;
                        retTopStruct = topUserCallNum.insertElem(topStruct);
                        break;
                    }
                    case 4: {
                        topStruct.value = userOverview.userAccTime;
                        retTopStruct = topUserAccGrossTime.insertElem(topStruct);
                    }
                }
                if (retTopStruct == null) continue;
                userOverview = retTopStruct.obj == null ? new UserOverview() : (UserOverview)retTopStruct.obj;
lbl65:
                // 6 sources

            } while (hlpIter.hasNext());
            switch (criterion) {
                case 0: {
                    objs = topUserGrossTime.searchElems(null, nrOfResults);
                    break;
                }
                case 3: {
                    objs = topUserCallNum.searchElems(null, nrOfResults);
                    break;
                }
                case 4: {
                    objs = topUserAccGrossTime.searchElems(null, nrOfResults);
                }
            }
            return UserMonitor.buildUserOverview(objs);
        }
        return null;
    }

    protected static synchronized void updUser(String userName, ReqMonitor reqMon) {
        UserMonitor userAcc;
        if (userByName == null) {
            userByName = new TreeMap();
        }
        if ((userAcc = (UserMonitor)userByName.get(userName)) != null) {
            userAcc.updateInstance(false, reqMon);
        } else {
            userAcc = new UserMonitor(userName, reqMon);
            userByName.put(userName, userAcc);
        }
    }

    private static Collection getUserCollection(String namePattern, boolean noRestrict, boolean wildcard) {
        SortedMap hlpMap = null;
        Collection hlpColl = null;
        String namePrefix = null;
        String nameUpperValue = null;
        if (userByName == null) {
            return null;
        }
        if (noRestrict) {
            hlpColl = userByName.values();
        } else if (wildcard && (hlpMap = (nameUpperValue = UserMonitor.upperValue(namePrefix = namePattern.substring(0, namePattern.length() - 1))) != null ? userByName.subMap(namePrefix, nameUpperValue) : userByName.tailMap(namePrefix)) != null) {
            hlpColl = hlpMap.values();
        }
        return hlpColl;
    }

    protected static synchronized void resetUserData() {
        Collection hlpColl = null;
        Iterator hlpIter = null;
        hlpColl = UserMonitor.getUserCollection(null, true, false);
        if (hlpColl == null) {
            return;
        }
        hlpIter = hlpColl.iterator();
        if (hlpIter != null) {
            while (hlpIter.hasNext()) {
                UserMonitor userMon = (UserMonitor)hlpIter.next();
                userMon.resetInstance();
            }
        }
    }

    private static UserOverview[] buildUserOverview(Object[] userArr) {
        if (userArr == null || userArr.length == 0) {
            return null;
        }
        int nrOfRequests = userArr.length;
        UserOverview[] resultUsers = new UserOverview[nrOfRequests];
        int i = 0;
        while (i < nrOfRequests) {
            resultUsers[i] = (UserOverview)userArr[i];
            ++i;
        }
        return resultUsers;
    }

    private static String upperValue(String lowerValue) {
        int len = lowerValue.length();
        char[] chrArray = new char[len];
        lowerValue.getChars(0, len, chrArray, 0);
        int ind = len - 1;
        do {
            if (chrArray[ind] < '\uffff') {
                int n = ind;
                chrArray[n] = (char)(chrArray[n] + '\u0001');
                break;
            }
            chrArray[ind] = '\u0000';
        } while (--ind >= 0);
        if (ind >= 0) {
            String hlpStr = "";
            int j = 0;
            while (j <= ind) {
                hlpStr = hlpStr + chrArray[j];
                ++j;
            }
            return hlpStr;
        }
        return null;
    }

    private void getUserOverview(UserOverview userOverview) {
        userOverview.userName = this.userName;
        userOverview.userAccNr = this.userAccNr;
        userOverview.userFirstTS = this.userFirstTS;
        userOverview.userLastTS = this.userLastTS;
        userOverview.userAccTime = this.userAccTime;
        userOverview.userAvgTime = userOverview.userAccNr > 0L ? userOverview.userAccTime / userOverview.userAccNr : 0L;
    }

    protected void updateInstance(boolean newUser, ReqMonitor reqMon) {
        ++this.userAccNr;
        this.userAccTime += reqMon.reqTime;
        if (this.userFirstTS == 0L) {
            ++ReqMonitor.reqAccUserNr;
        }
        if (newUser) {
            ++ReqMonitor.reqStartAccUserNr;
        }
        if (this.userFirstTS == 0L || this.userFirstTS > reqMon.reqTS) {
            this.userFirstTS = reqMon.reqTS;
        }
        if (this.userLastTS < reqMon.reqTS) {
            this.userLastTS = reqMon.reqTS;
        }
    }

    private void resetInstance() {
        this.userLastTS = 0L;
        this.userFirstTS = 0L;
        this.userAccTime = 0L;
        this.userAccNr = 0L;
        ReqMonitor.reqAccUserNr = 0L;
    }
}

