/*
 * Decompiled with CFR 0.152.
 */
package com.sap.util.monitor.jarm;

import com.sap.util.monitor.jarm.CompSingleMonitor;
import com.sap.util.monitor.jarm.ComponentOverview;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.ICompProperties;
import com.sap.util.monitor.jarm.TopList;
import com.sap.util.monitor.jarm.TopStruct;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

class CompMonitor {
    private static TreeMap compByName;
    private String compName;
    private boolean foreignComp;
    protected String compDescr;
    protected ICompProperties propImpl;
    private long compAccNr;
    private long compAccGrossTime;
    private long compAccNetTime;
    private long compAccGrossTimeFilled;
    private long compAccNetTimeFilled;
    private long compAccInDataFilled;
    private long compAccOutDataFilled;
    private long compAccInData;
    private long compAccOutData;
    private long compAccPropsNr;
    private Object compAccProps;

    protected CompMonitor() {
    }

    protected CompMonitor(CompSingleMonitor compSingle, boolean compPropSwitchOn) {
        this();
        this.compName = compSingle.compName;
        this.updateInstance(compSingle, compPropSwitchOn);
    }

    protected CompMonitor(String compName, int criterion, Object attr) {
        this();
        this.compName = compName;
        this.setInstanceAttr(criterion, attr);
    }

    /*
     * Unable to fully structure code
     */
    protected static synchronized ComponentOverview[] getTopComponents(int criterion, String namePattern, int maxResults) {
        block26: {
            hlpColl = null;
            hlpIter = null;
            compMon = null;
            compOverview = new ComponentOverview();
            topStruct = null;
            retTopStruct = null;
            topCompGrossTime = null;
            topCompNetTime = null;
            topCompOutData = null;
            topCompCallNum = null;
            objs = null;
            if (CompMonitor.compByName == null || maxResults < 1) {
                return null;
            }
            compPropSwitchOn = ConfMonitor.initCompPropGetSwitch == 1;
            noRestrict = namePattern == null || namePattern.compareTo("*") == 0;
            v0 = wildcard = namePattern != null && namePattern.endsWith("*") != false;
            if (noRestrict || wildcard) {
                hlpColl = CompMonitor.getCompCollection(namePattern, noRestrict, wildcard);
                if (hlpColl != null) {
                    hlpIter = hlpColl.iterator();
                }
            } else {
                compMon = (CompMonitor)CompMonitor.compByName.get(namePattern);
                if (compMon != null && compMon.compAccNr > 0L) {
                    retComp = new ComponentOverview[1];
                    compMon.getCompOverview(compOverview, compPropSwitchOn);
                    retComp[0] = compOverview;
                    return retComp;
                }
            }
            if (!noRestrict && !wildcard || hlpIter == null) break block26;
            topStruct = new TopStruct();
            nrOfResults = hlpColl.size();
            if (nrOfResults > maxResults) {
                nrOfResults = maxResults;
            }
            if (nrOfResults > ConfMonitor.initMaxCompRet) {
                nrOfResults = ConfMonitor.initMaxCompRet;
            }
            switch (criterion) {
                case 0: {
                    topCompGrossTime = new TopList(nrOfResults, 0L);
                    ** GOTO lbl74
                }
                case 1: {
                    topCompNetTime = new TopList(nrOfResults, 0L);
                    ** GOTO lbl74
                }
                case 2: {
                    topCompOutData = new TopList(nrOfResults, 0L);
                    ** GOTO lbl74
                }
                case 3: {
                    topCompCallNum = new TopList(nrOfResults, 1L);
                    if (true) ** GOTO lbl74
                }
                default: {
                    return null;
                }
            }
            do {
                compMon = (CompMonitor)hlpIter.next();
                if (compMon.compAccNr == 0L) continue;
                compMon.getCompOverview(compOverview, compPropSwitchOn);
                topStruct.obj = compOverview;
                topStruct.objName = compOverview.compName;
                switch (criterion) {
                    case 0: {
                        topStruct.value = compOverview.compAvgGrossTime;
                        retTopStruct = topCompGrossTime.insertElem(topStruct);
                        break;
                    }
                    case 1: {
                        topStruct.value = compOverview.compAvgNetTime;
                        retTopStruct = topCompNetTime.insertElem(topStruct);
                        break;
                    }
                    case 2: {
                        topStruct.value = compOverview.compAvgOutData;
                        retTopStruct = topCompOutData.insertElem(topStruct);
                        break;
                    }
                    case 3: {
                        topStruct.value = compOverview.compAccNr;
                        retTopStruct = topCompCallNum.insertElem(topStruct);
                    }
                }
                if (retTopStruct == null) continue;
                compOverview = retTopStruct.obj == null ? new ComponentOverview() : (ComponentOverview)retTopStruct.obj;
lbl74:
                // 7 sources

            } while (hlpIter.hasNext());
            switch (criterion) {
                case 0: {
                    objs = topCompGrossTime.searchElems(null, nrOfResults);
                    break;
                }
                case 1: {
                    objs = topCompNetTime.searchElems(null, nrOfResults);
                    break;
                }
                case 2: {
                    objs = topCompOutData.searchElems(null, nrOfResults);
                    break;
                }
                case 3: {
                    objs = topCompCallNum.searchElems(null, nrOfResults);
                }
            }
            return CompMonitor.buildComponentOverview(objs);
        }
        return null;
    }

    protected static synchronized ComponentOverview[] getComponents(String namePattern, int maxResults) {
        boolean wildcard;
        Collection hlpColl = null;
        Iterator hlpIter = null;
        CompMonitor compMon = null;
        int nrOfFoundResults = 0;
        ComponentOverview[] retCompWith0 = null;
        ComponentOverview[] retComp = null;
        if (compByName == null || maxResults < 1) {
            return null;
        }
        boolean compPropSwitchOn = ConfMonitor.initCompPropGetSwitch == 1;
        boolean noRestrict = namePattern == null || namePattern.compareTo("*") == 0;
        boolean bl = wildcard = namePattern != null && namePattern.endsWith("*");
        if (noRestrict || wildcard) {
            hlpColl = CompMonitor.getCompCollection(namePattern, noRestrict, wildcard);
            if (hlpColl != null) {
                hlpIter = hlpColl.iterator();
            }
            if (hlpIter != null) {
                int nrOfResultsWith0 = hlpColl.size();
                int nrOfResults = nrOfResultsWith0;
                if (nrOfResults > maxResults) {
                    nrOfResults = maxResults;
                }
                if (nrOfResults > ConfMonitor.initMaxCompRet) {
                    nrOfResults = ConfMonitor.initMaxCompRet;
                }
                if (nrOfResultsWith0 <= 0) {
                    return null;
                }
                retCompWith0 = new ComponentOverview[nrOfResultsWith0];
                int i = 0;
                while (i < nrOfResultsWith0) {
                    if (!hlpIter.hasNext()) break;
                    compMon = (CompMonitor)hlpIter.next();
                    if (compMon.compAccNr != 0L) {
                        ComponentOverview compOverview = new ComponentOverview();
                        compMon.getCompOverview(compOverview, compPropSwitchOn);
                        retCompWith0[nrOfFoundResults++] = compOverview;
                        if (nrOfFoundResults == nrOfResults) break;
                    }
                    ++i;
                }
                if (nrOfFoundResults == nrOfResultsWith0) {
                    retComp = retCompWith0;
                } else if (nrOfFoundResults > 0) {
                    retComp = new ComponentOverview[nrOfFoundResults];
                    int i2 = 0;
                    while (i2 < nrOfFoundResults) {
                        retComp[i2] = retCompWith0[i2];
                        ++i2;
                    }
                }
            }
        } else {
            compMon = (CompMonitor)compByName.get(namePattern);
            if (compMon != null && compMon.compAccNr > 0L) {
                ComponentOverview compOverview = new ComponentOverview();
                retComp = new ComponentOverview[1];
                compMon.getCompOverview(compOverview, compPropSwitchOn);
                retComp[0] = compOverview;
            }
        }
        return retComp;
    }

    protected static synchronized CompMonitor getCompObj(String compName) {
        if (compByName != null) {
            return (CompMonitor)compByName.get(compName);
        }
        return null;
    }

    protected static synchronized void updComponent(CompSingleMonitor compSingle, boolean compPropSwitchOn) {
        CompMonitor compAcc;
        if (compByName == null) {
            compByName = new TreeMap();
        }
        if ((compAcc = (CompMonitor)compByName.get(compSingle.compName)) != null) {
            compAcc.updateInstance(compSingle, compPropSwitchOn);
        } else {
            compAcc = new CompMonitor(compSingle, compPropSwitchOn);
            compByName.put(compSingle.compName, compAcc);
        }
    }

    protected static synchronized void setCompAttr(String compName, int criterion, Object attr) {
        CompMonitor compAcc;
        if (criterion != 1 && criterion != 0) {
            return;
        }
        if (compByName == null) {
            compByName = new TreeMap();
        }
        if ((compAcc = (CompMonitor)compByName.get(compName)) != null) {
            compAcc.setInstanceAttr(criterion, attr);
        } else {
            compAcc = new CompMonitor(compName, criterion, attr);
            compByName.put(compName, compAcc);
        }
    }

    protected static synchronized void resetCompData() {
        Collection hlpColl = null;
        Iterator hlpIter = null;
        hlpColl = CompMonitor.getCompCollection(null, true, false);
        if (hlpColl == null) {
            return;
        }
        hlpIter = hlpColl.iterator();
        if (hlpIter != null) {
            while (hlpIter.hasNext()) {
                CompMonitor compMon = (CompMonitor)hlpIter.next();
                compMon.resetInstance();
            }
        }
    }

    private static Collection getCompCollection(String namePattern, boolean noRestrict, boolean wildcard) {
        SortedMap hlpMap = null;
        Collection hlpColl = null;
        String namePrefix = null;
        String nameUpperValue = null;
        if (compByName == null) {
            return null;
        }
        if (noRestrict) {
            hlpColl = compByName.values();
        } else if (wildcard && (hlpMap = (nameUpperValue = CompMonitor.upperValue(namePrefix = namePattern.substring(0, namePattern.length() - 1))) != null ? compByName.subMap(namePrefix, nameUpperValue) : compByName.tailMap(namePrefix)) != null) {
            hlpColl = hlpMap.values();
        }
        return hlpColl;
    }

    private static ComponentOverview[] buildComponentOverview(Object[] compArr) {
        if (compArr == null || compArr.length == 0) {
            return null;
        }
        int nrOfRequests = compArr.length;
        ComponentOverview[] resultComps = new ComponentOverview[nrOfRequests];
        int i = 0;
        while (i < nrOfRequests) {
            resultComps[i] = (ComponentOverview)compArr[i];
            ++i;
        }
        return resultComps;
    }

    private static String upperValue(String lowerValue) {
        int len = lowerValue.length();
        char[] chrArray = new char[len];
        lowerValue.getChars(0, len, chrArray, 0);
        int ind = len - 1;
        do {
            if (chrArray[ind] < '\uffff') {
                int n = ind;
                chrArray[n] = (char)(chrArray[n] + '\u0001');
                break;
            }
            chrArray[ind] = '\u0000';
        } while (--ind >= 0);
        if (ind >= 0) {
            String hlpStr = "";
            int j = 0;
            while (j <= ind) {
                hlpStr = hlpStr + chrArray[j];
                ++j;
            }
            return hlpStr;
        }
        return null;
    }

    private void updateInstance(CompSingleMonitor compSingle, boolean compPropSwitchOn) {
        ++this.compAccNr;
        if (compSingle.grossTime != -1L) {
            ++this.compAccGrossTimeFilled;
            this.compAccGrossTime += compSingle.grossTime;
            if (compSingle.childComplete) {
                ++this.compAccNetTimeFilled;
                this.compAccNetTime = compSingle.subTime != -1L ? (this.compAccNetTime += compSingle.grossTime - compSingle.subTime) : (this.compAccNetTime += compSingle.grossTime);
            }
        }
        if (compSingle.compOutData >= 0) {
            ++this.compAccOutDataFilled;
            if ((this.compAccOutData += (long)compSingle.compOutData) < 0L) {
                this.compAccOutData = Long.MAX_VALUE;
            }
        }
        if (compSingle.foreignComp) {
            this.foreignComp = true;
        }
        if (this.propImpl != null && compSingle.compPropSingle != null && compPropSwitchOn) {
            ++this.compAccPropsNr;
            compSingle.compMon = this;
            this.compAccProps = this.propImpl.condenseData(compSingle.compPropSingle, this.compAccProps);
        }
    }

    private void resetInstance() {
        this.foreignComp = false;
        this.compAccPropsNr = 0L;
        this.compAccOutData = 0L;
        this.compAccInData = 0L;
        this.compAccOutDataFilled = 0L;
        this.compAccInDataFilled = 0L;
        this.compAccNetTimeFilled = 0L;
        this.compAccGrossTimeFilled = 0L;
        this.compAccNetTime = 0L;
        this.compAccGrossTime = 0L;
        this.compAccNr = 0L;
        this.compAccProps = null;
    }

    private void setInstanceAttr(int criterion, Object attr) {
        if (criterion == 1) {
            if (this.propImpl == null) {
                this.propImpl = (ICompProperties)attr;
            }
        } else if (criterion == 0 && this.compDescr == null) {
            this.compDescr = (String)attr;
        }
    }

    private void getCompOverview(ComponentOverview compOverview, boolean compPropSwitchOn) {
        compOverview.compName = this.compName;
        compOverview.compAccNr = this.compAccNr;
        compOverview.compAccGrossTimeFilled = this.compAccGrossTimeFilled;
        compOverview.compAccNetTimeFilled = this.compAccNetTimeFilled;
        compOverview.compAccGrossTime = this.compAccGrossTime;
        compOverview.compAccNetTime = this.compAccNetTime;
        compOverview.compDescr = this.compDescr;
        compOverview.compAvgGrossTime = compOverview.compAccGrossTimeFilled > 0L ? compOverview.compAccGrossTime / compOverview.compAccGrossTimeFilled : 0L;
        compOverview.compAvgNetTime = compOverview.compAccNetTimeFilled > 0L ? compOverview.compAccNetTime / compOverview.compAccNetTimeFilled : 0L;
        compOverview.compAccOutDataFilled = this.compAccOutDataFilled;
        compOverview.compAccOutData = this.compAccOutData;
        compOverview.compAvgOutData = compOverview.compAccOutDataFilled > 0L ? compOverview.compAccOutData / compOverview.compAccOutDataFilled : 0L;
        if (compPropSwitchOn) {
            compOverview.compAccPropsNr = this.compAccPropsNr;
            compOverview.compAccProps = this.propImpl == null || this.compAccProps == null ? null : this.propImpl.getDataCondensed(this.compAccProps);
        } else {
            compOverview.compAccPropsNr = 0L;
            compOverview.compAccProps = null;
        }
    }
}

