/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security;

import com.sap.engine.lib.lang.Convert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64 {
    private static final int CHARS_PER_LINE = 64;
    private static final byte MASK = 63;
    private static final int MASK_ONES = 255;
    private static final byte PADDING = 61;
    private static byte[] codes = Base64.charArrToByteArr(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'});

    public static byte[] decode(byte[] input) throws Exception {
        return Base64.decodeEncodedFile(Base64.readEncodedFile(input));
    }

    public static byte[] decode(InputStream stream) throws Exception {
        return Base64.decodeEncodedFile(Base64.readEncodedFile(stream));
    }

    private static byte[] decodeEncodedFile(byte[] input) throws Exception {
        int i = 0;
        int padding = 0;
        int len = input.length;
        int atomLen = len / 4;
        if (input.length % 4 != 0) {
            throw new Exception("Input array size must be multiple by 4.");
        }
        if (input[len - 1] == 61) {
            ++padding;
        }
        if (input[len - 2] == 61) {
            ++padding;
        }
        if (input[len - 3] == 61) {
            throw new Exception("Invalid input data.");
        }
        byte[] result = padding != 0 ? new byte[(atomLen - 1) * 3 + (padding == 2 ? 1 : 2)] : new byte[atomLen * 3];
        i = 0;
        while (i < atomLen - 1) {
            System.arraycopy(Base64.decodeAtom(input, i * 4), 0, result, i * 3, 3);
            ++i;
        }
        if (padding != 0) {
            int tmp = 0;
            tmp |= Base64.getIndex(input[len - 4]);
            if (padding == 2) {
                tmp <<= 2;
                tmp |= Base64.getIndex(input[len - 3]) >>> 4;
            } else {
                tmp <<= 6;
                tmp |= Base64.getIndex(input[len - 3]);
                tmp <<= 4;
                result[result.length - 2] = (byte)((tmp |= Base64.getIndex(input[len - 2]) >>> 2) >> 8 & 0xFF);
            }
            result[result.length - 1] = (byte)(tmp & 0xFF);
        } else {
            System.arraycopy(Base64.decodeAtom(input, (atomLen - 1) * 4), 0, result, (atomLen - 1) * 3, 3);
        }
        return result;
    }

    public static byte[] encode(byte[] input) throws Exception {
        int atomLen = input.length / 3;
        byte[] result = input.length % 3 == 0 ? new byte[atomLen * 4] : new byte[atomLen * 4 + 4];
        int i = 0;
        while (i < atomLen) {
            System.arraycopy(Base64.encodeAtom(input, i * 3), 0, result, i * 4, 4);
            ++i;
        }
        int off = i * 3;
        int left = input.length - off;
        if (left != 0) {
            if (left == 1) {
                result[i * 4] = codes[input[off] >>> 2 & 0x3F];
                result[i * 4 + 1] = codes[input[off] << 4 & 0x30];
                result[i * 4 + 2] = 61;
            } else {
                result[i * 4] = codes[input[off] >>> 2 & 0x3F];
                result[i * 4 + 1] = codes[(input[off] << 4 & 0x30) + (input[off + 1] >>> 4 & 0xF)];
                result[i * 4 + 2] = codes[(input[off + 1] & 0xF) << 2];
            }
            result[i * 4 + 3] = 61;
        }
        int blocks = result.length / 64;
        left = result.length % 64;
        byte[] ret = new byte[result.length + (left == 0 ? blocks - 1 : blocks)];
        i = 0;
        off = 0;
        while (i < blocks) {
            System.arraycopy(result, i * 64, ret, off, 64);
            off += 64;
            if (i != blocks - 1 || left != 0) {
                ret[off++] = 10;
            }
            ++i;
        }
        System.arraycopy(result, i * 64, ret, off, result.length % 64);
        return ret;
    }

    private static byte[] encodeAtom(byte[] input, int offset) throws Exception {
        if (offset < 0 || input.length <= offset) {
            throw new Exception(" Invalid offset: " + offset);
        }
        byte[] result = new byte[4];
        int temp = input[offset] & 0xFF;
        temp <<= 8;
        temp |= input[offset + 1] & 0xFF;
        temp <<= 8;
        result[0] = codes[(temp |= input[offset + 2] & 0xFF) >> 18 & 0x3F];
        result[1] = codes[temp >> 12 & 0x3F];
        result[2] = codes[temp >> 6 & 0x3F];
        result[3] = codes[temp & 0x3F];
        return result;
    }

    private static byte[] decodeAtom(byte[] input, int offset) throws Exception {
        if (offset < 0 || input.length <= offset) {
            throw new Exception("decodeAtom exception: invalid offset " + offset);
        }
        int tmp = 0;
        byte[] result = new byte[3];
        int i = 0;
        while (i < 4) {
            tmp <<= 6;
            tmp |= 0xFF & Base64.getIndex(input[i + offset]);
            ++i;
        }
        result[0] = (byte)(tmp >> 16 & 0xFF);
        result[1] = (byte)(tmp >> 8 & 0xFF);
        result[2] = (byte)(tmp & 0xFF);
        return result;
    }

    private static int getIndex(byte b) throws Exception {
        char c = Convert.asciiToChar(b);
        if (c >= 'A' && c <= 'Z') {
            return c - 65 & 0xFF;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26 & 0xFF;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52 & 0xFF;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new Exception(" Unknown symbol '" + b + "'.");
    }

    public static boolean isBase64(InputStream input, String start) throws Exception {
        byte[] temp;
        if (!input.markSupported()) {
            temp = new byte[input.available()];
            input.read(temp);
            input = new ByteArrayInputStream(temp);
        }
        if (input.available() <= 10) {
            throw new Exception("Unknown encoding.");
        }
        temp = new byte[10];
        input.mark(10);
        input.read(temp);
        input.reset();
        return start.startsWith(new String(temp));
    }

    private static byte[] readEncodedFile(byte[] input) {
        try {
            return Base64.readEncodedFile(new ByteArrayInputStream(input));
        }
        catch (IOException ioe) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] readEncodedFile(InputStream input) throws IOException {
        baos = new ByteArrayOutputStream();
        skip_state = 0;
        a = 0;
        if (input.available() <= 0 || (a = (byte)input.read()) == 45) ** GOTO lbl72
        count = input.available();
        baos.write(a);
        i = 0;
        while (i < count) {
            a = (byte)input.read();
            if (a >= 48 && a <= 57 || a >= 65 && a <= 90 || a >= 97 && a <= 122 || a == 47 || a == 43 || a == 61) {
                baos.write(a);
            }
            ++i;
        }
        return baos.toByteArray();
lbl-1000:
        // 1 sources

        {
            switch (skip_state) {
                case 0: {
                    if (a != 45) break;
                    ++skip_state;
                    break;
                }
                case 1: {
                    if (a == 45) break;
                    ++skip_state;
                    break;
                }
                case 2: {
                    if (a != 45) break;
                    ++skip_state;
                    break;
                }
                case 3: {
                    if (a == 45) {
                        ++skip_state;
                        break;
                    }
                    --skip_state;
                    break;
                }
                case 4: {
                    if (a == 45) break;
                    ++skip_state;
                    break;
                }
                case 5: {
                    if (a >= 48 && a <= 57 || a >= 65 && a <= 90 || a >= 97 && a <= 122 || a == 47 || a == 43 || a == 61) {
                        baos.write(a);
                        break;
                    }
                    if (a != 45) break;
                    ++skip_state;
                    break;
                }
                case 6: {
                    if (a == 45) {
                        ++skip_state;
                        break;
                    }
                    --skip_state;
                    break;
                }
                case 7: {
                    if (a == 45) break;
                    ++skip_state;
                    break;
                }
                case 8: {
                    if (a != 45) break;
                    ++skip_state;
                    break;
                }
                case 9: {
                    if (a == 45) {
                        ++skip_state;
                        break;
                    }
                    --skip_state;
                    break;
                }
                case 10: {
                    if (a == 45) break;
                    ++skip_state;
                    break;
                }
                case 11: {
                    break;
                }
            }
            a = (byte)input.read();
lbl72:
            // 2 sources

            ** while (input.available() > 0)
        }
lbl73:
        // 1 sources

        return baos.toByteArray();
    }

    static byte[] charArrToByteArr(char[] array) {
        byte[] result = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = Convert.charToAscii(array[i]);
            ++i;
        }
        return result;
    }
}

