/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ASTPair;
import antlr.CommonAST;
import antlr.Token;
import antlr.Tool;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;

public class ASTFactory {
    protected String theASTNodeType = null;
    protected Class theASTNodeTypeClass = null;

    public void addASTChild(ASTPair currentAST, AST child) {
        if (child != null) {
            if (currentAST.root == null) {
                currentAST.root = child;
            } else if (currentAST.child == null) {
                currentAST.root.setFirstChild(child);
            } else {
                currentAST.child.setNextSibling(child);
            }
            currentAST.child = child;
            currentAST.advanceChildToEnd();
        }
    }

    public AST create() {
        AST t = null;
        if (this.theASTNodeTypeClass == null) {
            t = new CommonAST();
        } else {
            try {
                t = (AST)this.theASTNodeTypeClass.newInstance();
            }
            catch (Exception e) {
                Tool.warning("Can't create AST Node " + this.theASTNodeType);
                return null;
            }
        }
        return t;
    }

    public AST create(int type) {
        AST t = this.create();
        t.initialize(type, "");
        return t;
    }

    public AST create(int type, String txt) {
        AST t = this.create();
        t.initialize(type, txt);
        return t;
    }

    public AST create(AST tr) {
        if (tr == null) {
            return null;
        }
        AST t = this.create();
        t.initialize(tr);
        return t;
    }

    public AST create(Token tok) {
        AST t = this.create();
        t.initialize(tok);
        return t;
    }

    public AST dup(AST t) {
        return this.create(t);
    }

    public AST dupList(AST t) {
        AST result;
        AST nt = result = this.dupTree(t);
        while (t != null) {
            t = t.getNextSibling();
            nt.setNextSibling(this.dupTree(t));
            nt = nt.getNextSibling();
        }
        return result;
    }

    public AST dupTree(AST t) {
        AST result = this.dup(t);
        if (t != null) {
            result.setFirstChild(this.dupList(t.getFirstChild()));
        }
        return result;
    }

    public AST make(AST[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        AST root = nodes[0];
        AST tail = null;
        if (root != null) {
            root.setFirstChild(null);
        }
        int i = 1;
        while (i < nodes.length) {
            if (nodes[i] != null) {
                if (root == null) {
                    root = tail = nodes[i];
                } else if (tail == null) {
                    root.setFirstChild(nodes[i]);
                    tail = root.getFirstChild();
                } else {
                    tail.setNextSibling(nodes[i]);
                    tail = tail.getNextSibling();
                }
                while (tail.getNextSibling() != null) {
                    tail = tail.getNextSibling();
                }
            }
            ++i;
        }
        return root;
    }

    public AST make(ASTArray nodes) {
        return this.make(nodes.array);
    }

    public void makeASTRoot(ASTPair currentAST, AST root) {
        if (root != null) {
            root.addChild(currentAST.root);
            currentAST.child = currentAST.root;
            currentAST.advanceChildToEnd();
            currentAST.root = root;
        }
    }

    public void setASTNodeType(String t) {
        this.theASTNodeType = t;
        try {
            this.theASTNodeTypeClass = Class.forName(t);
        }
        catch (Exception e) {
            Tool.warning("Can't find/access AST Node type" + t);
        }
    }
}

