/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SetClause;
import com.sap.sql.tree.SetFunction;
import java.util.Stack;
import java.util.Vector;

public class CheckSetClauseVisitor
extends CheckVisitor {
    private boolean checked = false;
    private Boolean inSetClause = null;
    private Stack stack = new Stack();

    public CheckSetClauseVisitor(Vector errorLog) {
        super(errorLog);
        this.inSetClause = new Boolean(false);
    }

    public boolean isChecked() {
        return this.checked;
    }

    private void logError() {
        String txt = CommonSQLParserErrors.msg("setFunctionInSetClause");
        this.errorLog.add(new LogEntry(txt, 0, 0));
    }

    public void visitQuerySpecificationBefore(QuerySpecification aQuery) {
        this.stack.push(this.inSetClause);
        this.inSetClause = new Boolean(false);
    }

    public void visitQuerySpecification(QuerySpecification aQuery) {
        this.inSetClause = (Boolean)this.stack.pop();
    }

    public void visitSetClauseBefore(SetClause aSetClause) {
        this.inSetClause = new Boolean(true);
    }

    public void visitSetClause(SetClause aSetClause) {
        this.inSetClause = new Boolean(false);
        this.checked = true;
    }

    public void visitSetFunctionBefore(SetFunction aSetFunction) {
        if (this.inSetClause.booleanValue()) {
            this.logError();
        }
    }

    public void visitCountAllBefore(CountAll aCountAll) {
        if (this.inSetClause.booleanValue()) {
            this.logError();
        }
    }
}

