/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.generation.ant;

import com.sap.tc.logging.Location;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public abstract class GenerationAntTaskBase
extends Task {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$generation$ant$GenerationAntTaskBase == null ? (class$com$sap$dictionary$generation$ant$GenerationAntTaskBase = GenerationAntTaskBase.class$("com.sap.dictionary.generation.ant.GenerationAntTaskBase")) : class$com$sap$dictionary$generation$ant$GenerationAntTaskBase).getName());
    protected static final String LOG_CATEGORY_INFO = "[Info]    ";
    protected static final String LOG_CATEGORY_WARNING = "[Warning] ";
    protected static final String LOG_CATEGORY_ERROR = "[Error]   ";
    protected static final char SEPARATOR_FILE_PATH = '/';
    protected static final char SEPARATOR_FILE_EXTENSION = '.';
    protected static final char SEPARATOR_PACKAGE = '.';
    private String mSourcepath = null;
    private String mTargetpath = null;
    private String mAddpaths = null;
    private String mClasspath = null;
    private String mDcname = null;
    private String mArchivename = null;
    private String mVendor = null;
    private String mLanguage = null;
    private boolean mIsDeployment = false;
    private boolean mIsTest = false;
    static /* synthetic */ Class class$com$sap$dictionary$generation$ant$GenerationAntTaskBase;

    protected GenerationAntTaskBase() {
    }

    protected void checkParameters() throws BuildException {
        if (this.getSourcepath().length() <= 0) {
            this.log("[Error]   Required property sourcepath is empty: Skip task!");
            throw new BuildException("[Error]   Generation failed!");
        }
        if (this.getTargetpath().length() <= 0) {
            this.log("[Error]   Required property targetpath is empty: Skip task!");
            throw new BuildException("[Error]   Generation failed!");
        }
        if (this.isDeployment()) {
            this.log("[Info]    Property deployment is true: Deployment information is provided!");
            if (this.getArchivename().length() <= 0) {
                this.log("[Error]   Required property archivename is empty: Skip task!");
                throw new BuildException("[Error]   Generation failed!");
            }
            if (this.getVendor().length() <= 0) {
                this.log("[Error]   Required property vendor is empty: Skip task!");
                throw new BuildException("[Error]   Generation failed!");
            }
            if (this.getDcname().length() <= 0) {
                this.log("[Error]   Required property dcname is empty: Skip task!");
                throw new BuildException("[Error]   Generation failed!");
            }
        }
    }

    protected final Task createAntTask(String taskName) {
        GenerationAntTaskBase lGenerationTask = (GenerationAntTaskBase)((ProjectComponent)this).project.createTask(taskName);
        if (lGenerationTask == null) {
            this.log("[Error]   Failed to create ant task " + taskName);
            throw new BuildException("[Error]   Generation failed!");
        }
        lGenerationTask.setAddpaths(this.getAddpaths());
        lGenerationTask.setArchivename(this.getArchivename());
        lGenerationTask.setClasspath(this.getClasspath());
        lGenerationTask.setDcname(this.getDcname());
        lGenerationTask.setLanguage(this.getLanguage());
        lGenerationTask.setSourcepath(this.getSourcepath());
        lGenerationTask.setTargetpath(this.getTargetpath());
        lGenerationTask.setVendor(this.getVendor());
        lGenerationTask.setTest(this.isTest());
        return lGenerationTask;
    }

    protected final String[] getFilesByExtension(String fileExtension) {
        DirectoryScanner lDirectoryScanner = new DirectoryScanner();
        lDirectoryScanner.setBasedir(this.getSourcepath());
        lDirectoryScanner.setIncludes(new String[]{"**/*." + fileExtension});
        lDirectoryScanner.scan();
        return lDirectoryScanner.getIncludedFiles();
    }

    protected final String extractPackage(String path) {
        String lPackage = path.substring(0, path.lastIndexOf(File.separatorChar));
        return lPackage.replace(File.separatorChar, '.');
    }

    protected final String extractName(String path, String extension) {
        String lName = path.substring(path.lastIndexOf(File.separator) + 1);
        return lName.substring(0, lName.lastIndexOf(extension) - 1);
    }

    protected static final String getNormalizedFileName(String fileName) {
        return fileName.replace('\\', '/');
    }

    protected static final String getFileName(String file) {
        int lIndex = (file = GenerationAntTaskBase.getNormalizedFileName(file)).lastIndexOf(47);
        if (lIndex == -1) {
            return file;
        }
        return file.substring(lIndex + 1);
    }

    protected static final String getFilePath(String file) {
        int lIndex = (file = GenerationAntTaskBase.getNormalizedFileName(file)).lastIndexOf(47);
        if (lIndex == -1) {
            return "";
        }
        return file.substring(0, lIndex);
    }

    protected final String getAddpaths() {
        return this.mAddpaths;
    }

    protected final String getArchivename() {
        return this.mArchivename;
    }

    protected final String getClasspath() {
        return this.mClasspath;
    }

    protected final String getDcname() {
        return this.mDcname;
    }

    protected final String getLanguage() {
        return this.mLanguage;
    }

    protected final String getSourcepath() {
        return this.mSourcepath;
    }

    protected final String getTargetpath() {
        return this.mTargetpath;
    }

    protected final String getVendor() {
        return this.mVendor;
    }

    protected final boolean isDeployment() {
        return this.mIsDeployment;
    }

    protected final boolean isTest() {
        return this.mIsTest;
    }

    public final void setAddpaths(String addpaths) {
        this.mAddpaths = addpaths;
    }

    public final void setArchivename(String archivename) {
        this.mArchivename = archivename;
    }

    public final void setClasspath(String classpath) {
        this.mClasspath = classpath;
    }

    public final void setDcname(String dcname) {
        this.mDcname = dcname;
    }

    public final void setLanguage(String language) {
        this.mLanguage = language;
    }

    public final void setSourcepath(String sourcepath) {
        this.mSourcepath = sourcepath;
    }

    public final void setTargetpath(String targetpath) {
        this.mTargetpath = targetpath;
    }

    public final void setVendor(String vendor) {
        this.mVendor = vendor;
    }

    public final void setDeployment(boolean isDeployment) {
        this.mIsDeployment = isDeployment;
    }

    public final void setTest(boolean isTest) {
        this.mIsTest = isTest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

