/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.edo.EdoException;
import com.sap.tc.col.edo.EdoIllegalArgumentException;
import com.sap.tc.col.edo.IEdoAtomicValue;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.ConfigurationHelper;
import com.sap.tc.col.edo.core.EdoAtomicValue;
import com.sap.tc.col.edo.core.EdoConstants;
import com.sap.tc.col.edo.core.EdoIndexTable;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.EdoXmlReader;
import com.sap.tc.col.edo.core.SAXEventHandler;
import com.sap.tc.col.edo.core.SAXEventSource;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHelper
implements IEdoWriteStream,
IEdoReadStream,
CCDirectives {
    private static final String _className = (class$com$sap$tc$col$edo$core$XMLHelper == null ? (class$com$sap$tc$col$edo$core$XMLHelper = XMLHelper.class$("com.sap.tc.col.edo.core.XMLHelper")) : class$com$sap$tc$col$edo$core$XMLHelper).getName();
    private static final Location _location = Location.getLocation((String)_className);
    private TransformerFactory xmrFactory;
    private SAXParserFactory saxParserFactory;
    private Transformer txr;
    private SAXParser parser;
    private SAXEventSource.Structure m_structureSource = new SAXEventSource.Structure();
    private SAXEventSource.Table m_tableSource = new SAXEventSource.Table();
    private SAXEventSource.IndexTable m_indexTableSource = new SAXEventSource.IndexTable();
    private SAXEventHandler m_saxEventHandler = new SAXEventHandler();
    private SAXEventHandler.Structure m_structureHandler = new SAXEventHandler.Structure();
    private SAXEventHandler.Variant m_variantHandler;
    private SAXEventHandler.Table m_tableHandler = new SAXEventHandler.Table();
    private SAXEventHandler.IndexTable m_indexTableHandler = new SAXEventHandler.IndexTable();
    private SAXSource m_saxSource;
    private byte[] m_XString;
    private static final byte[] EMPTY_XSTRING;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$XMLHelper;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$javax$xml$parsers$SAXParserFactory;

    public XMLHelper() {
        this.m_variantHandler = new SAXEventHandler.Variant();
        this.m_XString = EMPTY_XSTRING;
        this.m_saxSource = new SAXSource(new EdoXmlReader(), null);
    }

    public void setXString(byte[] xString) {
        this.m_XString = xString;
    }

    public byte[] getXString() {
        return this.m_XString;
    }

    public void clearXString() {
        this.m_XString = EMPTY_XSTRING;
    }

    public void write(IEdoStructure value) {
        this.m_structureSource.setRecord((EdoStructure)value);
        this.write(this.m_structureSource);
    }

    public void write(IEdoTable value) {
        this.m_tableSource.setTable((EdoTable)value);
        this.write(this.m_tableSource);
    }

    public void write(IEdoAtomicValue value) {
        try {
            String strValue = ((EdoAtomicValue)value).getStringValueInternal();
            this.m_XString = strValue == null || strValue.length() == 0 ? EMPTY_XSTRING : strValue.getBytes(EdoConstants.ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            EdoException ex1 = new EdoException("Serialization failed", ex);
            throw ex1;
        }
    }

    public void write(IEdoIndexTable value) {
        this.m_indexTableSource.setIndexTable((EdoIndexTable)value);
        this.write(this.m_indexTableSource);
    }

    public void read(IEdoStructure value) {
        this.m_structureHandler.setRecord((EdoStructure)value);
        this.read(this.m_structureHandler);
    }

    public void read(IEdoVariant value) {
        this.m_variantHandler.setVariant((EdoVariant)value);
        this.read(this.m_variantHandler);
    }

    public void read(IEdoTable value) {
        this.m_tableHandler.setTable((EdoTable)value);
        this.read(this.m_tableHandler);
    }

    public void read(IEdoAtomicValue value) {
        try {
            if (this.m_XString == null) {
                ((EdoAtomicValue)value).setStringValueInternal(null);
            } else {
                ((EdoAtomicValue)value).setStringValueInternal(new String(this.m_XString, EdoConstants.ENCODING));
            }
        }
        catch (UnsupportedEncodingException ex) {
            EdoException ex1 = new EdoException("Deserialization failed", ex);
            throw ex1;
        }
    }

    public void read(IEdoIndexTable value) {
        this.m_indexTableHandler.setIndexTable((EdoIndexTable)value);
        this.read(this.m_indexTableHandler);
    }

    private void write(SAXEventSource source) {
        if (source == null) {
            EdoIllegalArgumentException ex = new EdoIllegalArgumentException(_className, "write", "source", source, "should not be null");
            _location.throwing("write", (Throwable)ex);
            throw ex;
        }
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        Transformer txr = this.getTransformer();
        try {
            try {
                this.m_saxSource.setInputSource(source);
                txr.transform(this.m_saxSource, new StreamResult(ostream));
            }
            catch (TransformerException ex) {
                _location.catching("write", (Throwable)ex);
                EdoException nex = new EdoException("while transforming", ex);
                _location.throwing("write", (Throwable)nex);
                throw nex;
            }
            Object var7_5 = null;
            this.releaseTransformer(txr);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseTransformer(txr);
            throw throwable;
        }
        this.m_XString = ostream.toByteArray();
    }

    private void read(SAXEventHandler.AbstractValue handler) {
        if (handler == null) {
            EdoIllegalArgumentException ex = new EdoIllegalArgumentException(_className, "read", "handler", handler, "should not be null");
            _location.throwing("read", (Throwable)ex);
            throw ex;
        }
        SAXParser parser = null;
        try {
            try {
                parser = this.getParser();
                InputSource is = new InputSource(new ByteArrayInputStream(this.m_XString));
                is.setEncoding(EdoConstants.ENCODING);
                this.m_saxEventHandler.setValueHandler(handler);
                parser.parse(is, (DefaultHandler)this.m_saxEventHandler);
            }
            catch (IOException ex) {
                _location.catching("read", (Throwable)ex);
                EdoException nex = new EdoException("while parsing", ex);
                _location.throwing("read", (Throwable)nex);
                throw nex;
            }
            catch (SAXException ex) {
                _location.catching("read", (Throwable)ex);
                EdoException nex = new EdoException("while parsing", ex);
                _location.throwing("read", (Throwable)nex);
                throw nex;
            }
            Object var7_6 = null;
            this.releaseParser(parser);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseParser(parser);
            throw throwable;
        }
    }

    private TransformerFactory getTransformerFactory() {
        if (this.xmrFactory == null) {
            XMLHelper xMLHelper = this;
            synchronized (xMLHelper) {
                if (this.xmrFactory == null) {
                    try {
                        try {
                            ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                this.xmrFactory = TransformerFactory.newInstance();
                                Object var4_5 = null;
                                Thread.currentThread().setContextClassLoader(ctxtLoader);
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Thread.currentThread().setContextClassLoader(ctxtLoader);
                                throw throwable;
                            }
                        }
                        catch (SecurityException ex) {
                            throw new TransformerFactoryConfigurationError(ex);
                        }
                    }
                    catch (TransformerFactoryConfigurationError error) {
                        _location.catching("getTransformerFactory", (Throwable)error);
                        try {
                            this.xmrFactory = (TransformerFactory)this.getServiceFactory((class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = XMLHelper.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getName(), "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
                        }
                        catch (Exception ex) {
                            _location.fatalT("Error while creating Transformerfactory: " + ex.getMessage());
                            EdoException rex = new EdoException("Transformer Factory Configuration", ex);
                            _location.throwing("getTransformerFactory", (Throwable)rex);
                            throw rex;
                        }
                    }
                }
            }
        }
        return this.xmrFactory;
    }

    public Transformer getTransformer() {
        Transformer txr = this.txr;
        if (txr == null) {
            try {
                this.txr = txr = this.getTransformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                _location.catching("getTransformer", (Throwable)ex);
                EdoException nex = new EdoException("while creating a new transformer", ex);
                _location.throwing("getTransformer", (Throwable)nex);
                throw nex;
            }
            txr.setOutputProperty("omit-xml-declaration", "yes");
            txr.setOutputProperty("encoding", EdoConstants.ENCODING);
        }
        return txr;
    }

    public void releaseTransformer(Transformer txr) {
    }

    private SAXParserFactory getParserFactory() {
        if (this.saxParserFactory == null) {
            XMLHelper xMLHelper = this;
            synchronized (xMLHelper) {
                if (this.saxParserFactory == null) {
                    try {
                        try {
                            ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                this.saxParserFactory = SAXParserFactory.newInstance();
                                Object var4_5 = null;
                                Thread.currentThread().setContextClassLoader(ctxtLoader);
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                Thread.currentThread().setContextClassLoader(ctxtLoader);
                                throw throwable;
                            }
                        }
                        catch (SecurityException ex) {
                            throw new FactoryConfigurationError(ex);
                        }
                    }
                    catch (FactoryConfigurationError error) {
                        _location.catching("getParserFactory", (Throwable)error);
                        try {
                            this.saxParserFactory = (SAXParserFactory)this.getServiceFactory((class$javax$xml$parsers$SAXParserFactory == null ? (class$javax$xml$parsers$SAXParserFactory = XMLHelper.class$("javax.xml.parsers.SAXParserFactory")) : class$javax$xml$parsers$SAXParserFactory).getName(), "com.sap.engine.lib.jaxp.SAXParserFactoryImpl");
                        }
                        catch (Exception ex) {
                            _location.fatalT("Error while creating Parserfactory: " + ex.getMessage());
                            EdoException rex = new EdoException("Parser Factory Configuration", ex);
                            _location.throwing("getParserFactory", (Throwable)rex);
                            throw rex;
                        }
                    }
                    if (this.saxParserFactory != null) {
                        this.saxParserFactory.setNamespaceAware(true);
                    }
                }
            }
        }
        return this.saxParserFactory;
    }

    public SAXParser getParser() {
        SAXParser parser = this.parser;
        if (parser == null) {
            try {
                this.parser = parser = this.getParserFactory().newSAXParser();
            }
            catch (ParserConfigurationException ex) {
                _location.catching("getParser", (Throwable)ex);
                EdoException nex = new EdoException("while creating a new SAX parser", ex);
                _location.throwing("getParser", (Throwable)nex);
                throw nex;
            }
            catch (SAXException ex) {
                _location.catching("getParser", (Throwable)ex);
                EdoException nex = new EdoException("while creating a new SAX parser", ex);
                _location.throwing("getParser", (Throwable)nex);
            }
        }
        return parser;
    }

    public void releaseParser(SAXParser parser) {
    }

    private Object getServiceFactory(String factoryKey, String defaultImpl) {
        InputStream inputstream;
        String implClass = null;
        implClass = ConfigurationHelper.getProperty(factoryKey);
        if (implClass == null && (inputstream = this.getClass().getResourceAsStream("/META-INF/services/" + factoryKey)) != null) {
            try {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                implClass = bufferedreader.readLine();
                bufferedreader.close();
            }
            catch (Exception ex) {
                _location.catching("getServiceFactory", (Throwable)ex);
            }
        }
        if (implClass == null) {
            implClass = defaultImpl;
        }
        Object factory = null;
        if (implClass != null) {
            try {
                factory = Class.forName(implClass).newInstance();
            }
            catch (Exception ex) {
                _location.catching("getServiceFactory", (Throwable)ex);
                EdoException rex = new EdoException("Service factory " + implClass + " could not be instantiated", ex);
                _location.throwing("getServiceFactory", (Throwable)rex);
                throw rex;
            }
        } else {
            EdoException rex = new EdoException("Service factory for " + factoryKey + " could not be found");
            _location.throwing("getServiceFactory", (Throwable)rex);
            throw rex;
        }
        return factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/XMLHelper.java#1 $");
        EMPTY_XSTRING = new byte[0];
    }
}

