/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.edo.core.Base64;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;

public class TypeHelper {
    private static final Location _location = Location.getLocation((Class)(class$com$sap$tc$col$edo$core$ConfigurationHelper == null ? (class$com$sap$tc$col$edo$core$ConfigurationHelper = TypeHelper.class$("com.sap.tc.col.edo.core.ConfigurationHelper")) : class$com$sap$tc$col$edo$core$ConfigurationHelper));
    static final TreeMap types;
    static final String STRING = "STRING";
    static final String INTEGER = "INTEGER";
    static final String BOOLEAN = "BOOLEAN";
    static final String DOUBLE = "DOUBLE";
    static final String DATE = "DATE";
    static final String TIME = "TIME";
    static final String TIMESTAMP = "TIMESTAMP";
    static final String BIGDECIMAL = "DECIMAL";
    static final String BINARY = "BINARY";
    static final String TABLE_INDEX = "TABLE_INDEX";
    static final String decimalFormat = ".0######";
    static final String dateFormat = "yyyy-MM-dd";
    static final String timeFormat = "HH:mm:ss";
    static final String timestampFormat = "yyyyMMddHHmmss";
    static final String default_string = "";
    static final Integer default_integer;
    static final Double default_double;
    static final Boolean default_boolean;
    static final String initial_date_string = "0000-00-00";
    static final DecimalFormat df;
    static final SimpleDateFormat sdf;
    static final SimpleDateFormat stf;
    static final SimpleDateFormat stmf;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$ConfigurationHelper;

    public static Type getType(String name) {
        Type type = (Type)types.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Type name '" + name + "' is not known.");
        }
        return type;
    }

    public static String format(Object value, String type) {
        return TypeHelper.getType(type).format(value);
    }

    public static Object parse(String value, String type) {
        return TypeHelper.getType(type).parse(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/TypeHelper.java#2 $");
        types = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        default_integer = new Integer(0);
        default_double = new Double(0.0);
        default_boolean = Boolean.FALSE;
        df = new DecimalFormat(decimalFormat, new DecimalFormatSymbols(Locale.US));
        sdf = new SimpleDateFormat(dateFormat, Locale.US);
        sdf.setLenient(false);
        sdf.setTimeZone(TimeZone.getDefault());
        stf = new SimpleDateFormat(timeFormat, Locale.US);
        stf.setLenient(false);
        stf.setTimeZone(TimeZone.getDefault());
        stmf = new SimpleDateFormat(timestampFormat, Locale.US);
        stmf.setLenient(false);
        stmf.setTimeZone(TimeZone.getTimeZone("UTC"));
        new Type(STRING){

            public String format(Object value) {
                return (String)value;
            }

            public Object parse(String value) {
                if (value == null) {
                    return TypeHelper.default_string;
                }
                return value;
            }
        };
        new Type(INTEGER){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                return ((Integer)value).toString();
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return default_integer;
                }
                return Integer.valueOf(value);
            }

            public int parseInt(String value) {
                if (value == null) {
                    return default_integer;
                }
                if (value.length() == 0) {
                    return default_integer;
                }
                return Integer.parseInt(value);
            }

            public String format(int value) {
                return Integer.toString(value);
            }
        };
        new Type(TABLE_INDEX){
            static final int INDEX_OFFSET = 1;

            public String format(Object value) {
                return Integer.toString((Integer)value + 1);
            }

            public Object parse(String value) {
                return new Integer(Integer.parseInt(value) - 1);
            }

            public int parseInt(String value) {
                return Integer.parseInt(value) - 1;
            }

            public String format(int value) {
                return Integer.toString(value + 1);
            }
        };
        new Type(DATE){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                return sdf.format(value);
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0 || TypeHelper.initial_date_string.equals(value)) {
                    return null;
                }
                ParsePosition pos = new ParsePosition(0);
                java.util.Date d = sdf.parse(value, pos);
                if (d == null || pos.getIndex() != 10 || pos.getErrorIndex() > -1) {
                    return null;
                }
                return new Date(d.getTime());
            }
        };
        new Type(BOOLEAN){
            static final String TRUE = "X";
            static final String FALSE = " ";

            public String format(Object value) {
                if (Boolean.TRUE.equals(value)) {
                    return TRUE;
                }
                if (Boolean.FALSE.equals(value)) {
                    return FALSE;
                }
                return null;
            }

            public Object parse(String value) {
                if (TRUE.equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                if (FALSE.equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                return default_boolean;
            }

            public boolean parseBoolean(String value) {
                if (TRUE.equalsIgnoreCase(value)) {
                    return true;
                }
                if (FALSE.equalsIgnoreCase(value)) {
                    return false;
                }
                return default_boolean;
            }

            public String format(boolean value) {
                if (value) {
                    return TRUE;
                }
                return FALSE;
            }
        };
        new Type(DOUBLE){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                return value.toString();
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return default_double;
                }
                return Double.valueOf(value);
            }

            public double parseDouble(String value) {
                if (value == null || value.length() == 0) {
                    return default_double;
                }
                return Double.parseDouble(value);
            }

            public String format(double value) {
                return String.valueOf(value);
            }
        };
        new Type(BIGDECIMAL){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                return ((BigDecimal)value).toString();
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return new BigDecimal(value);
            }
        };
        new Type(TIME){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                return stf.format(value);
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                ParsePosition pos = new ParsePosition(0);
                java.util.Date d = stf.parse(value, pos);
                if (d == null || pos.getIndex() != 8 || pos.getErrorIndex() > -1) {
                    return null;
                }
                return new Time(d.getTime());
            }
        };
        new Type(TIMESTAMP){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                StringBuffer buffer = new StringBuffer();
                FieldPosition fp = new FieldPosition(0);
                Timestamp ts = (Timestamp)value;
                stmf.format((java.util.Date)ts, buffer, fp);
                int nanos = ts.getNanos();
                if (nanos != 0) {
                    df.format((double)nanos * 1.0E-9, buffer, fp);
                }
                return buffer.toString();
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                ParsePosition pos = new ParsePosition(0);
                java.util.Date d = stmf.parse(value, pos);
                if (d == null || pos.getIndex() != 14 || pos.getErrorIndex() > -1) {
                    return null;
                }
                Number n = df.parse(value, pos);
                int nanos = n != null ? (int)(n.doubleValue() * 1.0E9) : 0;
                Timestamp ts = new Timestamp(d.getTime());
                ts.setNanos(nanos);
                return ts;
            }
        };
        new Type(BINARY){

            public String format(Object value) {
                if (value == null) {
                    return null;
                }
                byte[] binaryValue = (byte[])value;
                String encodedValue = Base64.byteArrayToBase64(binaryValue);
                return encodedValue;
            }

            public Object parse(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                byte[] binaryValue = Base64.base64ToByteArray(value);
                return binaryValue;
            }
        };
    }

    public static abstract class Type {
        private String m_name;

        public Type(String name) {
            types.put(name, this);
        }

        public final String getName() {
            return this.m_name;
        }

        public abstract String format(Object var1);

        public abstract Object parse(String var1);

        public int parseInt(String value) {
            throw new RuntimeException("Method not implemented.");
        }

        public String format(int value) {
            throw new RuntimeException("Method not implemented.");
        }

        public boolean parseBoolean(String value) {
            throw new RuntimeException("Method not implemented.");
        }

        public String format(boolean value) {
            throw new RuntimeException("Method not implemented.");
        }

        public double parseDouble(String value) {
            throw new RuntimeException("Method not implemented.");
        }

        public String format(double value) {
            throw new RuntimeException("Method not implemented.");
        }
    }
}

