/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.AbstractTest;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.core.EdoStructure;

public class TestVariant
extends AbstractTest {
    private final IEdoStructure sVariant = new EdoStructure((IStructureDescriptor)AbstractTest.variantDesc);
    private final IEdoStructure s2 = new EdoStructure((IStructureDescriptor)AbstractTest.desc2);
    private static final String value1 = "First Value";
    private static final String value2 = "Second Value";
    private static final String valueX = "Another Value";

    public void testGetnSetVariant() {
        this.sVariant.clear();
        this.sVariant.setStringValue(0, value1);
        this.sVariant.setStringValue(1, value2);
        IEdoVariant variantValue = this.sVariant.getVariantValue(2, true);
        IEdoStructure s1 = variantValue.getValue(AbstractTest.desc1.getName(), true);
        s1.setStringValue(0, value1);
        s1.setStringValue(1, value2);
        IEdoStructure variant = this.sVariant.getVariantValue(2).getValue();
        this.verify(value1.equals(variant.getStringValue(0)), "Incorrect Value for field 0");
        this.verify(value2.equals(variant.getStringValue(1)), "Incorrect Value for filed 1");
        this.verify(s1.getDescriptor().getName().equals(variantValue.getActiveName()), "Incorrect variant descriptor. Expected :" + AbstractTest.desc1.getName());
        variantValue.clear();
        variantValue.getValue(AbstractTest.desc2.getName(), true);
        this.verify(AbstractTest.desc2.getName().equals(variantValue.getActiveName()), "Incorrect variant descriptor. Expected :" + AbstractTest.desc2.getName());
    }

    public void testTypeValidations() {
        this.sVariant.clear();
        try {
            this.sVariant.setStringValue(2, value1);
            this.verify(false, "String is assigned to a variant");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.sVariant.getVariantValue(0);
            this.verify(false, " Trying to fetch a variant from a String field.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

