/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.AbstractTest;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;

public class TestTable
extends AbstractTest {
    private final EdoTable t1 = new EdoTable((IStructureDescriptor)AbstractTest.desc1);
    private final EdoTable t1a = new EdoTable((IStructureDescriptor)AbstractTest.desc1a);
    private final EdoTable t3 = new EdoTable((IStructureDescriptor)AbstractTest.desc3);
    private final EdoTable t11 = new EdoTable((IStructureDescriptor)AbstractTest.desc1);
    private final EdoTable t4 = new EdoTable((IStructureDescriptor)AbstractTest.desc4);
    private static final String value1 = "First Value";
    private static final String value2 = "Second Value";
    private static final String valueX = "Another Value";

    public void testGetMeta() {
        this.verify("T".equals(this.t1.getMeta()), "Incorrect meta");
        this.verify("T".equals(this.t1a.getMeta()), "Incorrect meta");
        this.verify("T".equals(this.t3.getMeta()), "Incorrect meta");
        this.verify("T".equals(this.t11.getMeta()), "Incorrect meta");
    }

    public void testClear() {
        this.t1.append(3);
        this.verify(3 == this.t1.getRecordCount(), "Wrong record count.");
        this.t1.setStringValue(0, "FIELD1", value1);
        this.t1.setStringValue(0, "FIELD2", value2);
        this.verify(null != this.t1.getStringValue(0, 0), "Wrong Field Value");
        this.verify(null != this.t1.getStringValue(0, 1), "Wrong Field Value");
        this.t1.clear();
        this.verify(0 == this.t1.getRecordCount(), "Wrong record count.");
    }

    public void testAppend() {
        this.t1.clear();
        this.t1.append(3);
        this.verify(3 == this.t1.getRecordCount(), "Wrong record count.");
        int row = 0;
        while (row < 3) {
            this.verify("".equals(this.t1.getStringValue(row, "FIELD1")), "Wrong Field Value");
            this.verify("".equals(this.t1.getStringValue(row, 0)), "Wrong Field Value");
            this.verify("".equals(this.t1.getStringValue(row, "FIELD2")), "Wrong Field Value");
            this.verify("".equals(this.t1.getStringValue(row, 1)), "Wrong Field Value");
            ++row;
        }
        EdoStructure s1 = new EdoStructure((IStructureDescriptor)AbstractTest.desc1);
        s1.setStringValue("FIELD1", value1);
        s1.setStringValue("FIELD2", value2);
        this.t1.append(s1);
        this.verify(value1 == this.t1.getStringValue(3, "FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(3, 0), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(3, "FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(3, 1), "Wrong Field Value");
        this.t11.clear();
        this.t11.append(5);
        this.verify(5 == this.t11.getRecordCount(), "Wrong record count.");
        this.t11.append(this.t1, 2, 2);
        this.verify(7 == this.t11.getRecordCount(), "Wrong record count.");
        this.verify(value1 == this.t11.getStringValue(6, "FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.t11.getStringValue(6, 0), "Wrong Field Value");
        this.verify(value2 == this.t11.getStringValue(6, "FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.t11.getStringValue(6, 1), "Wrong Field Value");
    }

    public void testAppendCorresponding() {
        EdoStructure s1a = new EdoStructure((IStructureDescriptor)AbstractTest.desc1a);
        s1a.setStringValue("FIELD1", value1);
        s1a.setStringValue("FIELD2", value2);
        this.t1.appendCorresponding(s1a);
        this.t1.clear();
        this.verify(0 == this.t1.getRecordCount(), "Wrong record count.");
        this.t1.appendCorresponding(s1a);
        this.verify(1 == this.t1.getRecordCount(), "Wrong record count.");
        this.verify(value1 == this.t1.getStringValue(0, "FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(0, 0), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(0, "FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(0, 1), "Wrong Field Value");
        this.t1a.clear();
        this.verify(0 == this.t1a.getRecordCount(), "Wrong record count.");
        this.t1a.append(s1a);
        this.t1a.append(s1a);
        this.t1a.append(s1a);
        this.t1.clear();
        this.t1.append(2);
        this.t1.appendCorresponding(this.t1a, 0, 3);
        this.verify(5 == this.t1.getRecordCount(), "Wrong record count.");
        int row = 2;
        while (row < 5) {
            this.verify(value1 == this.t1.getStringValue(row, "FIELD1"), "Wrong Field Value");
            this.verify(value1 == this.t1.getStringValue(row, 0), "Wrong Field Value");
            this.verify(value2 == this.t1.getStringValue(row, "FIELD2"), "Wrong Field Value");
            this.verify(value2 == this.t1.getStringValue(row, 1), "Wrong Field Value");
            ++row;
        }
    }

    public void testGetnSetValue() {
        this.t4.clear();
        this.t4.append(1);
        int value0 = 1;
        GregorianCalendar cal = new GregorianCalendar(Locale.US);
        cal.clear();
        cal.set(2003, 3, 24);
        java.sql.Date value1 = new java.sql.Date(cal.getTime().getTime());
        String value2 = "This is generic test";
        boolean value3 = true;
        cal.clear();
        cal.set(1970, 0, 1, 12, 12, 34);
        Time value4 = new Time(cal.getTime().getTime());
        double value5 = 9.12345;
        BigDecimal value6 = new BigDecimal(value5);
        Timestamp value7 = new Timestamp(new Date().getTime());
        value7.setNanos(123006007);
        byte[] value8 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        this.t4.setValue(0, "FIELDINT", (Object)new Integer(value0));
        this.t4.setValue(0, "FIELDDATE", (Object)value1);
        this.t4.setValue(0, "FIELDSTR", (Object)value2);
        this.t4.setValue(0, "FIELDBOOLEAN", (Object)new Boolean(value3));
        this.t4.setValue(0, "FIELDTIME", (Object)value4);
        this.t4.setValue(0, "FIELDDOUBLE", (Object)new Double(value5));
        this.t4.setValue(0, "FIELDDECIMAL", (Object)value6);
        this.t4.setValue(0, "FIELDTIMESTAMP", (Object)value7);
        this.t4.setValue(0, "FIELDBINARY", (Object)value8);
        this.verify(value0 == this.t4.getIntValue(0, "FIELDINT"), "Wrong Field Value", 1);
        this.verify(value1.equals(this.t4.getDateValue(0, "FIELDDATE")), "Wrong Field Value", 1);
        this.verify(value2.equals(this.t4.getStringValue(0, "FIELDSTR")), "Wrong Field Value", 1);
        this.verify(value3 == this.t4.getBooleanValue(0, "FIELDBOOLEAN"), "Wrong Field Value", 1);
        this.verify(value4.equals(this.t4.getTimeValue(0, "FIELDTIME")), "Wrong Field Value", 1);
        this.verify(value5 == this.t4.getDoubleValue(0, "FIELDDOUBLE"), "Wrong Field Value", 1);
        this.verify(value6.equals(this.t4.getDecimalValue(0, "FIELDDECIMAL")), "Wrong Field Value", 1);
        Timestamp ts = this.t4.getTimestampValue(0, "FIELDTIMESTAMP");
        this.verify(((Date)value7).getTime() == ((Date)ts).getTime() && value7.getNanos() / 100 * 100 == ts.getNanos(), "Wrong Field Value", 1);
        byte[] data = this.t4.getBinaryValue(0, "FIELDBINARY");
        this.verify(Arrays.equals(data, value8), "Wrong Field Value", 1);
        this.t4.clear();
        this.t4.append(1);
        this.t4.setIntValue(0, 0, value0);
        this.t4.setDateValue(0, 1, value1);
        this.t4.setStringValue(0, 2, value2);
        this.t4.setBooleanValue(0, 3, value3);
        this.t4.setTimeValue(0, 4, value4);
        this.t4.setDoubleValue(0, 5, value5);
        this.t4.setDecimalValue(0, 6, value6);
        this.t4.setTimestampValue(0, 7, value7);
        this.t4.setBinaryValue(0, 8, value8);
        this.verify(value0 == (Integer)this.t4.getValue(0, 0), "Wrong Field Value");
        this.verify(value1.toString().equals(this.t4.getValue(0, 1).toString()), "Wrong Field Value");
        this.verify(value2.equals(this.t4.getValue(0, 2)), "Wrong Field Value");
        this.verify(value3 == (Boolean)this.t4.getValue(0, 3), "Wrong Field Value");
        this.verify(value4.toString().equals(this.t4.getValue(0, 4).toString()), "Wrong Field Value");
        this.verify(value5 == (Double)this.t4.getValue(0, 5), "Wrong Field Value");
        this.verify(value6.equals(this.t4.getValue(0, 6)), "Wrong Field Value");
        ts = (Timestamp)this.t4.getValue(0, 7);
        this.verify(((Date)value7).getTime() == ((Date)ts).getTime() && value7.getNanos() / 100 * 100 == ts.getNanos(), "Wrong Field Value");
        data = this.t4.getBinaryValue(0, 8);
        this.verify(Arrays.equals(data, value8), "Wrong Field Value", 1);
    }

    public void testGetnSetStringValue() {
        this.t1.clear();
        this.t1.append(1);
        this.t1.setStringValue(0, "FIELD1", value1);
        this.t1.setStringValue(0, "FIELD2", value2);
        this.verify(value1 == this.t1.getStringValue(0, "FIELD1"), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(0, 0), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(0, "FIELD2"), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(0, 1), "Wrong Field Value");
        this.t1.setStringValue(0, "FIELD1", value2);
        this.t1.setStringValue(0, "FIELD2", value1);
        this.verify(value2 == this.t1.getStringValue(0, "FIELD1"), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(0, 0), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(0, "FIELD2"), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(0, 1), "Wrong Field Value");
        this.t1.append(1);
        this.t1.setValue(1, "FIELD1", (Object)value2);
        this.t1.setValue(1, "FIELD2", (Object)value1);
        this.verify(value2 == this.t1.getStringValue(1, "FIELD1"), "Wrong Field Value");
        this.verify(value2 == this.t1.getStringValue(1, 0), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(1, "FIELD2"), "Wrong Field Value");
        this.verify(value1 == this.t1.getStringValue(1, 1), "Wrong Field Value");
    }

    public void testIterator() {
        IEdoStructure row;
        this.t1.clear();
        this.t1.append(3);
        String[] values = new String[this.t1.getRecordCount()];
        int i = 0;
        int len = this.t1.getRecordCount();
        while (i < len) {
            this.t1.setStringValue(i, "FIELD1", value1);
            values[i] = String.valueOf(i);
            this.t1.setStringValue(i, "FIELD2", values[i]);
            ++i;
        }
        Iterator iter = this.t1.getRecordIterator();
        int i2 = -1;
        while (iter.hasNext()) {
            row = (IEdoStructure)iter.next();
            this.verify(value1 == row.getStringValue("FIELD1"), "Wrong Field Value", 1);
            this.verify(values[++i2] == row.getStringValue("FIELD2"), "Wrong Field Value", 1);
        }
        int j = 0;
        int len2 = this.t1.getRecordCount();
        while (j < len2) {
            row = this.t1.getRecord(j);
            this.verify(value1 == row.getStringValue("FIELD1"), "Wrong Field Value", 1);
            this.verify(values[j] == row.getStringValue("FIELD2"), "Wrong Field Value", 1);
            ++j;
        }
        int j2 = 0;
        int len3 = this.t1.getRecordCount();
        while (j2 < len3) {
            IEdoStructure row2 = this.t1.getRecord(j2);
            values[j2] = String.valueOf(j2 + 2345);
            row2.setStringValue("FIELD2", values[j2]);
            row2.setStringValue("FIELD1", value2);
            ++j2;
        }
        int i3 = 0;
        int len4 = this.t1.getRecordCount();
        while (i3 < len4) {
            this.verify(value2 == this.t1.getStringValue(i3, "FIELD1"), "Wrong Field Value", 1);
            this.verify(values[i3] == this.t1.getStringValue(i3, "FIELD2"), "Wrong Field Value", 1);
            ++i3;
        }
    }

    public void testGenSetNullValue() {
        this.t4.clear();
        this.t4.append(1);
        Boolean default_boolean = Boolean.FALSE;
        Double default_double = new Double(0.0);
        Integer default_integer = new Integer(0);
        int i = 0;
        int len = this.t4.getFieldCount();
        while (i < len) {
            IFieldDescriptor fd = this.t4.getDescriptor().getFieldDescriptor(i);
            this.verify(this.t4.isInitial(0, i), "is initial returned false for " + fd.getName(), 1);
            ++i;
        }
        int i2 = 0;
        int len2 = this.t4.getFieldCount();
        while (i2 < len2) {
            IFieldDescriptor fd = this.t4.getDescriptor().getFieldDescriptor(i2);
            if ("STRING".equals(fd.getType())) {
                this.verify("".equals(this.t4.getValue(0, i2)), "getValue not default for field " + fd.getName(), 1);
            } else if ("BOOLEAN".equals(fd.getType())) {
                this.verify(((Object)default_boolean).equals(this.t4.getValue(0, i2)), "getValue not default for field " + fd.getName(), 1);
            } else if ("INTEGER".equals(fd.getType())) {
                this.verify(((Object)default_integer).equals(this.t4.getValue(0, i2)), "getValue not default for field " + fd.getName(), 1);
            } else if ("DOUBLE".equals(fd.getType())) {
                this.verify(((Object)default_double).equals(this.t4.getValue(0, i2)), "getValue not default for field " + fd.getName(), 1);
            } else {
                this.verify(null == this.t4.getValue(0, i2), "getValue not null for field " + fd.getName(), 1);
            }
            ++i2;
        }
        int i3 = 0;
        int len3 = this.t4.getFieldCount();
        while (i3 < len3) {
            IFieldDescriptor fd = this.t4.getDescriptor().getFieldDescriptor(i3);
            try {
                this.t4.setValue(0, i3, null);
            }
            catch (Exception ex) {
                this.flop("setValue with null failed field " + fd.getName(), 1);
            }
            ++i3;
        }
        this.t4.clear();
    }

    public void testGetTable() {
        int len1;
        int f;
        int row;
        int len12;
        int f2;
        this.t1.clear();
        this.t1.append(10);
        int i = 0;
        int len = this.t1.getRecordCount();
        while (i < len) {
            f2 = 0;
            len12 = AbstractTest.desc1.size();
            while (f2 < len12) {
                this.t1.setStringValue(i, 1, "" + i + "_" + f2);
                ++f2;
            }
            ++i;
        }
        this.t11.clear();
        this.t1.getTable(new int[0], this.t11);
        this.verify(this.t11.getRecordCount() == 0, "Table is not empty.", 1);
        this.t11.clear();
        this.t1.getTable(new int[]{0}, this.t11);
        this.verify(this.t11.getRecordCount() == 1, "Table does not contain the row.", 1);
        if (this.t11.getRecordCount() > 0) {
            row = 0;
            f = 0;
            len1 = AbstractTest.desc1.size();
            while (f < len1) {
                this.verify(this.t1.getStringValue(row, f) == this.t11.getStringValue(0, f), "Field has a different value for " + AbstractTest.desc1.getFieldDescriptor(f).getName(), 1);
                ++f;
            }
        }
        this.t11.clear();
        this.t1.getTable(new int[]{1}, this.t11);
        this.verify(this.t11.getRecordCount() == 1, "Table does not contain the row.", 1);
        if (this.t11.getRecordCount() > 0) {
            row = 1;
            f = 0;
            len1 = AbstractTest.desc1.size();
            while (f < len1) {
                this.verify(this.t1.getStringValue(row, f) == this.t11.getStringValue(0, f), "Field has a different value for " + AbstractTest.desc1.getFieldDescriptor(f).getName(), 1);
                ++f;
            }
        }
        this.t11.clear();
        this.t1.getTable(new int[]{0, 3, 5}, this.t11);
        this.verify(this.t11.getRecordCount() == 3, "Table does not contain the rows.", 1);
        if (this.t11.getRecordCount() > 0) {
            f2 = 0;
            len12 = AbstractTest.desc1.size();
            while (f2 < len12) {
                this.verify(this.t1.getStringValue(0, f2) == this.t11.getStringValue(0, f2), "Field has a different value for " + AbstractTest.desc1.getFieldDescriptor(f2).getName(), 1);
                ++f2;
            }
            int f3 = 0;
            int len13 = AbstractTest.desc1.size();
            while (f3 < len13) {
                this.verify(this.t1.getStringValue(3, f3) == this.t11.getStringValue(1, f3), "Field has a different value for " + AbstractTest.desc1.getFieldDescriptor(f3).getName(), 1);
                ++f3;
            }
            int f4 = 0;
            int len14 = AbstractTest.desc1.size();
            while (f4 < len14) {
                this.verify(this.t1.getStringValue(5, f4) == this.t11.getStringValue(2, f4), "Field has a different value for " + AbstractTest.desc1.getFieldDescriptor(f4).getName(), 1);
                ++f4;
            }
        }
    }
}

