/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.core.AbapNameHelper;
import com.sap.tc.col.edo.core.Base64;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.EdoAtomicValue;
import com.sap.tc.col.edo.core.EdoConstants;
import com.sap.tc.col.edo.core.EdoIndexTable;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.EdoTable;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.col.edo.core.XMLHelper;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SAXEventSource
extends InputSource
implements CCDirectives {
    private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventSource == null ? (class$com$sap$tc$col$edo$core$SAXEventSource = SAXEventSource.class$("com.sap.tc.col.edo.core.SAXEventSource")) : class$com$sap$tc$col$edo$core$SAXEventSource).getName();
    static final Location _location = Location.getLocation((String)_className);
    private static final String nsu = "";
    static final Attributes atts;
    private SAXSource m_saxSource;
    private SAXSource m_saxSourceWithValueTags;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventSource;

    public void setNamespaces(boolean enabled) {
    }

    public void setNamespace_prefix(boolean enabled) {
    }

    public abstract void writeTo(ContentHandler var1) throws IOException, SAXException;

    protected void writeValue(ContentHandler handler, String value) throws IOException, SAXException {
        if (value != null) {
            String root_tag = EdoConstants.VALUE_ELEMENT;
            AttributesImpl value_atts = new AttributesImpl();
            value_atts.addAttribute(nsu, EdoConstants.VALUE_ATTRIBUTE, EdoConstants.VALUE_ATTRIBUTE, "CDATA", value);
            handler.startElement(nsu, root_tag, root_tag, value_atts);
            handler.endElement(nsu, root_tag, root_tag);
        }
    }

    protected static String convertVariantToXML(IEdoStructure value) {
        XMLHelper x = new XMLHelper();
        value.writeTo(x);
        return Base64.byteArrayToBase64(x.getXString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/SAXEventSource.java#1 $");
        atts = new AttributesImpl();
    }

    public static class AtomicValue
    extends SAXEventSource {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventSource$AtomicValue == null ? (class$com$sap$tc$col$edo$core$SAXEventSource$AtomicValue = AtomicValue.class$("com.sap.tc.col.edo.core.SAXEventSource$AtomicValue")) : class$com$sap$tc$col$edo$core$SAXEventSource$AtomicValue).getName();
        private EdoAtomicValue m_atomicValue;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventSource$AtomicValue;

        public void setAtomicValue(EdoAtomicValue atomicValue) {
            this.m_atomicValue = atomicValue;
        }

        public void writeTo(ContentHandler handler) throws IOException, SAXException {
            String value = this.m_atomicValue.getStringValueInternal();
            if (value == null || SAXEventSource.nsu.equals(value)) {
                value = " ";
            }
            this.writeValue(handler, value);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class IndexTable
    extends SAXEventSource {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventSource$IndexTable == null ? (class$com$sap$tc$col$edo$core$SAXEventSource$IndexTable = IndexTable.class$("com.sap.tc.col.edo.core.SAXEventSource$IndexTable")) : class$com$sap$tc$col$edo$core$SAXEventSource$IndexTable).getName();
        private static final TypeHelper.Type indexType = TypeHelper.getType("TABLE_INDEX");
        private IStructureDescriptor m_descriptor;
        private EdoIndexTable m_indexTable;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventSource$IndexTable;

        public void setIndexTable(EdoIndexTable indexTable) {
            this.m_descriptor = indexTable.m_descriptor;
            this.m_indexTable = indexTable;
        }

        public void writeTo(ContentHandler handler) throws IOException, SAXException {
            String root_tag = AbapNameHelper.convertAbapToXml(this.m_descriptor.getName());
            String srcFieldName = AbapNameHelper.convertAbapToXml(this.m_descriptor.getFieldDescriptor(this.m_indexTable.m_srcFieldIndex).getName());
            String relFieldName = AbapNameHelper.convertAbapToXml(this.m_descriptor.getFieldDescriptor(this.m_indexTable.m_relFieldIndex).getName());
            handler.startElement(SAXEventSource.nsu, root_tag, root_tag, atts);
            ArrayList table = this.m_indexTable.m_table;
            int recIndex = 0;
            int recCount = table.size();
            while (recIndex < recCount) {
                Object oValue = table.get(recIndex);
                if (oValue != null) {
                    String srcIndex = indexType.format(recIndex);
                    int[] indexes = (int[])oValue;
                    int i = 1;
                    int len = indexes[0] + 1;
                    while (i < len) {
                        if (indexes[i] != Integer.MAX_VALUE) {
                            String relIndex = indexType.format(indexes[i]);
                            handler.startElement(SAXEventSource.nsu, "item", "item", atts);
                            handler.startElement(SAXEventSource.nsu, srcFieldName, srcFieldName, atts);
                            this.writeValue(handler, srcIndex);
                            handler.endElement(SAXEventSource.nsu, srcFieldName, srcFieldName);
                            handler.startElement(SAXEventSource.nsu, relFieldName, relFieldName, atts);
                            this.writeValue(handler, relIndex);
                            handler.endElement(SAXEventSource.nsu, relFieldName, relFieldName);
                            handler.endElement(SAXEventSource.nsu, "item", "item");
                        }
                        ++i;
                    }
                }
                ++recIndex;
            }
            handler.endElement(SAXEventSource.nsu, root_tag, root_tag);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Table
    extends SAXEventSource {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventSource$Table == null ? (class$com$sap$tc$col$edo$core$SAXEventSource$Table = Table.class$("com.sap.tc.col.edo.core.SAXEventSource$Table")) : class$com$sap$tc$col$edo$core$SAXEventSource$Table).getName();
        private IStructureDescriptor m_descriptor;
        private EdoTable m_table;
        private Structure m_variant;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventSource$Table;

        public void setTable(EdoTable table) {
            this.m_descriptor = table.m_descriptor;
            this.m_table = table;
        }

        public void writeTo(ContentHandler handler) throws IOException, SAXException {
            String root_tag = AbapNameHelper.convertAbapToXml(this.m_descriptor.getName());
            int fieldCount = this.m_descriptor.size();
            String[] fieldNames = new String[fieldCount];
            int fldIndex = 0;
            while (fldIndex < fieldCount) {
                fieldNames[fldIndex] = AbapNameHelper.convertAbapToXml(this.m_descriptor.getFieldDescriptor(fldIndex).getName());
                ++fldIndex;
            }
            handler.startElement(SAXEventSource.nsu, root_tag, root_tag, atts);
            int recIndex = 0;
            int recCount = this.m_table.getRecordCountInternal();
            while (recIndex < recCount) {
                handler.startElement(SAXEventSource.nsu, "item", "item", atts);
                int fldIndex2 = 0;
                while (fldIndex2 < fieldCount) {
                    Object oValue = this.m_table.getValueInternal(recIndex, fldIndex2);
                    if (oValue != null) {
                        try {
                            String key = fieldNames[fldIndex2];
                            String type = this.m_descriptor.getFieldDescriptor(fldIndex2).getType();
                            if (type == "VARIANT") {
                                String variantXML = null;
                                if (!(oValue instanceof EdoVariant)) {
                                    variantXML = (String)oValue;
                                } else {
                                    EdoStructure value = (EdoStructure)((EdoVariant)oValue).getValue();
                                    variantXML = SAXEventSource.convertVariantToXML(value);
                                }
                                handler.startElement(SAXEventSource.nsu, key, key, atts);
                                this.writeValue(handler, variantXML);
                                handler.endElement(SAXEventSource.nsu, key, key);
                            } else {
                                String value = (String)oValue;
                                handler.startElement(SAXEventSource.nsu, key, key, atts);
                                this.writeValue(handler, value);
                                handler.endElement(SAXEventSource.nsu, key, key);
                            }
                        }
                        catch (ClassCastException ex) {
                            SAXException sex = new SAXException("Unsupported  value type " + oValue.getClass(), ex);
                            throw sex;
                        }
                    }
                    ++fldIndex2;
                }
                handler.endElement(SAXEventSource.nsu, "item", "item");
                ++recIndex;
            }
            handler.endElement(SAXEventSource.nsu, root_tag, root_tag);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Structure
    extends SAXEventSource {
        private static final String _className = (class$com$sap$tc$col$edo$core$SAXEventSource$Structure == null ? (class$com$sap$tc$col$edo$core$SAXEventSource$Structure = Structure.class$("com.sap.tc.col.edo.core.SAXEventSource$Structure")) : class$com$sap$tc$col$edo$core$SAXEventSource$Structure).getName();
        private IStructureDescriptor m_descriptor;
        private EdoStructure m_record;
        private Structure m_variant;
        static /* synthetic */ Class class$com$sap$tc$col$edo$core$SAXEventSource$Structure;

        public void setRecord(EdoStructure record) {
            this.m_descriptor = record.m_descriptor;
            this.m_record = record;
        }

        public void writeTo(ContentHandler handler) throws IOException, SAXException {
            String root_tag = AbapNameHelper.convertAbapToXml(this.m_descriptor.getName());
            handler.startElement(SAXEventSource.nsu, root_tag, root_tag, atts);
            int i = 0;
            int len = this.m_descriptor.size();
            while (i < len) {
                Object oValue = this.m_record.getValueInternal(i);
                if (oValue != null) {
                    String key = AbapNameHelper.convertAbapToXml(this.m_descriptor.getFieldDescriptor(i).getName());
                    try {
                        Object value;
                        String variantXML = null;
                        String type = this.m_descriptor.getFieldDescriptor(i).getType();
                        if (type == "VARIANT") {
                            if (!(oValue instanceof EdoVariant)) {
                                variantXML = (String)oValue;
                            } else {
                                value = (EdoStructure)((EdoVariant)oValue).getValue();
                                variantXML = SAXEventSource.convertVariantToXML((IEdoStructure)value);
                            }
                            handler.startElement(SAXEventSource.nsu, key, key, atts);
                            this.writeValue(handler, variantXML);
                            handler.endElement(SAXEventSource.nsu, key, key);
                        } else {
                            value = (String)oValue;
                            handler.startElement(SAXEventSource.nsu, key, key, atts);
                            this.writeValue(handler, (String)value);
                            handler.endElement(SAXEventSource.nsu, key, key);
                        }
                    }
                    catch (ClassCastException ex) {
                        SAXException sex = new SAXException("Unsupported  value type " + oValue.getClass(), ex);
                        throw sex;
                    }
                }
                ++i;
            }
            handler.endElement(SAXEventSource.nsu, root_tag, root_tag);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

