/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.Base64;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.EdoAbstractValue;
import com.sap.tc.col.edo.core.EdoStructure;
import com.sap.tc.col.edo.core.XMLHelper;
import com.sap.tc.logging.Location;

public final class EdoVariant
extends EdoAbstractValue
implements IEdoVariant,
CCDirectives {
    private static final String _className = (class$com$sap$tc$col$edo$core$EdoVariant == null ? (class$com$sap$tc$col$edo$core$EdoVariant = EdoVariant.class$("com.sap.tc.col.edo.core.EdoVariant")) : class$com$sap$tc$col$edo$core$EdoVariant).getName();
    private static final Location _location = Location.getLocation((String)_className);
    protected final IFieldDescriptor m_descriptor;
    protected EdoStructure m_record;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$EdoVariant;

    public EdoVariant(IFieldDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_record = null;
    }

    public EdoVariant(EdoVariant variant) {
        this.m_descriptor = variant.m_descriptor;
        if (variant.m_record != null) {
            this.m_record = (EdoStructure)variant.m_record.deepCopy();
        }
    }

    public IFieldDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    EdoStructure createValue(String name) {
        IStructureDescriptor structDescriptor = this.m_descriptor.getVariant(name);
        return new EdoStructure(structDescriptor);
    }

    void setValue(IEdoStructure value) {
        this.m_descriptor.getVariant(value.getDescriptor().getName());
        this.m_record = (EdoStructure)value;
    }

    public IEdoStructure getValue() {
        return this.m_record;
    }

    public IEdoStructure getValue(String name, boolean createIfNull) {
        if (this.m_record == null && createIfNull) {
            this.m_record = this.createValue(name);
        }
        return this.m_record;
    }

    public String getActiveName() {
        return this.m_record != null ? this.m_record.getDescriptor().getName() : null;
    }

    public void clear() {
        this.m_record = null;
    }

    public String getMeta() {
        return "V";
    }

    public String getType() {
        return this.m_descriptor.getType();
    }

    public void readFrom(IEdoReadStream readStream) {
    }

    public void writeTo(IEdoWriteStream writeStream) {
    }

    EdoAbstractValue deepCopy() {
        return new EdoVariant(this);
    }

    public static IEdoVariant convertXMLToVariant(IFieldDescriptor descriptor, String value) {
        String base64Data = value;
        byte[] decoded = Base64.base64ToByteArray(base64Data);
        XMLHelper x = new XMLHelper();
        x.setXString(decoded);
        EdoVariant variant = new EdoVariant(descriptor);
        x.read(variant);
        return variant;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/EdoVariant.java#1 $");
    }
}

