/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.CCDirectives;
import com.sap.tc.col.edo.core.DescriptorHelper;
import com.sap.tc.col.edo.core.EdoAbstractValue;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;

public final class EdoStructure
extends EdoAbstractValue
implements IEdoStructure,
CCDirectives {
    private static final String _className = (class$com$sap$tc$col$edo$core$EdoStructure == null ? (class$com$sap$tc$col$edo$core$EdoStructure = EdoStructure.class$("com.sap.tc.col.edo.core.EdoStructure")) : class$com$sap$tc$col$edo$core$EdoStructure).getName();
    private static final Location _location = Location.getLocation((String)_className);
    static final String META_FLAG = "S";
    protected final IStructureDescriptor m_descriptor;
    protected final Object[] m_record;
    protected static final int[] empty_fieldsThatNeedDeepCopy;
    protected int[] m_fieldsThatNeedDeepCopy;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$EdoStructure;

    public EdoStructure(IStructureDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_record = new Object[descriptor.size()];
    }

    public EdoStructure(EdoStructure structure) {
        this.m_descriptor = structure.m_descriptor;
        this.m_record = (Object[])structure.m_record.clone();
        this.m_fieldsThatNeedDeepCopy = structure.m_fieldsThatNeedDeepCopy;
        this.deepCopyFieldsThatNeedDeepCopy();
    }

    EdoStructure(IStructureDescriptor descriptor, Object[] record) {
        this.m_descriptor = descriptor;
        this.m_record = record;
    }

    public String getMeta() {
        return META_FLAG;
    }

    public String getType() {
        return this.m_descriptor.getName();
    }

    public IStructureDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public int getFieldCount() {
        return this.m_record.length;
    }

    public void clear() {
        Arrays.fill(this.m_record, null);
    }

    public Iterator getFieldIterator() {
        throw new UnsupportedOperationException("Method is not implemented.");
    }

    public boolean isInitial(String fieldName) {
        return this.isInitial(this.getFieldIndex(fieldName));
    }

    public Object getValue(String fieldName) {
        return this.getValue(this.getFieldIndex(fieldName));
    }

    public void setValue(String fieldName, Object value) {
        this.setValue(this.getFieldIndex(fieldName), value);
    }

    public final boolean isInitial(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        return null == this.getValueInternal(fieldIndex);
    }

    public final Object getValue(int fieldIndex) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(fieldIndex);
        }
        return TypeHelper.parse((String)this.getValueInternal(fieldIndex), type);
    }

    public final void setValue(int fieldIndex, Object value) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            throw new NoSuchMethodError("Method setValue() is not supported for variants.");
        }
        this.setStringValue(fieldIndex, TypeHelper.format(value, type));
    }

    public Object getValue(String fieldName, boolean createIfNull) {
        return this.getValue(this.getFieldIndex(fieldName), createIfNull);
    }

    public final Object getValue(int fieldIndex, boolean createIfNull) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(fieldIndex, createIfNull);
        }
        return TypeHelper.parse((String)this.getValueInternal(fieldIndex), type);
    }

    public int getIntValue(String fieldName) {
        return this.getIntValue(this.getFieldIndex(fieldName));
    }

    public void setIntValue(String fieldName, int value) {
        this.setIntValue(this.getFieldIndex(fieldName), value);
    }

    public final int getIntValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "INTEGER");
        return TypeHelper.getType("INTEGER").parseInt((String)this.getValueInternal(fieldIndex));
    }

    public final void setIntValue(int fieldIndex, int value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "INTEGER");
        this.setValueInternal(fieldIndex, TypeHelper.getType("INTEGER").format(value));
    }

    public boolean getBooleanValue(String fieldName) {
        return this.getBooleanValue(this.getFieldIndex(fieldName));
    }

    public void setBooleanValue(String fieldName, boolean value) {
        this.setBooleanValue(this.getFieldIndex(fieldName), value);
    }

    public final boolean getBooleanValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BOOLEAN");
        return TypeHelper.getType("BOOLEAN").parseBoolean((String)this.getValueInternal(fieldIndex));
    }

    public final void setBooleanValue(int fieldIndex, boolean value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BOOLEAN");
        this.setValueInternal(fieldIndex, TypeHelper.getType("BOOLEAN").format(value));
    }

    public double getDoubleValue(String fieldName) {
        return this.getDoubleValue(this.getFieldIndex(fieldName));
    }

    public void setDoubleValue(String fieldName, double value) {
        this.setDoubleValue(this.getFieldIndex(fieldName), value);
    }

    public final double getDoubleValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DOUBLE");
        return TypeHelper.getType("DOUBLE").parseDouble((String)this.getValueInternal(fieldIndex));
    }

    public final void setDoubleValue(int fieldIndex, double value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DOUBLE");
        this.setValueInternal(fieldIndex, TypeHelper.getType("DOUBLE").format(value));
    }

    public Date getDateValue(String fieldName) {
        return this.getDateValue(this.getFieldIndex(fieldName));
    }

    public void setDateValue(String fieldName, Date value) {
        this.setDateValue(this.getFieldIndex(fieldName), value);
    }

    public final Date getDateValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DATE");
        return (Date)TypeHelper.parse((String)this.getValueInternal(fieldIndex), "DATE");
    }

    public final void setDateValue(int fieldIndex, Date value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DATE");
        this.setValueInternal(fieldIndex, TypeHelper.format(value, "DATE"));
    }

    public Time getTimeValue(String fieldName) {
        return this.getTimeValue(this.getFieldIndex(fieldName));
    }

    public void setTimeValue(String fieldName, Time value) {
        this.setTimeValue(this.getFieldIndex(fieldName), value);
    }

    public final Time getTimeValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIME");
        return (Time)TypeHelper.parse((String)this.getValueInternal(fieldIndex), "TIME");
    }

    public final void setTimeValue(int fieldIndex, Time value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIME");
        this.setValueInternal(fieldIndex, TypeHelper.format(value, "TIME"));
    }

    public BigDecimal getDecimalValue(String fieldName) {
        return this.getDecimalValue(this.getFieldIndex(fieldName));
    }

    public void setDecimalValue(String fieldName, BigDecimal value) {
        this.setDecimalValue(this.getFieldIndex(fieldName), value);
    }

    public final BigDecimal getDecimalValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DECIMAL");
        return (BigDecimal)TypeHelper.parse((String)this.getValueInternal(fieldIndex), "DECIMAL");
    }

    public final void setDecimalValue(int fieldIndex, BigDecimal value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DECIMAL");
        this.setValueInternal(fieldIndex, TypeHelper.format(value, "DECIMAL"));
    }

    public Timestamp getTimestampValue(String fieldName) {
        return this.getTimestampValue(this.getFieldIndex(fieldName));
    }

    public void setTimestampValue(String fieldName, Timestamp value) {
        this.setTimestampValue(this.getFieldIndex(fieldName), value);
    }

    public final Timestamp getTimestampValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIMESTAMP");
        return (Timestamp)TypeHelper.parse((String)this.getValueInternal(fieldIndex), "TIMESTAMP");
    }

    public final void setTimestampValue(int fieldIndex, Timestamp value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIMESTAMP");
        this.setValueInternal(fieldIndex, TypeHelper.format(value, "TIMESTAMP"));
    }

    public byte[] getBinaryValue(String fieldName) {
        return this.getBinaryValue(this.getFieldIndex(fieldName));
    }

    public void setBinaryValue(String fieldName, byte[] value) {
        this.setBinaryValue(this.getFieldIndex(fieldName), value);
    }

    public final byte[] getBinaryValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BINARY");
        return (byte[])TypeHelper.parse((String)this.getValueInternal(fieldIndex), "BINARY");
    }

    public final void setBinaryValue(int fieldIndex, byte[] value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BINARY");
        this.setValueInternal(fieldIndex, TypeHelper.format(value, "BINARY"));
    }

    public final String getStringValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        String value = (String)this.getValueInternal(fieldIndex);
        return value == null ? "" : value;
    }

    public String getStringValue(String fieldName) {
        String value = (String)this.getValueInternal(this.getFieldIndex(fieldName));
        return value == null ? "" : value;
    }

    public final void setStringValue(int fieldIndex, String value) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        this.setValueInternal(fieldIndex, value);
    }

    public void setStringValue(String fieldName, String value) {
        this.setValueInternal(this.getFieldIndex(fieldName), value);
    }

    public final IEdoVariant getVariantValue(int fieldIndex) {
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "VARIANT");
        Object value = this.getValueInternal(fieldIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof IEdoVariant) {
            return (IEdoVariant)value;
        }
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        IEdoVariant variant = EdoVariant.convertXMLToVariant(fieldDescriptor, (String)value);
        this.setValueInternal(fieldIndex, variant);
        return variant;
    }

    public IEdoVariant getVariantValue(String fieldName) {
        return (IEdoVariant)this.getValueInternal(this.getFieldIndex(fieldName));
    }

    public final IEdoVariant getVariantValue(int fieldIndex, boolean createIfNull) {
        IEdoVariant value = this.getVariantValue(fieldIndex);
        if (value == null && createIfNull) {
            return this.newVariantValueInternal(fieldIndex);
        }
        return value;
    }

    public IEdoVariant getVariantValue(String fieldName, boolean createIfNull) {
        return this.getVariantValue(this.getFieldIndex(fieldName), createIfNull);
    }

    public void setCorrespondingFrom(IEdoStructure source) {
        int[] indices = DescriptorHelper.getCorrespondingIndices(((EdoStructure)source).m_descriptor, this.m_descriptor);
        int i = 0;
        int len = indices.length - 1;
        while (i < len) {
            Object[] srcRecord = ((EdoStructure)source).m_record;
            if (indices[i + 2] == 0) {
                this.m_record[indices[i + 1]] = srcRecord[indices[i]];
            } else {
                EdoAbstractValue value = (EdoAbstractValue)srcRecord[indices[i]];
                if (value != null) {
                    this.m_record[indices[i + 1]] = value.deepCopy();
                }
            }
            i += 3;
        }
    }

    public void setFrom(IEdoStructure source) {
        this.checkDescriptor(((EdoStructure)source).m_descriptor);
        Object[] srcRecord = ((EdoStructure)source).m_record;
        System.arraycopy(srcRecord, 0, this.m_record, 0, this.m_record.length);
        this.deepCopyFieldsThatNeedDeepCopy();
    }

    public void readFrom(IEdoReadStream readStream) {
        readStream.read(this);
    }

    public void writeTo(IEdoWriteStream writeStream) {
        writeStream.write(this);
    }

    final void clearInternal() {
        Arrays.fill(this.m_record, null);
    }

    final EdoVariant newVariantValueInternal(int fieldIndex) {
        EdoVariant value = new EdoVariant(this.m_descriptor.getFieldDescriptor(fieldIndex));
        this.m_record[fieldIndex] = value;
        return value;
    }

    final void setValueInternal(int fieldIndex, Object value) {
        this.m_record[fieldIndex] = value;
    }

    final Object getValueInternal(int fieldIndex) {
        return this.m_record[fieldIndex];
    }

    EdoAbstractValue deepCopy() {
        return new EdoStructure(this);
    }

    private void deepCopyFieldsThatNeedDeepCopy() {
        if (this.m_fieldsThatNeedDeepCopy == empty_fieldsThatNeedDeepCopy) {
            return;
        }
        if (this.m_fieldsThatNeedDeepCopy == null) {
            this.m_fieldsThatNeedDeepCopy = DescriptorHelper.getFieldsThatNeedDeepCopy(this.m_descriptor);
            if (this.m_fieldsThatNeedDeepCopy.length == 0) {
                this.m_fieldsThatNeedDeepCopy = empty_fieldsThatNeedDeepCopy;
                return;
            }
        }
        int i = 0;
        int len = this.m_fieldsThatNeedDeepCopy.length;
        while (i < len) {
            int index = this.m_fieldsThatNeedDeepCopy[i];
            EdoAbstractValue value = (EdoAbstractValue)this.m_record[index];
            if (value != null) {
                this.m_record[index] = value.deepCopy();
            }
            ++i;
        }
    }

    private int getFieldIndex(String fieldName) {
        int fieldIndex = this.m_descriptor.getFieldIndex(fieldName);
        if (0 > fieldIndex) {
            throw new IllegalArgumentException("Field name '" + fieldName + "' not found in structure '" + this.m_descriptor.getName() + "'.");
        }
        return fieldIndex;
    }

    private void checkFieldIndex(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.m_record.length) {
            throw new IndexOutOfBoundsException("Field index " + fieldIndex + " out of range. Should be >= 0 and < " + this.m_record.length);
        }
    }

    private void checkDescriptor(IStructureDescriptor descriptor) {
        if (!this.m_descriptor.equals(descriptor)) {
            throw new IllegalArgumentException("Different Structure type: expected '" + this.m_descriptor.getName() + "' found '" + descriptor.getName() + "'.");
        }
    }

    private void checkFieldType(int fieldIndex, String type) {
        boolean typeInvalid = false;
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        if (type.equals("VARIANT") && !type.equals(fieldDescriptor.getType())) {
            typeInvalid = true;
        } else if (type.equals("STRING") && fieldDescriptor.getType().equals("VARIANT")) {
            typeInvalid = true;
        }
        if (typeInvalid) {
            throw new IllegalArgumentException("Different Field type : expected '" + type + "' found '" + fieldDescriptor.getType() + "'.");
        }
    }

    private String getFieldType(int fieldIndex) {
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        return fieldDescriptor.getType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/EdoStructure.java#1 $");
        empty_fieldsThatNeedDeepCopy = new int[0];
    }
}

