/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.edo.core;

import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoIndexTable;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.EdoAbstractValue;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;

public class EdoIndexTable
extends EdoAbstractValue
implements IEdoIndexTable {
    private static final Location _location = Location.getLocation((Class)(class$com$sap$tc$col$edo$core$EdoIndexTable == null ? (class$com$sap$tc$col$edo$core$EdoIndexTable = EdoIndexTable.class$("com.sap.tc.col.edo.core.EdoIndexTable")) : class$com$sap$tc$col$edo$core$EdoIndexTable));
    private static final int[] EMPTY;
    private static final String INDEX_CANNOT_BE_NEGATIVE = "Index has to be greater than or equal to 0.";
    protected final int m_srcFieldIndex;
    protected final int m_relFieldIndex;
    protected final IStructureDescriptor m_descriptor;
    protected final ArrayList m_table;
    static /* synthetic */ Class class$com$sap$tc$col$edo$core$EdoIndexTable;

    public EdoIndexTable(IStructureDescriptor descriptor, int srcFieldIndex, int relFieldIndex) {
        this.m_descriptor = descriptor;
        this.m_table = new ArrayList();
        this.m_srcFieldIndex = srcFieldIndex;
        this.m_relFieldIndex = relFieldIndex;
    }

    public EdoIndexTable(IStructureDescriptor descriptor, String srcFieldName, String relFieldName) {
        this(descriptor, descriptor.getFieldIndex(srcFieldName), descriptor.getFieldIndex(relFieldName));
    }

    private EdoIndexTable(EdoIndexTable table) {
        this.m_descriptor = table.m_descriptor;
        this.m_srcFieldIndex = table.m_srcFieldIndex;
        this.m_relFieldIndex = table.m_relFieldIndex;
        this.m_table = (ArrayList)table.m_table.clone();
        int i = 0;
        int len = this.m_table.size();
        while (i < len) {
            int[] value = (int[])this.m_table.get(i);
            if (value != null) {
                this.m_table.set(i, value.clone());
            }
            ++i;
        }
    }

    public int[] getRelatedIndexes(int srcIndex) {
        int len;
        int[] indexes;
        int[] retVal = EMPTY;
        if (srcIndex < 0) {
            throw new IndexOutOfBoundsException(INDEX_CANNOT_BE_NEGATIVE);
        }
        if (srcIndex < this.m_table.size() && (indexes = (int[])this.m_table.get(srcIndex)) != null && (len = indexes[0]) > 0) {
            retVal = new int[len];
            System.arraycopy(indexes, 1, retVal, 0, len);
        }
        return retVal;
    }

    public void addRelatedIndex(int srcIndex, int relIndex) {
        if (srcIndex < 0) {
            throw new IndexOutOfBoundsException(INDEX_CANNOT_BE_NEGATIVE);
        }
        this.addRelatedIndexInternal(srcIndex, relIndex);
    }

    public void removeRelatedIndex(int srcIndex, int relIndex) {
        int[] indexes;
        if (srcIndex < 0) {
            throw new IndexOutOfBoundsException(INDEX_CANNOT_BE_NEGATIVE);
        }
        if (srcIndex < this.m_table.size() && (indexes = (int[])this.m_table.get(srcIndex)) != null) {
            int i = 1;
            int len = indexes[0];
            while (i <= len) {
                if (indexes[i] == relIndex) {
                    if (i < len) {
                        System.arraycopy(indexes, i + 1, indexes, i, len - i);
                    }
                    indexes[0] = --len;
                    break;
                }
                ++i;
            }
        }
    }

    public void removeRelatedIndexes(int srcIndex) {
        int[] indexes;
        if (srcIndex < 0) {
            throw new IndexOutOfBoundsException(INDEX_CANNOT_BE_NEGATIVE);
        }
        if (srcIndex < this.m_table.size() && (indexes = (int[])this.m_table.get(srcIndex)) != null) {
            this.m_table.set(srcIndex, null);
        }
    }

    public String getType() {
        return this.m_descriptor.getName();
    }

    public String getMeta() {
        return "T";
    }

    public void clear() {
        this.m_table.clear();
    }

    public void writeTo(IEdoWriteStream writeStream) {
        writeStream.write(this);
    }

    public void readFrom(IEdoReadStream readStream) {
        readStream.read(this);
    }

    void clearInternal() {
        this.m_table.clear();
    }

    void addRelatedIndexInternal(int srcIndex, int relIndex) {
        int nextIndex;
        int[] indexes;
        int size = this.m_table.size();
        int[] nArray = indexes = srcIndex < size ? (int[])this.m_table.get(srcIndex) : null;
        if (indexes == null) {
            indexes = new int[4];
            indexes[0] = 0;
            if (srcIndex >= size) {
                this.m_table.addAll(Collections.nCopies(srcIndex - size + 1, null));
            }
            this.m_table.set(srcIndex, indexes);
        }
        if ((nextIndex = (indexes[0] = indexes[0] + 1)) >= indexes.length) {
            int[] newIndexes = new int[indexes.length * 2];
            System.arraycopy(indexes, 0, newIndexes, 0, indexes.length);
            indexes = newIndexes;
            this.m_table.set(srcIndex, indexes);
        }
        indexes[nextIndex] = relIndex;
    }

    EdoAbstractValue deepCopy() {
        return new EdoIndexTable(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.col.edo.core").infoT("$Id: //tc/Cool/630_VAL_REL/src/_col_edo/java/_core/com/sap/tc/col/edo/core/EdoIndexTable.java#1 $");
        EMPTY = new int[0];
    }
}

