/*
 * Decompiled with CFR 0.152.
 */
package flexlm;

import com.certicom.ecc.jcae.Certicom;
import com.certicom.ecc.system.SystemConfig;
import flexlm.VendorInfo;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class l_prikey {
    static final String CVSId = "$Id";
    protected static String certicomName;
    protected static final String signatureAlgorithmName = "ECDSA";

    protected static String initCerticom() {
        if (certicomName != null) {
            return certicomName;
        }
        Certicom certicom = new Certicom();
        if (Security.addProvider((Provider)certicom) < 0) {
            return null;
        }
        certicomName = certicom.getName();
        return certicomName;
    }

    public static int l_pubkey_verify(byte[] byArray, byte[] byArray2, VendorInfo vendorInfo, int n) {
        boolean bl;
        PublicKey publicKey;
        KeyFactory keyFactory;
        String string;
        String string2 = l_prikey.initCerticom();
        if (string2 == null) {
            System.out.println("No Certicom module available");
            return -1;
        }
        switch (n) {
            case 2: {
                string = "sect113r1";
                break;
            }
            case 3: {
                string = "ec163a02";
                break;
            }
            case 4: {
                string = "ec239a03";
                break;
            }
            default: {
                System.out.println("No curve available for strength " + n);
                return -1;
            }
        }
        SystemConfig systemConfig = SystemConfig.getConfig();
        systemConfig.setCurve(string);
        systemConfig.setConformance(16);
        systemConfig.setPtCompression(2);
        systemConfig.setFormat(10);
        PublicKey publicKey2 = vendorInfo.getPublicKey(n);
        if (publicKey2 == null) {
            System.out.println("No public key availble for strength " + n);
            return -1;
        }
        byte[] byArray3 = publicKey2.getEncoded();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray3);
        try {
            keyFactory = KeyFactory.getInstance(signatureAlgorithmName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("KeyFactory NoSuchAlgorithmException");
            return -1;
        }
        try {
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.out.println("KeyFactory InvalidKeySpecException");
            return -1;
        }
        try {
            Signature signature = Signature.getInstance(signatureAlgorithmName, string2);
            signature.initVerify(publicKey);
            signature.update(byArray);
            bl = signature.verify(byArray2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            System.out.println("NoSuchProviderException");
            return -1;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("NoSuchAlgorithmException");
            return -1;
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("InvalidKeyException");
            return -1;
        }
        catch (SignatureException signatureException) {
            System.out.println("SignatureException");
            return -1;
        }
        return bl ? 0 : -1;
    }

    public static void printBytes(String string, byte[] byArray) {
        System.out.print(String.valueOf(string) + " = { ");
        l_prikey.printBytes(byArray);
        System.out.println(" }");
    }

    public static void printBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            System.out.print(Integer.toString(byArray[n] & 0xFF, 16));
            System.out.print(" ");
            ++n;
        }
    }
}

