/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.variable;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.group.IGroupDialogPage;
import org.eclipse.ui.externaltools.internal.variable.AbstractVariableComponent;
import org.eclipse.ui.externaltools.internal.variable.ExternalToolsVariableMessages;

public class WorkingSetComponent
extends AbstractVariableComponent {
    private TableViewer viewer;
    private static ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof IWorkingSet) {
                return ((IWorkingSet)element).getName();
            }
            return super.getText(element);
        }
    };
    private static IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    public Control getControl() {
        return this.mainGroup;
    }

    public void createContents(Composite parent, String varTag, IGroupDialogPage page) {
        super.createContents(parent, varTag, page);
        this.viewer = new TableViewer((Composite)this.mainGroup);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setInput((Object)PlatformUI.getWorkbench());
        GridData data = new GridData(1808);
        this.viewer.getTable().setLayoutData((Object)data);
    }

    public String getVariableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IWorkingSet) {
            return ((IWorkingSet)element).getName();
        }
        return null;
    }

    public void setVariableValue(String varValue) {
        TableItem[] items = this.viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (((IWorkingSet)items[i].getData()).getName().equals(varValue)) {
                this.viewer.setSelection((ISelection)new StructuredSelection(items[i].getData()));
                break;
            }
            ++i;
        }
    }

    public void validate() {
        boolean isValid;
        boolean bl = isValid = this.getVariableValue() != null;
        if (isValid) {
            this.getPage().setErrorMessage(null);
        } else {
            this.getPage().setErrorMessage(ExternalToolsVariableMessages.getString("WorkingSetComponent.Must_Select"));
        }
        this.setIsValid(isValid);
        this.getPage().updateValidState();
    }
}

