/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.variable;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.externaltools.internal.variable.DefaultVariableExpander;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;
import org.eclipse.ui.externaltools.internal.variable.ExternalToolsVariableMessages;

public class ResourceExpander
extends DefaultVariableExpander {
    IResource expand(String varValue, ExpandVariableContext context) {
        if (varValue != null && varValue.length() > 0) {
            return this.expandToMember(varValue);
        }
        return this.expandUsingContext(context);
    }

    IResource expandUsingContext(ExpandVariableContext context) {
        return context.getSelectedResource();
    }

    IResource expandToMember(String varValue) {
        return this.getWorkspaceRoot().findMember(varValue);
    }

    public IPath getPath(String varTag, String varValue, ExpandVariableContext context) throws CoreException {
        IResource resource = this.expand(varValue, context);
        if (resource != null) {
            if (this.isPathVariable(varTag)) {
                return resource.getFullPath();
            }
            return resource.getLocation();
        }
        DefaultVariableExpander.throwExpansionException(varTag, ExternalToolsVariableMessages.getString("ResourceExpander.No_resource"));
        return null;
    }

    private boolean isPathVariable(String varTag) {
        return varTag.equals("container_path") || varTag.equals("project_path") || varTag.equals("resource_path");
    }

    public IResource[] getResources(String varTag, String varValue, ExpandVariableContext context) throws CoreException {
        IResource resource = this.expand(varValue, context);
        if (resource != null) {
            return new IResource[]{resource};
        }
        DefaultVariableExpander.throwExpansionException(varTag, ExternalToolsVariableMessages.getString("ResourceExpander.No_resource"));
        return null;
    }

    protected final IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getText(String varTag, String varValue, ExpandVariableContext context) throws CoreException {
        IPath path = this.getPath(varTag, varValue, context);
        if (path != null) {
            return path.toOSString();
        }
        DefaultVariableExpander.throwExpansionException(varTag, ExternalToolsVariableMessages.getString("ResourceExpander.No_resource"));
        return null;
    }
}

