/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.variable;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.externaltools.internal.group.IGroupDialogPage;
import org.eclipse.ui.externaltools.internal.variable.AbstractVariableComponent;
import org.eclipse.ui.externaltools.internal.variable.ExternalToolsVariableMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceComponent
extends AbstractVariableComponent {
    protected Button selectedResourceButton;
    protected Button specificResourceButton;
    protected TreeViewer resourceList;
    private IResource selectedResource;
    private boolean selectedResourceVariable = true;

    public void createContents(Composite parent, String varTag, IGroupDialogPage page) {
        super.createContents(parent, varTag, page);
        this.createSelectedResourceOption();
        this.createSpecificResourceOption();
        this.createResourceList();
        this.updateResourceListEnablement();
    }

    protected void createResourceList() {
        Tree tree = new Tree((Composite)this.mainGroup, 2052);
        GridData data = new GridData(1808);
        data.heightHint = tree.getItemHeight() * 8;
        tree.setLayoutData((Object)data);
        tree.setFont(this.mainGroup.getFont());
        this.resourceList = new TreeViewer(tree);
        this.resourceList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceComponent.this.selectedResource = (IResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                ResourceComponent.this.validate();
            }
        });
        this.resourceList.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.resourceList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.resourceList.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
    }

    private void createSelectedResourceOption() {
        this.selectedResourceButton = new Button((Composite)this.mainGroup, 16);
        this.selectedResourceButton.setText(ExternalToolsVariableMessages.getString("ResourceComponent.selectedResLabel"));
        GridData data = new GridData(256);
        this.selectedResourceButton.setLayoutData((Object)data);
        this.selectedResourceButton.setFont(this.mainGroup.getFont());
        this.selectedResourceButton.setSelection(true);
    }

    private void createSpecificResourceOption() {
        this.specificResourceButton = new Button((Composite)this.mainGroup, 16);
        this.specificResourceButton.setText(ExternalToolsVariableMessages.getString("ResourceComponent.specificResLabel"));
        GridData data = new GridData(256);
        this.specificResourceButton.setLayoutData((Object)data);
        this.specificResourceButton.setFont(this.mainGroup.getFont());
        this.specificResourceButton.setSelection(false);
        this.specificResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceComponent.this.updateResourceListEnablement();
                ResourceComponent.this.getPage().updateValidState();
                ResourceComponent.this.selectedResourceVariable = !ResourceComponent.this.specificResourceButton.getSelection();
            }
        });
    }

    public Control getControl() {
        return this.mainGroup;
    }

    public String getVariableValue() {
        if (this.selectedResourceVariable) {
            return null;
        }
        if (this.resourceList != null && this.selectedResource != null) {
            return this.selectedResource.getFullPath().toString();
        }
        return null;
    }

    private void updateResourceListEnablement() {
        if (this.specificResourceButton != null && this.resourceList != null) {
            this.resourceList.getTree().setEnabled(this.specificResourceButton.getSelection());
            this.validate();
        }
    }

    public void setVariableValue(String varValue) {
        if (varValue == null || varValue.length() == 0) {
            if (this.selectedResourceButton != null) {
                this.selectedResourceButton.setSelection(true);
            }
            if (this.specificResourceButton != null) {
                this.specificResourceButton.setSelection(false);
            }
            if (this.resourceList != null) {
                this.resourceList.getTree().setEnabled(false);
            }
        } else {
            if (this.selectedResourceButton != null) {
                this.selectedResourceButton.setSelection(false);
            }
            if (this.specificResourceButton != null) {
                this.specificResourceButton.setSelection(true);
            }
            if (this.resourceList != null) {
                this.resourceList.getTree().setEnabled(true);
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(varValue);
                if (member != null) {
                    this.resourceList.setSelection((ISelection)new StructuredSelection((Object)member), true);
                } else {
                    this.resourceList.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        }
    }

    public void validate() {
        this.getPage().setErrorMessage(null);
        this.setIsValid(true);
        if (this.specificResourceButton != null && this.specificResourceButton.getSelection()) {
            this.validateResourceListSelection();
        }
        this.getPage().updateValidState();
    }

    private void validateResourceListSelection() {
        if (this.resourceList == null) {
            return;
        }
        if (this.resourceList.getSelection().isEmpty()) {
            this.getPage().setErrorMessage(ExternalToolsVariableMessages.getString("ResourceComponent.selectionRequired"));
            this.setIsValid(false);
        }
    }
}

