/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolMigration;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;
import org.eclipse.ui.externaltools.internal.ui.MessageDialogWithToggle;
import org.eclipse.ui.help.WorkbenchHelp;

public final class BuilderPropertyPage
extends PropertyPage {
    private static final int BUILDER_TABLE_WIDTH = 250;
    private static final String IMG_BUILDER = "icons/full/obj16/builder.gif";
    private static final String IMG_INVALID_BUILD_TOOL = "icons/full/obj16/invalid_build_tool.gif";
    private static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    private static final String TAG_CONFIGURATION_MAP = "configurationMap";
    private static final String TAG_SOURCE_TYPE = "sourceType";
    private static final String TAG_BUILDER_TYPE = "builderType";
    private Table builderTable;
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button copyButton;
    private Button editButton;
    private Button removeButton;
    private List imagesToDispose = new ArrayList();
    private Image builderImage;
    private Image invalidBuildToolImage;
    private IDebugModelPresentation debugModelPresentation;
    private boolean userHasMadeChanges = false;
    private List configsToBeDeleted = null;
    private List newConfigList = new ArrayList();
    private SelectionListener fButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BuilderPropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private ILaunchConfigurationListener configurationListener = new ILaunchConfigurationListener(){

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration oldConfig = manager.getMovedFrom(configuration);
            if (oldConfig == null) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(this, oldConfig, configuration){
                private final /* synthetic */ 2 this$1;
                private final /* synthetic */ ILaunchConfiguration val$oldConfig;
                private final /* synthetic */ ILaunchConfiguration val$configuration;
                {
                    this.this$1 = var1_1;
                    this.val$oldConfig = iLaunchConfiguration;
                    this.val$configuration = iLaunchConfiguration2;
                }

                public void run() {
                    TableItem[] items = BuilderPropertyPage.access$1(2.access$0(this.this$1)).getItems();
                    int i = 0;
                    while (i < items.length) {
                        TableItem item = items[i];
                        Object data = item.getData();
                        if (data == this.val$oldConfig) {
                            item.setData((Object)this.val$configuration);
                            BuilderPropertyPage.access$2(2.access$0(this.this$1), item, this.val$configuration);
                            break;
                        }
                        ++i;
                    }
                    if (BuilderPropertyPage.access$3(2.access$0(this.this$1)).remove(this.val$oldConfig)) {
                        BuilderPropertyPage.access$3(2.access$0(this.this$1)).add(this.val$configuration);
                    }
                }
            });
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        }

        static /* synthetic */ BuilderPropertyPage access$0(2 var0) {
            return var0.BuilderPropertyPage.this;
        }
    };
    static /* synthetic */ Class class$0;

    public BuilderPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    private void addBuildersToTable() {
        IProject project = this.getInputProject();
        if (project == null) {
            return;
        }
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                ILaunchConfiguration config = ExternalToolsUtil.configFromBuildCommandArgs(commands[i].getArguments());
                if (config != null) {
                    if (!config.isWorkingCopy() && !config.exists()) {
                        Status status = new Status(4, "org.eclipse.ui.externaltools", 0, MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.Exists"), config.getLocation().toOSString()), null);
                        ErrorDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorTitle"), (String)MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.External_Tool_Builder_{0}_Not_Added_2"), config.getName()), (IStatus)status);
                        this.userHasMadeChanges = true;
                    } else {
                        this.addConfig(config, false);
                    }
                } else {
                    String builderID = commands[i].getBuilderName();
                    if (builderID.equals("org.eclipse.ui.externaltools.ExternalToolBuilder") && commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE) != null) {
                        this.addErrorConfig(new ErrorConfig(), -1, false);
                    } else {
                        this.addCommand(commands[i], -1, false);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private void addCommand(ICommand command, int position, boolean select) {
        TableItem newItem = position < 0 ? new TableItem(this.builderTable, 0) : new TableItem(this.builderTable, 0, position);
        newItem.setData((Object)command);
        this.updateCommandItem(newItem, command);
        if (select) {
            this.builderTable.setSelection(position);
        }
    }

    private void addErrorConfig(ErrorConfig config, int position, boolean select) {
        TableItem newItem = position < 0 ? new TableItem(this.builderTable, 0) : new TableItem(this.builderTable, 0, position);
        newItem.setData((Object)config);
        newItem.setText(ExternalToolsUIMessages.getString("BuilderPropertyPage.invalidBuildTool"));
        newItem.setImage(this.invalidBuildToolImage);
        if (select) {
            this.builderTable.setSelection(position);
        }
    }

    private void addConfig(ILaunchConfiguration config, boolean select) {
        TableItem newItem = new TableItem(this.builderTable, 0);
        newItem.setData((Object)config);
        this.updateConfigItem(newItem, config);
        if (select) {
            this.builderTable.setSelection(this.builderTable.getItemCount());
        }
    }

    private void updateConfigItem(TableItem item, ILaunchConfiguration config) {
        item.setText(config.getName());
        Image configImage = this.debugModelPresentation.getImage((Object)config);
        if (configImage == null) {
            configImage = this.builderImage;
        }
        item.setImage(configImage);
    }

    private ICommand toBuildCommand(ILaunchConfiguration config, ICommand command) throws CoreException {
        Map<String, String> args = null;
        if (config instanceof ILaunchConfigurationWorkingCopy && ((ILaunchConfigurationWorkingCopy)config).getLocation() == null) {
            ICommand[] commands = this.getInputProject().getDescription().getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                ICommand projectCommand = commands[i];
                String name = ExternalToolMigration.getNameFromCommandArgs(projectCommand.getArguments());
                if (name != null && name.equals(config.getName())) {
                    args = projectCommand.getArguments();
                    break;
                }
                ++i;
            }
        }
        if (args == null) {
            args = new HashMap<String, String>();
            args.put(LAUNCH_CONFIG_HANDLE, config.getMemento());
        }
        command.setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        command.setArguments(args);
        return command;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.fButtonListener);
        return button;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        this.debugModelPresentation = DebugUITools.newDebugModelPresentation();
        this.builderImage = ExternalToolsPlugin.getDefault().getImageDescriptor(IMG_BUILDER).createImage();
        this.invalidBuildToolImage = ExternalToolsPlugin.getDefault().getImageDescriptor(IMG_INVALID_BUILD_TOOL).createImage();
        this.imagesToDispose.add(this.builderImage);
        this.imagesToDispose.add(this.invalidBuildToolImage);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(1808));
        Label description = new Label(topLevel, 64);
        description.setText(ExternalToolsUIMessages.getString("BuilderPropertyPage.description"));
        description.setLayoutData((Object)new GridData(768));
        description.setFont(font);
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.builderTable = new Table(tableAndButtons, 68356);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        this.builderTable.setLayoutData((Object)data);
        this.builderTable.setFont(font);
        this.builderTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuilderPropertyPage.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.newButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.newButton"));
        this.copyButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.&Copy..._3"));
        this.editButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.editButton"));
        this.removeButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.removeButton"));
        new Label(buttonArea, 16384);
        this.upButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.upButton"));
        this.downButton = this.createButton(buttonArea, ExternalToolsUIMessages.getString("BuilderPropertyPage.downButton"));
        this.newButton.setEnabled(true);
        this.copyButton.setEnabled(true);
        this.addBuildersToTable();
        return topLevel;
    }

    public void dispose() {
        super.dispose();
        Iterator i = this.imagesToDispose.iterator();
        while (i.hasNext()) {
            Image image = (Image)i.next();
            image.dispose();
        }
        this.imagesToDispose.clear();
    }

    private void setAutobuild(boolean newState) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = workspace.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            workspace.setDescription(wsDescription);
        }
    }

    private IProject getInputProject() {
        Object resource;
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = element.getAdapter((Class)clazz)) instanceof IProject) {
            return (IProject)resource;
        }
        return null;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.newButton) {
            this.handleNewButtonPressed();
        } else if (button == this.copyButton) {
            this.handleCopyButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        }
        this.handleTableSelectionChanged();
        this.builderTable.setFocus();
    }

    private void handleCopyButtonPressed() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List toolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools");
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        Iterator iter = toolTypes.iterator();
        while (iter.hasNext()) {
            try {
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations((ILaunchConfigurationType)iter.next());
                int i = 0;
                while (i < configs.length) {
                    configurations.add(configs[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)this.debugModelPresentation);
        dialog.setTitle(ExternalToolsUIMessages.getString("BuilderPropertyPage.Copy_configuration_4"));
        dialog.setMessage(ExternalToolsUIMessages.getString("BuilderPropertyPage.&Choose_a_configuration_to_copy__5"));
        dialog.setElements(configurations.toArray());
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results.length == 0) {
            return;
        }
        ILaunchConfiguration config = (ILaunchConfiguration)results[0];
        ILaunchConfiguration newConfig = null;
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            try {
                this.setAutobuild(false);
                newConfig = this.duplicateConfiguration(config);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
            throw throwable;
        }
        Object var11_14 = null;
        try {
            this.setAutobuild(wasAutobuilding);
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        if (newConfig != null) {
            this.userHasMadeChanges = true;
            this.addConfig(newConfig, true);
            this.newConfigList.add(newConfig);
        }
    }

    private ILaunchConfiguration duplicateConfiguration(ILaunchConfiguration config) throws CoreException {
        Map attributes = null;
        attributes = config.getAttributes();
        String newName = String.valueOf(config.getName()) + ExternalToolsUIMessages.getString("BuilderPropertyPage._[Builder]_6");
        newName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(newName);
        ILaunchConfigurationType newType = this.getConfigurationDuplicationType(config);
        ILaunchConfigurationWorkingCopy newWorkingCopy = newType.newInstance((IContainer)this.getBuilderFolder(true), newName);
        newWorkingCopy.setAttributes(attributes);
        return newWorkingCopy.doSave();
    }

    private ILaunchConfigurationType getConfigurationDuplicationType(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationType type;
        IExtensionPoint ep = ExternalToolsPlugin.getDefault().getDescriptor().getExtensionPoint("configurationDuplicationMaps");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        String sourceType = config.getType().getIdentifier();
        String builderType = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_CONFIGURATION_MAP) && sourceType.equals(element.getAttribute(TAG_SOURCE_TYPE))) {
                builderType = element.getAttribute(TAG_BUILDER_TYPE);
                break;
            }
            ++i;
        }
        if (builderType != null && (type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(builderType)) != null) {
            return type;
        }
        return config.getType();
    }

    private void handleRemoveButtonPressed() {
        TableItem[] selection = this.builderTable.getSelection();
        if (selection != null) {
            if (this.configsToBeDeleted == null) {
                this.configsToBeDeleted = new ArrayList(selection.length);
            }
            this.userHasMadeChanges = true;
            int i = 0;
            while (i < selection.length) {
                Object data = selection[i].getData();
                if (data instanceof ILaunchConfiguration) {
                    this.configsToBeDeleted.add(data);
                }
                selection[i].dispose();
                ++i;
            }
        }
    }

    private void handleNewButtonPressed() {
        boolean wasAutobuilding;
        block9: {
            ILaunchConfigurationType type = this.promptForConfigurationType();
            if (type == null) {
                return;
            }
            wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
            try {
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = null;
                    String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(ExternalToolsUIMessages.getString("BuilderPropertyPage.New_Builder_7"));
                    workingCopy = type.newInstance((IContainer)this.getBuilderFolder(true), name);
                    workingCopy.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, "perspective_none");
                    StringBuffer buffer = new StringBuffer("full");
                    buffer.append(',');
                    buffer.append("incremental");
                    buffer.append(',');
                    workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
                    ILaunchConfiguration config = null;
                    this.setAutobuild(false);
                    config = workingCopy.doSave();
                    this.newConfigList.add(config);
                    int code = this.editConfiguration(config);
                    if (code == 1) {
                        this.newConfigList.remove(config);
                        config.delete();
                        break block9;
                    }
                    this.userHasMadeChanges = true;
                    this.addConfig((ILaunchConfiguration)this.newConfigList.get(this.newConfigList.size() - 1), true);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
                throw throwable;
            }
        }
        Object var8_11 = null;
        try {
            this.setAutobuild(wasAutobuilding);
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private int editConfiguration(ILaunchConfiguration config) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchConfigurationListener(this.configurationListener);
        int code = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.getShell(), (ILaunchConfiguration)config, (String)"org.eclipse.ui.externaltools.launchGroup.builder");
        manager.removeLaunchConfigurationListener(this.configurationListener);
        return code;
    }

    private ILaunchConfigurationType promptForConfigurationType() {
        List externalToolTypes = this.getConfigurationTypes("org.eclipse.ui.externaltools.builder");
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)this.debugModelPresentation);
        dialog.setElements(externalToolTypes.toArray());
        dialog.setMultipleSelection(false);
        dialog.setTitle(ExternalToolsUIMessages.getString("BuilderPropertyPage.Choose_configuration_type_8"));
        dialog.setMessage(ExternalToolsUIMessages.getString("BuilderPropertyPage.Choose_an_external_tool_type_to_create_9"));
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (ILaunchConfigurationType)result[0];
    }

    private List getConfigurationTypes(String category) {
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        ArrayList<ILaunchConfigurationType> externalToolTypes = new ArrayList<ILaunchConfigurationType>();
        int i = 0;
        while (i < types.length) {
            ILaunchConfigurationType configurationType = types[i];
            if (category.equals(configurationType.getCategory())) {
                externalToolTypes.add(configurationType);
            }
            ++i;
        }
        return externalToolTypes;
    }

    private void handleEditButtonPressed() {
        block12: {
            Object data;
            TableItem selection = this.builderTable.getSelection()[0];
            if (selection == null || !((data = selection.getData()) instanceof ILaunchConfiguration)) break block12;
            ILaunchConfiguration config = (ILaunchConfiguration)data;
            if (data instanceof ILaunchConfigurationWorkingCopy) {
                if (!this.shouldProceedWithMigration()) {
                    return;
                }
                try {
                    config = this.migrateBuilderConfiguration((ILaunchConfigurationWorkingCopy)data);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                    return;
                }
                selection.setData((Object)config);
            }
            this.userHasMadeChanges = true;
            boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
            try {
                try {
                    this.setAutobuild(false);
                    this.editConfiguration(config);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.setAutobuild(wasAutobuilding);
                }
                catch (CoreException e) {
                    this.handleException((Exception)((Object)e));
                }
                throw throwable;
            }
            Object var6_9 = null;
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private ILaunchConfiguration migrateBuilderConfiguration(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IStatus status;
        workingCopy.setContainer((IContainer)this.getBuilderFolder(true));
        String name = workingCopy.getName();
        name.replace('/', '.');
        if (name.charAt(0) == '.') {
            name = name.substring(1);
        }
        if (!(status = ResourcesPlugin.getWorkspace().validateName(name, 1)).isOK()) {
            name = "ExternalTool";
        }
        name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
        workingCopy.rename(name);
        return workingCopy.doSave();
    }

    private boolean shouldProceedWithMigration() {
        if (!ExternalToolsPlugin.getDefault().getPreferenceStore().getBoolean("externaltools.builders.promptForMigration")) {
            return true;
        }
        return MessageDialogWithToggle.openQuestion(this.getShell(), ExternalToolsUIMessages.getString("BuilderPropertyPage.Migrate_project_builder_10"), ExternalToolsUIMessages.getString("BuilderPropertyPage.Not_Support"), "externaltools.builders.promptForMigration", ExternalToolsUIMessages.getString("BuilderPropertyPage.Prompt"), ExternalToolsPlugin.getDefault().getPreferenceStore());
    }

    private IFolder getBuilderFolder(boolean create) {
        IFolder folder = this.getInputProject().getFolder(".externalToolBuilders");
        if (!folder.exists() && create) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return folder;
    }

    private void handleException(Exception e) {
        Object status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, "org.eclipse.ui.externaltools", 0, ExternalToolsUIMessages.getString("BuilderPropertyPage.statusMessage"), (Throwable)e);
        ErrorDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorTitle"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.errorMessage"), (IStatus)status);
    }

    private void handleTableSelectionChanged() {
        this.newButton.setEnabled(true);
        TableItem[] items = this.builderTable.getSelection();
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        if (items != null && items.length == 1) {
            TableItem item = items[0];
            Object data = item.getData();
            if (data instanceof ILaunchConfiguration) {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                int selection = this.builderTable.getSelectionIndex();
                int max = this.builderTable.getItemCount();
                this.upButton.setEnabled(selection != 0);
                this.downButton.setEnabled(selection < max - 1);
            } else if (data instanceof ErrorConfig) {
                this.removeButton.setEnabled(true);
            }
        }
    }

    private void move(TableItem item, int index) {
        this.userHasMadeChanges = true;
        Object data = item.getData();
        String text = item.getText();
        Image image = item.getImage();
        item.dispose();
        TableItem newItem = new TableItem(this.builderTable, 0, index);
        newItem.setData(data);
        newItem.setText(text);
        newItem.setImage(image);
    }

    private void moveSelectionDown() {
        int currentIndex;
        if (this.builderTable.getSelectionCount() == 1 && (currentIndex = this.builderTable.getSelectionIndex()) < this.builderTable.getItemCount() - 1) {
            this.move(this.builderTable.getItem(currentIndex), currentIndex + 1);
            this.builderTable.setSelection(currentIndex + 1);
        }
    }

    private void moveSelectionUp() {
        int currentIndex = this.builderTable.getSelectionIndex();
        if (currentIndex > 0 && this.builderTable.getSelectionCount() == 1) {
            this.move(this.builderTable.getItem(currentIndex), currentIndex - 1);
            this.builderTable.setSelection(currentIndex - 1);
        }
    }

    public boolean performOk() {
        if (!this.userHasMadeChanges) {
            return super.performOk();
        }
        this.userHasMadeChanges = false;
        if (this.configsToBeDeleted != null) {
            this.deleteConfigurations();
        }
        IProject project = this.getInputProject();
        int numCommands = this.builderTable.getItemCount();
        ICommand[] commands = new ICommand[numCommands];
        int i = 0;
        while (i < numCommands) {
            Object data = this.builderTable.getItem(i).getData();
            if (!(data instanceof ICommand) && data instanceof ILaunchConfiguration) {
                ICommand newCommand = null;
                try {
                    newCommand = project.getDescription().newCommand();
                    data = this.toBuildCommand((ILaunchConfiguration)data, newCommand);
                }
                catch (CoreException coreException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.Command_error_13"), (String)ExternalToolsUIMessages.getString("BuilderPropertyPage.error"));
                    return true;
                }
            }
            commands[i] = (ICommand)data;
            ++i;
        }
        if (this.checkCommandsForChange(commands)) {
            try {
                IProjectDescription desc = project.getDescription();
                desc.setBuildSpec(commands);
                project.setDescription(desc, 1, null);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return super.performOk();
    }

    private void deleteConfigurations() {
        boolean wasAutobuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        try {
            try {
                this.setAutobuild(false);
                Iterator itr = this.configsToBeDeleted.iterator();
                while (itr.hasNext()) {
                    ILaunchConfiguration element = (ILaunchConfiguration)itr.next();
                    element.delete();
                }
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this.setAutobuild(wasAutobuilding);
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
            throw throwable;
        }
        Object var4_7 = null;
        try {
            this.setAutobuild(wasAutobuilding);
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private boolean checkCommandsForChange(ICommand[] newCommands) {
        try {
            ICommand[] oldCommands = this.getInputProject().getDescription().getBuildSpec();
            if (oldCommands.length != newCommands.length) {
                return true;
            }
            int i = 0;
            while (i < oldCommands.length) {
                ICommand oldCommand = oldCommands[i];
                ICommand newCommand = newCommands[i];
                String oldName = oldCommand.getBuilderName();
                String newName = newCommand.getBuilderName();
                if (oldName == null && newName != null) {
                    return true;
                }
                if (oldName != null && !oldName.equals(newName)) {
                    return true;
                }
                Map oldArgs = oldCommand.getArguments();
                Map newArgs = newCommand.getArguments();
                if (oldArgs == null && newArgs != null) {
                    return true;
                }
                if (oldArgs != null || newArgs != null) {
                    if (oldArgs.size() != newArgs.size()) {
                        return true;
                    }
                    Iterator keySet = oldArgs.keySet().iterator();
                    while (keySet.hasNext()) {
                        Object key = keySet.next();
                        if (oldArgs.get(key).equals(newArgs.get(key))) continue;
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return true;
        }
        return false;
    }

    private void updateCommandItem(TableItem item, ICommand command) {
        String builderID = command.getBuilderName();
        if (builderID.equals("org.eclipse.ui.externaltools.ExternalToolBuilder")) {
            ILaunchConfiguration config = ExternalToolsUtil.configFromBuildCommandArgs(command.getArguments());
            if (config == null) {
                item.setText(ExternalToolsUIMessages.getString("BuilderPropertyPage.invalidBuildTool"));
                item.setImage(this.invalidBuildToolImage);
                return;
            }
            item.setText(config.getName());
            Image configImage = this.debugModelPresentation.getImage((Object)config);
            if (configImage != null) {
                this.imagesToDispose.add(configImage);
                item.setImage(configImage);
            } else {
                item.setImage(this.builderImage);
            }
        } else {
            IExtension extension = Platform.getPluginRegistry().getExtension("org.eclipse.core.resources", "builders", builderID);
            String builderName = extension != null ? extension.getLabel() : MessageFormat.format(ExternalToolsUIMessages.getString("BuilderPropertyPage.missingBuilder"), builderID);
            item.setText(builderName);
            item.setImage(this.builderImage);
        }
    }

    public boolean performCancel() {
        Iterator iter = this.newConfigList.iterator();
        while (iter.hasNext()) {
            try {
                ((ILaunchConfiguration)iter.next()).delete();
            }
            catch (CoreException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        try {
            IFolder builderFolder = this.getBuilderFolder(false);
            if (builderFolder != null && builderFolder.exists() && builderFolder.members().length == 0) {
                builderFolder.delete(true, false, null);
            }
        }
        catch (CoreException e) {
            this.handleException((Exception)((Object)e));
        }
        return super.performCancel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ui.externaltools.builder_property_page_context");
    }

    static /* synthetic */ Table access$1(BuilderPropertyPage builderPropertyPage) {
        return builderPropertyPage.builderTable;
    }

    static /* synthetic */ void access$2(BuilderPropertyPage builderPropertyPage, TableItem tableItem, ILaunchConfiguration iLaunchConfiguration) {
        builderPropertyPage.updateConfigItem(tableItem, iLaunchConfiguration);
    }

    static /* synthetic */ List access$3(BuilderPropertyPage builderPropertyPage) {
        return builderPropertyPage.newConfigList;
    }

    private class ErrorConfig {
        ErrorConfig() {
        }
    }
}

