/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.registry;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariable;

public class ExternalToolVariableRegistry {
    static final String TAG_VARIABLE = "variable";
    static final String TAG_TAG = "tag";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_COMPONENT_CLASS = "componentClass";
    static final String TAG_EXPANDER_CLASS = "expanderClass";
    private SortedMap variables;
    protected String extensionPointId;

    public ExternalToolVariableRegistry() {
        this("toolVariables");
    }

    protected ExternalToolVariableRegistry(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.loadVariables();
    }

    protected final ExternalToolVariable findVariable(String tag) {
        return (ExternalToolVariable)this.variables.get(tag);
    }

    public final int getVariableCount() {
        return this.variables.size();
    }

    public ExternalToolVariable getVariable(String tag) {
        return this.findVariable(tag);
    }

    public ExternalToolVariable[] getVariables() {
        ExternalToolVariable[] results = new ExternalToolVariable[this.getVariableCount()];
        this.variables.values().toArray(results);
        return results;
    }

    private void loadVariables() {
        this.variables = new TreeMap();
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.ui.externaltools", this.extensionPointId);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(TAG_VARIABLE)) {
                        String tag = element.getAttribute(TAG_TAG);
                        String description = element.getAttribute(TAG_DESCRIPTION);
                        String className = element.getAttribute(TAG_EXPANDER_CLASS);
                        boolean valid = true;
                        if (tag == null || tag.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing tag attribute value for variable element.", null);
                        }
                        if (description == null || description.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing description attribute value for variable element.", null);
                        }
                        if (className == null || className.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing expander class attribute value for variable element.", null);
                        }
                        if (valid) {
                            this.variables.put(tag, this.newVariable(tag, description, element));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected ExternalToolVariable newVariable(String tag, String description, IConfigurationElement element) {
        return new ExternalToolVariable(tag, description, element);
    }
}

