/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.externaltools.internal.group.IGroupDialogPage;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.variable.AbstractVariableComponent;
import org.eclipse.ui.externaltools.internal.variable.DefaultVariableExpander;
import org.eclipse.ui.externaltools.internal.variable.IVariableComponent;
import org.eclipse.ui.externaltools.internal.variable.IVariableExpander;

public class ExternalToolVariable {
    private static final IVariableComponent defaultComponent = new DefaultVariableComponent(false);
    private String tag;
    private String description;
    private IConfigurationElement element;
    private IVariableExpander expander;

    ExternalToolVariable(String tag, String description, IConfigurationElement element) {
        this.tag = tag;
        this.description = description;
        this.element = element;
    }

    public IVariableExpander getExpander() {
        if (this.expander == null) {
            try {
                this.expander = (IVariableExpander)this.createObject("expanderClass");
            }
            catch (ClassCastException classCastException) {}
            if (this.expander == null) {
                return DefaultVariableExpander.getDefault();
            }
        }
        return this.expander;
    }

    protected final Object createObject(String attributeName) {
        try {
            return this.element.createExecutableExtension(attributeName);
        }
        catch (CoreException e) {
            ExternalToolsPlugin.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    public final IVariableComponent getComponent() {
        String className = this.element.getAttribute("componentClass");
        if (className == null || className.trim().length() == 0) {
            return defaultComponent;
        }
        Object component = this.createObject("componentClass");
        if (component == null) {
            return new DefaultVariableComponent(true);
        }
        return (IVariableComponent)component;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getTag() {
        return this.tag;
    }

    private static final class DefaultVariableComponent
    extends AbstractVariableComponent {
        private boolean showError = false;
        private Label message = null;

        public DefaultVariableComponent(boolean showError) {
            this.showError = showError;
        }

        public Control getControl() {
            return this.message;
        }

        public void createContents(Composite parent, String varTag, IGroupDialogPage page) {
            if (this.showError) {
                this.message = new Label(parent, 0);
                GridData data = new GridData(256);
                this.message.setLayoutData((Object)data);
                this.message.setFont(parent.getFont());
                this.message.setText(ExternalToolsModelMessages.getString("ExternalToolVariable.componentErrorMessage"));
                this.message.setForeground(JFaceColors.getErrorText((Display)this.message.getDisplay()));
            }
        }
    }
}

