/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.registry;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.externaltools.internal.model.ToolUtil;

public final class ExternalToolMigration {
    public static final String RUN_TARGETS_ATTRIBUTE = "antBuildType.runTargets";
    private static final String TAG_TOOL_TYPE = "!{tool_type}";
    private static final String TAG_TOOL_NAME = "!{tool_name}";
    private static final String TAG_TOOL_LOCATION = "!{tool_loc}";
    private static final String TAG_TOOL_ARGUMENTS = "!{tool_args}";
    private static final String TAG_TOOL_DIRECTORY = "!{tool_dir}";
    private static final String TAG_TOOL_REFRESH = "!{tool_refresh}";
    private static final String TAG_TOOL_SHOW_LOG = "!{tool_show_log}";
    private static final String TAG_TOOL_BUILD_TYPES = "!{tool_build_types}";
    private static final String TAG_TOOL_BLOCK = "!{tool_block}";
    private static final String TOOL_TYPE_ANT = "org.eclipse.ui.externaltools.type.ant";
    private static final String TAG_TYPE = "type";
    private static final String TAG_NAME = "name";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_WORK_DIR = "workDirectory";
    private static final String TAG_CAPTURE_OUTPUT = "captureOutput";
    private static final String TAG_SHOW_CONSOLE = "showConsole";
    private static final String TAG_RUN_BKGRND = "runInBackground";
    private static final String TAG_PROMPT_ARGS = "promptForArguments";
    private static final String TAG_ARGS = "arguments";
    private static final String TAG_REFRESH_SCOPE = "refreshScope";
    private static final String TAG_REFRESH_RECURSIVE = "refreshRecursive";
    private static final String TAG_RUN_BUILD_KINDS = "runForBuildKinds";
    private static final String TAG_EXTRA_ATTR = "extraAttribute";
    private static final String TAG_VERSION = "version";
    private static final String EXTRA_ATTR_SEPARATOR = "=";
    private static final String VERSION_21 = "2.1";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    private ExternalToolMigration() {
    }

    public static ILaunchConfigurationWorkingCopy configFromArgumentMap(Map args) {
        String version = (String)args.get(TAG_VERSION);
        if (VERSION_21.equals(version)) {
            return ExternalToolMigration.configFrom21ArgumentMap(args);
        }
        return ExternalToolMigration.configFrom20ArgumentMap(args);
    }

    public static ILaunchConfigurationWorkingCopy configFrom21ArgumentMap(Map commandArgs) {
        String extraAttributes;
        String name = (String)commandArgs.get(TAG_NAME);
        String type = (String)commandArgs.get(TAG_TYPE);
        ILaunchConfigurationWorkingCopy config = ExternalToolMigration.newConfig(type, name);
        if (config == null) {
            return null;
        }
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", (String)commandArgs.get(TAG_LOCATION));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", (String)commandArgs.get(TAG_WORK_DIR));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", TRUE.equals((String)commandArgs.get(TAG_CAPTURE_OUTPUT)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", TRUE.equals((String)commandArgs.get(TAG_SHOW_CONSOLE)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND", TRUE.equals((String)commandArgs.get(TAG_RUN_BKGRND)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_PROMPT_FOR_ARGUMENTS", TRUE.equals((String)commandArgs.get(TAG_PROMPT_ARGS)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_REFRESH_SCOPE", (String)commandArgs.get(TAG_REFRESH_SCOPE));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_REFRESH_RECURSIVE", TRUE.equals((String)commandArgs.get(TAG_REFRESH_RECURSIVE)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", (String)commandArgs.get(TAG_RUN_BUILD_KINDS));
        String args = (String)commandArgs.get(TAG_ARGS);
        if (args != null) {
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        }
        if ((extraAttributes = (String)commandArgs.get(TAG_EXTRA_ATTR)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(extraAttributes, EXTRA_ATTR_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String key = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) break;
                String value = tokenizer.nextToken();
                if (!key.equals(RUN_TARGETS_ATTRIBUTE)) continue;
                config.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", value);
            }
        }
        return config;
    }

    public static ILaunchConfigurationWorkingCopy configFrom20ArgumentMap(Map args) {
        String refresh;
        String name;
        String type = (String)args.get(TAG_TOOL_TYPE);
        type = TOOL_TYPE_ANT.equals(type) ? "antBuildType" : "programType";
        ILaunchConfigurationWorkingCopy config = ExternalToolMigration.newConfig(type, name = (String)args.get(TAG_TOOL_NAME));
        if (config == null) {
            return null;
        }
        String location = (String)args.get(TAG_TOOL_LOCATION);
        if (location != null) {
            ToolUtil.VariableDefinition varDef = ToolUtil.extractVariableTag(location, 0);
            if ("workspace_loc".equals(varDef.name)) {
                location = ToolUtil.buildVariableTag("resource_loc", varDef.argument);
            }
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        }
        if ((refresh = (String)args.get(TAG_TOOL_REFRESH)) != null) {
            ToolUtil.VariableDefinition varDef = ToolUtil.extractVariableTag(refresh, 0);
            if ("none".equals(varDef.name)) {
                refresh = null;
            }
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_REFRESH_SCOPE", refresh);
        }
        String arguments = (String)args.get(TAG_TOOL_ARGUMENTS);
        String targetNames = null;
        if (arguments != null) {
            int start = 0;
            ArrayList<String> targets = new ArrayList<String>();
            StringBuffer buffer = new StringBuffer();
            ToolUtil.VariableDefinition varDef = ToolUtil.extractVariableTag(arguments, start);
            while (varDef.end != -1) {
                if ("ant_target".equals(varDef.name) && varDef.argument != null) {
                    targets.add(varDef.argument);
                    buffer.append(arguments.substring(start, varDef.start));
                } else {
                    buffer.append(arguments.substring(start, varDef.end));
                }
                start = varDef.end;
                varDef = ToolUtil.extractVariableTag(arguments, start);
            }
            buffer.append(arguments.substring(start, arguments.length()));
            arguments = buffer.toString();
            buffer.setLength(0);
            int i = 0;
            while (i < targets.size()) {
                String target = (String)targets.get(i);
                if (target != null && target.length() > 0) {
                    buffer.append(target);
                    buffer.append(",");
                }
                ++i;
            }
            targetNames = buffer.toString();
        }
        if (targetNames != null && targetNames.length() > 0) {
            config.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetNames);
        }
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_SHOW_CONSOLE", TRUE.equals((String)args.get(TAG_TOOL_SHOW_LOG)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_CAPTURE_OUTPUT", TRUE.equals((String)args.get(TAG_TOOL_SHOW_LOG)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_IN_BACKGROUND", FALSE.equals((String)args.get(TAG_TOOL_BLOCK)));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", (String)args.get(TAG_TOOL_BUILD_TYPES));
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        config.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", (String)args.get(TAG_TOOL_DIRECTORY));
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static ILaunchConfigurationWorkingCopy newConfig(String type, String name) {
        ILaunchConfigurationType configType;
        if (type == null || name == null) {
            return null;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        if ("antBuildType".equals(type)) {
            configType = manager.getLaunchConfigurationType("org.eclipse.ant.AntBuilderLaunchConfigurationType");
        } else if ("programType".equals(type)) {
            configType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramBuilderLaunchConfigurationType");
        } else {
            return null;
        }
        try {
            void var3_3;
            return var3_3.newInstance(null, name);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getNameFromCommandArgs(Map commandArgs) {
        String name = (String)commandArgs.get(TAG_NAME);
        if (name == null) {
            name = (String)commandArgs.get(TAG_TOOL_NAME);
        }
        return name;
    }
}

