/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.program.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;

public class BackgroundResourceRefresher
implements IDebugEventSetListener,
Runnable,
IRunnableWithProgress {
    private ExpandVariableContext fContext;
    private ILaunchConfiguration fConfiguration;
    private IProcess fProcess;

    public BackgroundResourceRefresher(ILaunchConfiguration configuration, IProcess process, ExpandVariableContext context) {
        this.fConfiguration = configuration;
        this.fProcess = process;
        this.fContext = context;
    }

    public void startBackgroundRefresh() {
        IProcess iProcess = this.fProcess;
        synchronized (iProcess) {
            if (this.fProcess.isTerminated()) {
                this.refresh();
            } else {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() == this.fProcess && event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.refresh();
                break;
            }
            ++i;
        }
    }

    protected void refresh() {
        ExternalToolsPlugin.getStandardDisplay().asyncExec((Runnable)this);
    }

    public void run() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExternalToolsPlugin.getStandardDisplay().getActiveShell());
        try {
            dialog.run(true, true, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ExternalToolsUtil.refreshResources(this.fConfiguration, this.fContext, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

