/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariable;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariableRegistry;
import org.eclipse.ui.externaltools.internal.variable.ExpandVariableContext;

public final class ToolUtil {
    private static final char ARG_DELIMITER = ' ';
    private static final char ARG_DBL_QUOTE = '\"';
    private static final char VAR_TAG_START_CHAR1 = '$';
    private static final char VAR_TAG_START_CHAR2 = '{';
    private static final char VAR_TAG_END_CHAR1 = '}';
    private static final String VAR_TAG_START = "${";
    private static final String VAR_TAG_END = "}";
    private static final String VAR_TAG_SEP = ":";

    private ToolUtil() {
    }

    public static String buildVariableTag(String varName, String varArgument) {
        StringBuffer buf = new StringBuffer();
        ToolUtil.buildVariableTag(varName, varArgument, buf);
        return buf.toString();
    }

    public static void buildVariableTag(String varName, String varArgument, StringBuffer buffer) {
        buffer.append(VAR_TAG_START);
        buffer.append(varName);
        if (varArgument != null && varArgument.length() > 0) {
            buffer.append(VAR_TAG_SEP);
            buffer.append(varArgument);
        }
        buffer.append(VAR_TAG_END);
    }

    public static String expandArgument(String argument, ExpandVariableContext context, MultiStatus status) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        while (true) {
            VariableDefinition varDef = ToolUtil.extractVariableTag(argument, start);
            if (varDef.start == -1) {
                if (start == 0) {
                    buffer.append(argument);
                    break;
                }
                buffer.append(argument.substring(start));
                break;
            }
            if (varDef.end == -1 || varDef.name == null || varDef.name.length() == 0) {
                String msg = ExternalToolsModelMessages.getString("ToolUtil.argumentVarFormatWrong");
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            if (varDef.start > start) {
                buffer.append(argument.substring(start, varDef.start));
            }
            start = varDef.end;
            ExternalToolVariableRegistry registry = ExternalToolsPlugin.getDefault().getToolVariableRegistry();
            ExternalToolVariable variable = registry.getVariable(varDef.name);
            if (variable == null) {
                String msg = MessageFormat.format(ExternalToolsModelMessages.getString("ToolUtil.argumentVarMissing"), varDef.name);
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            String text = null;
            try {
                text = variable.getExpander().getText(varDef.name, varDef.argument, context);
            }
            catch (CoreException exception) {
                status.merge(exception.getStatus());
                return null;
            }
            buffer.append(text);
        }
        return buffer.toString();
    }

    public static String[] expandArguments(String arguments, ExpandVariableContext context, MultiStatus status) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] argList = ToolUtil.parseArgumentsIntoList(arguments);
        int i = 0;
        while (i < argList.length) {
            argList[i] = ToolUtil.expandArgument(argList[i], context, status);
            ++i;
        }
        return argList;
    }

    public static String expandDirectoryLocation(String dirLocation, ExpandVariableContext context, MultiStatus status) {
        if (dirLocation == null || dirLocation.length() == 0) {
            return "";
        }
        VariableDefinition varDef = ToolUtil.extractVariableTag(dirLocation, 0);
        if (varDef.start < 0) {
            return dirLocation;
        }
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        while (varDef.start >= 0) {
            if (varDef.name == null || varDef.name.length() == 0 || varDef.end == -1) {
                String msg = ExternalToolsModelMessages.getString("ToolUtil.dirLocVarFormatWrong");
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            buffer.append(dirLocation.substring(start, varDef.start));
            ExternalToolVariableRegistry registry = ExternalToolsPlugin.getDefault().getToolVariableRegistry();
            ExternalToolVariable variable = registry.getVariable(varDef.name);
            if (variable == null) {
                String msg = MessageFormat.format(ExternalToolsModelMessages.getString("ToolUtil.dirLocVarMissing"), varDef.name);
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            IPath path = null;
            try {
                path = variable.getExpander().getPath(varDef.name, varDef.argument, context);
            }
            catch (CoreException exception) {
                status.merge(exception.getStatus());
                return null;
            }
            buffer.append(path.toOSString());
            start = varDef.end;
            varDef = ToolUtil.extractVariableTag(dirLocation, start);
        }
        buffer.append(dirLocation.substring(start));
        return buffer.toString();
    }

    public static String expandFileLocation(String fileLocation, ExpandVariableContext context, MultiStatus status) {
        if (fileLocation == null || fileLocation.length() == 0) {
            return "";
        }
        VariableDefinition varDef = ToolUtil.extractVariableTag(fileLocation, 0);
        if (varDef.start < 0) {
            return fileLocation;
        }
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        while (varDef.start >= 0) {
            if (varDef.name == null || varDef.name.length() == 0 || varDef.end == -1) {
                String msg = ExternalToolsModelMessages.getString("ToolUtil.fileLocVarFormatWrong");
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            buffer.append(fileLocation.substring(start, varDef.start));
            ExternalToolVariableRegistry registry = ExternalToolsPlugin.getDefault().getToolVariableRegistry();
            ExternalToolVariable variable = registry.getVariable(varDef.name);
            if (variable == null) {
                String msg = MessageFormat.format(ExternalToolsModelMessages.getString("ToolUtil.fileLocVarMissing"), varDef.name);
                status.merge(ExternalToolsPlugin.newErrorStatus(msg, null));
                return null;
            }
            IPath path = null;
            try {
                path = variable.getExpander().getPath(varDef.name, varDef.argument, context);
            }
            catch (CoreException exception) {
                status.merge(exception.getStatus());
                return null;
            }
            buffer.append(path.toOSString());
            start = varDef.end;
            varDef = ToolUtil.extractVariableTag(fileLocation, start);
        }
        buffer.append(fileLocation.substring(start));
        return buffer.toString();
    }

    public static VariableDefinition extractVariableTag(String text, int start) {
        VariableDefinition varDef = new VariableDefinition();
        varDef.start = text.indexOf(VAR_TAG_START, start);
        if (varDef.start < 0) {
            return varDef;
        }
        start = varDef.start + VAR_TAG_START.length();
        int end = text.indexOf(VAR_TAG_END, start);
        if (end < 0) {
            return varDef;
        }
        varDef.end = end + VAR_TAG_END.length();
        if (end == start) {
            return varDef;
        }
        int mid = text.indexOf(VAR_TAG_SEP, start);
        if (mid < 0 || mid > end) {
            varDef.name = text.substring(start, end);
        } else {
            if (mid > start) {
                varDef.name = text.substring(start, mid);
            }
            if ((mid += VAR_TAG_SEP.length()) < end) {
                varDef.argument = text.substring(mid, end);
            }
        }
        return varDef;
    }

    public static String[] parseArgumentsIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(10);
        boolean inQuotes = false;
        boolean inVar = false;
        int start = 0;
        int end = arguments.length();
        StringBuffer buffer = new StringBuffer(end);
        block6: while (start < end) {
            char ch = arguments.charAt(start);
            ++start;
            switch (ch) {
                case ' ': {
                    if (inQuotes || inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (buffer.length() <= 0) continue block6;
                    list.add(buffer.toString());
                    buffer.setLength(0);
                    break;
                }
                case '\"': {
                    if (inVar) {
                        buffer.append(ch);
                        break;
                    }
                    if (start < end) {
                        if (arguments.charAt(start) == '\"') {
                            buffer.append(ch);
                            ++start;
                            break;
                        }
                        inQuotes = !inQuotes;
                        break;
                    }
                    inQuotes = false;
                    break;
                }
                case '$': {
                    buffer.append(ch);
                    if (inVar || start >= end || arguments.charAt(start) != '{') continue block6;
                    buffer.append('{');
                    inVar = true;
                    ++start;
                    break;
                }
                case '}': {
                    buffer.append(ch);
                    inVar = false;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }

    public static final class VariableDefinition {
        public int start = -1;
        public int end = -1;
        public String name = null;
        public String argument = null;

        private VariableDefinition() {
        }
    }
}

