/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.externaltools.internal.ant.editor.text.IAntEditorColorConstants;
import org.eclipse.ui.externaltools.internal.ant.preferences.AntEditorPreferenceConstants;
import org.eclipse.ui.externaltools.internal.model.ColorManager;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.model.VariableContextManager;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolVariableRegistry;
import org.eclipse.ui.externaltools.internal.registry.RefreshScopeVariableRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ExternalToolsPlugin
extends AbstractUIPlugin {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.ui.externaltools", 0, "", null);
    private static ExternalToolsPlugin plugin;
    private RefreshScopeVariableRegistry refreshVarRegistry;
    private ExternalToolVariableRegistry toolVariableRegistry;
    private static final String EMPTY_STRING = "";

    public ExternalToolsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static ExternalToolsPlugin getDefault() {
        return plugin;
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = EMPTY_STRING;
        }
        return new Status(4, "org.eclipse.ui.externaltools", 0, message, exception);
    }

    public static CoreException newError(String message, Throwable exception) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", 0, message, exception));
    }

    public ExternalToolVariableRegistry getToolVariableRegistry() {
        if (this.toolVariableRegistry == null) {
            this.toolVariableRegistry = new ExternalToolVariableRegistry();
        }
        return this.toolVariableRegistry;
    }

    public RefreshScopeVariableRegistry getRefreshVariableRegistry() {
        if (this.refreshVarRegistry == null) {
            this.refreshVarRegistry = new RefreshScopeVariableRegistry();
        }
        return this.refreshVarRegistry;
    }

    public void log(String message, Throwable exception) {
        IStatus status = ExternalToolsPlugin.newErrorStatus(message, exception);
        this.getLog().log(status);
    }

    public void log(Throwable exception) {
        this.getLog().log(ExternalToolsPlugin.newErrorStatus("Internal error logged from External Tools UI: ", exception));
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            URL installURL = this.getDescriptor().getInstallURL();
            URL url = new URL(installURL, path);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore prefs) {
        prefs.setDefault("externaltools.builders.promptForMigration", true);
        prefs.setDefault("ant.findBuildFileNames", "build.xml");
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"externaltools.console.errorColor", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"externaltools.console.warningColor", (RGB)new RGB(255, 100, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"externaltools.console.infoColor", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"externaltools.console.verboseColor", (RGB)new RGB(0, 200, 125));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"externaltools.console.debugColor", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"planty.color.default", (RGB)IAntEditorColorConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"planty.color.instr", (RGB)IAntEditorColorConstants.PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"planty.color.string", (RGB)IAntEditorColorConstants.STRING);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"planty.color.tag", (RGB)IAntEditorColorConstants.TAG);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"planty.color.xml_comment", (RGB)IAntEditorColorConstants.XML_COMMENT);
        AntEditorPreferenceConstants.initializeDefaultValues(prefs);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return ExternalToolsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = ExternalToolsPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected ImageRegistry createImageRegistry() {
        return ExternalToolsImages.initializeImageRegistry();
    }

    public void startup() throws CoreException {
        super.startup();
        ExternalToolsPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                VariableContextManager.getDefault();
            }
        });
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        ColorManager.getDefault().dispose();
        ExternalToolsImages.disposeImageDescriptorRegistry();
    }

    public static Color getPreferenceColor(String pref) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)ExternalToolsPlugin.getDefault().getPreferenceStore(), (String)pref));
    }
}

